/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.css.editor.CssPropertyValue;
import org.netbeans.modules.css.editor.Property;
import org.netbeans.modules.css.editor.PropertyModel;
import org.netbeans.modules.css.editor.properties.CustomErrorMessageProvider;
import org.netbeans.modules.css.gsf.CSSParserResult;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.spi.DefaultError;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssAnalyser {
    private static final String UNKNOWN_PROPERTY = "unknown_property";
    private static final String INVALID_PROPERTY_VALUE = "invalid_property_value";
    private CSSParserResult result;

    public CssAnalyser(CSSParserResult cSSParserResult) {
        this.result = cSSParserResult;
    }

    public List<Error> checkForErrors(SimpleNode simpleNode) {
        final ArrayList<Error> arrayList = new ArrayList<Error>();
        final PropertyModel propertyModel = PropertyModel.instance();
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                if (simpleNode.kind() == 28) {
                    SimpleNode simpleNode2 = SimpleNodeUtil.getChildByType(simpleNode, 17);
                    SimpleNode simpleNode3 = SimpleNodeUtil.getChildByType(simpleNode, 30);
                    if (simpleNode2 != null) {
                        CssPropertyValue cssPropertyValue;
                        String string;
                        String string2 = simpleNode2.image().trim();
                        Property property = propertyModel.getProperty(string2);
                        if (!CssAnalyser.isVendorSpecificProperty(string2) && property == null) {
                            string = new DefaultError(CssAnalyser.UNKNOWN_PROPERTY, NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.UNKNOWN_PROPERTY, (Object)string2), null, CssAnalyser.this.result.getFile().getFileObject(), simpleNode2.startOffset(), simpleNode2.endOffset(), Severity.WARNING);
                            arrayList.add(string);
                        }
                        if (simpleNode3 != null && property != null && !(cssPropertyValue = new CssPropertyValue(property, string = simpleNode3.image().trim())).success()) {
                            String string3 = null;
                            if (cssPropertyValue instanceof CustomErrorMessageProvider) {
                                string3 = ((CustomErrorMessageProvider)((Object)cssPropertyValue)).customErrorMessage();
                            }
                            String string4 = cssPropertyValue.left().get(cssPropertyValue.left().size() - 1);
                            if (string3 == null) {
                                string3 = NbBundle.getMessage(CssAnalyser.class, (String)CssAnalyser.INVALID_PROPERTY_VALUE, (Object)string4);
                            }
                            DefaultError defaultError = new DefaultError(CssAnalyser.INVALID_PROPERTY_VALUE, string3, null, CssAnalyser.this.result.getFile().getFileObject(), simpleNode3.startOffset(), simpleNode3.endOffset(), Severity.WARNING);
                            arrayList.add(defaultError);
                        }
                    }
                }
            }
        };
        SimpleNodeUtil.visitChildren(simpleNode, nodeVisitor);
        return arrayList;
    }

    public static boolean isVendorSpecificProperty(String string) {
        return string.startsWith("_") || string.startsWith("-");
    }
}

