/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;

public class TreeObjectListProxyListener
implements PropertyChangeListener {
    private final TreeObjectList list;
    private PropertyChangeSupport changeSupport;

    public TreeObjectListProxyListener(TreeObjectList treeObjectList) {
        this.list = treeObjectList;
        treeObjectList.addPropertyChangeListener(this);
        Iterator iterator = treeObjectList.iterator();
        while (iterator.hasNext()) {
            TreeObject treeObject = (TreeObject)iterator.next();
            if (treeObject == null) continue;
            treeObject.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (object == this.list) {
            TreeObject treeObject;
            if ("contentInsert".equals(string)) {
                TreeObject treeObject2 = (TreeObject)propertyChangeEvent.getNewValue();
                if (treeObject2 != null) {
                    treeObject2.addPropertyChangeListener(this);
                }
            } else if ("contentRemove".equals(string) && (treeObject = (TreeObject)propertyChangeEvent.getOldValue()) != null) {
                treeObject.removePropertyChangeListener(this);
            }
        }
        this.forward(propertyChangeEvent);
    }

    private void forward(PropertyChangeEvent propertyChangeEvent) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        TreeObjectListProxyListener treeObjectListProxyListener = this;
        synchronized (treeObjectListProxyListener) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

