/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.beaninfo.BIEditorSupport;
import org.netbeans.modules.beans.beaninfo.BeanInfoSource;
import org.netbeans.modules.beans.beaninfo.BiFeature;
import org.netbeans.modules.beans.beaninfo.GenerateBeanInfoAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BiAnalyser {
    private static final String TAB = "    ";
    private static final String TABx2 = "        ";
    private static final String TABx3 = "            ";
    private static final String NOI18N_COMMENT = " // NOI18N";
    private static final String ICONNAME_C16 = "iconNameC16";
    private static final String ICONNAME_C32 = "iconNameC32";
    private static final String ICONNAME_M16 = "iconNameM16";
    private static final String ICONNAME_M32 = "iconNameM32";
    private static final String DEFAULT_PROPERTY_INDEX = "defaultPropertyIndex";
    private static final String DEFAULT_EVENT_INDEX = "defaultEventIndex";
    List<BiFeature.Descriptor> descriptor;
    List<BiFeature.Property> properties;
    List<BiFeature.IdxProperty> idxProperties;
    List<BiFeature.EventSet> eventSets;
    List<BiFeature.Method> methods;
    BeanInfoSource bis;
    private boolean nullDescriptor = false;
    private boolean nullProperties = false;
    private boolean nullEventSets = false;
    private boolean nullMethods = false;
    private boolean lazyDescriptor = true;
    private boolean lazyProperties = true;
    private boolean lazyEventSets = true;
    private boolean lazyMethods = true;
    private final boolean olderVersion;
    private boolean superClassVersion = true;
    private String classfqn;
    private String iconC16;
    private String iconM16;
    private String iconC32;
    private String iconM32;
    private int defaultPropertyIndex = -1;
    private int defaultEventIndex = -1;
    private boolean useSuperClass = false;
    private boolean isModified = false;
    private boolean isUpdateMode;
    private boolean isBeanBroken;

    private int getIndexOfMethod(List<BiFeature.Method> list, ElementHandle<ExecutableElement> elementHandle) {
        if (elementHandle == null) {
            return -1;
        }
        int n = 0;
        for (BiFeature.Method method : list) {
            if (elementHandle.equals(method.getElement())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BiAnalyser(PatternAnalyser patternAnalyser, CompilationInfo compilationInfo) throws GenerateBeanException {
        int n;
        List<EventSetPattern> list;
        this.isBeanBroken = !compilationInfo.getDiagnostics().isEmpty();
        this.bis = new BeanInfoSource(patternAnalyser.getFileObject());
        this.olderVersion = this.bis.isNbBeanInfo() && this.bis.getMethodsSection() == null;
        this.superClassVersion = this.bis.isNbSuperclass() || !this.bis.exists();
        TypeElement typeElement = (TypeElement)patternAnalyser.getClassElementHandle().resolve(compilationInfo);
        this.classfqn = typeElement.getQualifiedName().toString();
        this.descriptor = new ArrayList<BiFeature.Descriptor>();
        this.descriptor.add(new BiFeature.Descriptor(typeElement, this));
        this.methods = new ArrayList<BiFeature.Method>();
        if (!this.olderVersion) {
            for (ExecutableElement list22 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                this.methods.add(new BiFeature.Method(list22, patternAnalyser, compilationInfo, this));
            }
        }
        List<PropertyPattern> list3 = patternAnalyser.getPropertyPatterns();
        this.properties = new ArrayList<BiFeature.Property>(list3.size());
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            list = (PropertyPattern)iterator.next();
            this.properties.add(new BiFeature.Property((PropertyPattern)((Object)list), compilationInfo, this));
            for (int idxPropertyPattern = 0; idxPropertyPattern < this.methods.size(); ++idxPropertyPattern) {
                n = this.getIndexOfMethod(this.methods, ((PropertyPattern)((Object)list)).getGetterMethod());
                if (n != -1) {
                    this.methods.remove(n);
                }
                if ((n = this.getIndexOfMethod(this.methods, ((PropertyPattern)((Object)list)).getSetterMethod())) == -1) continue;
                this.methods.remove(n);
            }
        }
        List<IdxPropertyPattern> list2 = patternAnalyser.getIdxPropertyPatterns();
        this.idxProperties = new ArrayList<BiFeature.IdxProperty>(list2.size());
        for (IdxPropertyPattern idxPropertyPattern : list2) {
            TypeMirror typeMirror = idxPropertyPattern.getType().resolve(compilationInfo);
            TypeMirror typeMirror2 = idxPropertyPattern.getIndexedType().resolve(compilationInfo);
            if (typeMirror.getKind() != TypeKind.ARRAY || !compilationInfo.getTypes().isSameType(((ArrayType)typeMirror).getComponentType(), typeMirror2)) continue;
            this.idxProperties.add(new BiFeature.IdxProperty(idxPropertyPattern, compilationInfo, this));
            n = this.getIndexOfMethod(this.methods, idxPropertyPattern.getGetterMethod());
            if (n != -1) {
                this.methods.remove(n);
            }
            if ((n = this.getIndexOfMethod(this.methods, idxPropertyPattern.getSetterMethod())) != -1) {
                this.methods.remove(n);
            }
            if ((n = this.getIndexOfMethod(this.methods, idxPropertyPattern.getIndexedGetterMethod())) != -1) {
                this.methods.remove(n);
            }
            if ((n = this.getIndexOfMethod(this.methods, idxPropertyPattern.getIndexedSetterMethod())) == -1) continue;
            this.methods.remove(n);
        }
        list = patternAnalyser.getEventSetPatterns();
        this.eventSets = new ArrayList<BiFeature.EventSet>(list.size());
        for (EventSetPattern eventSetPattern : list) {
            this.eventSets.add(new BiFeature.EventSet(eventSetPattern, compilationInfo, this));
            n = this.getIndexOfMethod(this.methods, eventSetPattern.getRemoveListenerMethod());
            if (n != -1) {
                this.methods.remove(n);
            }
            if ((n = this.getIndexOfMethod(this.methods, eventSetPattern.getAddListenerMethod())) == -1) continue;
            this.methods.remove(n);
        }
        try {
            this.isUpdateMode = false;
            this.analyzeBeanInfoSource();
        }
        finally {
            this.isUpdateMode = true;
        }
    }

    List<BiFeature.Descriptor> getDescriptor() {
        return this.descriptor;
    }

    List<BiFeature.Property> getProperties() {
        return this.properties;
    }

    List<BiFeature.IdxProperty> getIdxProperties() {
        return this.idxProperties;
    }

    List<BiFeature.EventSet> getEventSets() {
        return this.eventSets;
    }

    List<BiFeature.Method> getMethods() {
        return this.methods;
    }

    public boolean isOlderVersion() {
        return this.olderVersion;
    }

    public boolean isSuperclassVersion() {
        return this.superClassVersion;
    }

    public String getIconC16() {
        return this.iconC16;
    }

    public void setIconC16(String string) {
        this.iconC16 = string;
        this.setModified();
    }

    public String getIconM16() {
        return this.iconM16;
    }

    public void setIconM16(String string) {
        this.iconM16 = string;
        this.setModified();
    }

    public String getIconC32() {
        return this.iconC32;
    }

    public void setIconC32(String string) {
        this.iconC32 = string;
        this.setModified();
    }

    public String getIconM32() {
        return this.iconM32;
    }

    public void setIconM32(String string) {
        this.iconM32 = string;
        this.setModified();
    }

    public int getDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    public void setDefaultPropertyIndex(int n) {
        this.defaultPropertyIndex = n;
        this.setModified();
    }

    public int getDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    public void setDefaultEventIndex(int n) {
        this.defaultEventIndex = n;
        this.setModified();
    }

    public boolean isUseSuperClass() {
        return this.useSuperClass;
    }

    public void setUseSuperClass(boolean bl) {
        this.useSuperClass = bl;
        this.setModified();
    }

    boolean isNullDescriptor() {
        return this.nullDescriptor;
    }

    boolean isNullProperties() {
        return this.nullProperties;
    }

    boolean isNullMethods() {
        return this.nullMethods;
    }

    void setNullDescriptor(boolean bl) {
        this.nullDescriptor = bl;
        this.setModified();
    }

    void setNullProperties(boolean bl) {
        this.nullProperties = bl;
        this.setModified();
    }

    void setNullMethods(boolean bl) {
        this.nullMethods = bl;
        this.setModified();
    }

    boolean isNullEventSets() {
        return this.nullEventSets;
    }

    void setNullEventSets(boolean bl) {
        this.nullEventSets = bl;
        this.setModified();
    }

    public boolean isLazyDescriptor() {
        return this.lazyDescriptor;
    }

    public boolean isLazyProperties() {
        return this.lazyProperties;
    }

    public boolean isLazyMethods() {
        return this.lazyMethods;
    }

    public void setLazyDescriptor(boolean bl) {
        this.lazyDescriptor = bl;
        this.setModified();
    }

    public void setLazyProperties(boolean bl) {
        this.lazyProperties = bl;
        this.setModified();
    }

    public void setLazyMethods(boolean bl) {
        this.lazyMethods = bl;
        this.setModified();
    }

    public boolean isLazyEventSets() {
        return this.lazyEventSets;
    }

    public void setLazyEventSets(boolean bl) {
        this.lazyEventSets = bl;
        this.setModified();
    }

    void regenerateSource() {
        if (this.bis.exists() && !this.bis.isNbBeanInfo()) {
            throw new IllegalStateException();
        }
        DataObject dataObject = this.bis.getDataObject();
        EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
        final StyledDocument styledDocument = editorCookie.getDocument();
        Runnable runnable = new Runnable(){

            public void run() {
                BiAnalyser.this.regenerateSourceImpl(styledDocument);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        }
    }

    void regenerateSourceImpl(StyledDocument styledDocument) {
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

            public void run() {
                BiAnalyser.this.regenerateBeanDescriptor();
                BiAnalyser.this.regenerateProperties();
                BiAnalyser.this.regenerateEvents();
                if (!BiAnalyser.this.olderVersion) {
                    BiAnalyser.this.regenerateMethods();
                }
                BiAnalyser.this.regenerateIcons();
                BiAnalyser.this.regenerateDefaultIdx();
                BiAnalyser.this.regenerateSuperclass();
                BiAnalyser.this.isModified = false;
            }
        });
    }

    void openSource() {
        if (this.bis.exists()) {
            if (!this.bis.isNbBeanInfo()) {
                if (this.isBeanBroken) {
                    String string = NbBundle.getMessage(BiAnalyser.class, (String)"MSG_BrokenBean", (Object)this.bis.getSourceDataObject().getPrimaryFile().getNameExt());
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                String string = GenerateBeanInfoAction.getString("MSG_BeanInfoExists");
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (!confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    return;
                }
                try {
                    this.bis.delete();
                }
                catch (IOException iOException) {
                    string = GenerateBeanInfoAction.getString("MSG_BeanInfoCantDelete");
                    confirmation = new NotifyDescriptor.Message((Object)string);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    return;
                }
                this.bis.createFromTemplate(true);
                this.regenerateSource();
                BIEditorSupport bIEditorSupport = (BIEditorSupport)((Object)this.bis.getDataObject().getLookup().lookup(BIEditorSupport.class));
                try {
                    bIEditorSupport.saveDocument();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        } else {
            if (this.isBeanBroken) {
                String string = NbBundle.getMessage(BiAnalyser.class, (String)"MSG_BrokenBean", (Object)this.bis.getSourceDataObject().getPrimaryFile().getNameExt());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            String string = NbBundle.getMessage(BiAnalyser.class, (String)"MSG_BeanInfoNotExists");
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (!confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                return;
            }
            this.bis.createFromTemplate(true);
            this.regenerateSource();
            BIEditorSupport bIEditorSupport = (BIEditorSupport)((Object)this.bis.getDataObject().getLookup().lookup(BIEditorSupport.class));
            try {
                bIEditorSupport.saveDocument();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (!this.bis.isNbBeanInfo()) {
                return;
            }
        }
        this.bis.open();
    }

    private void regenerateBeanDescriptor() {
        StringBuilder stringBuilder = new StringBuilder(512);
        if (this.nullDescriptor) {
            stringBuilder.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullDescriptor"));
            stringBuilder.append("    private static BeanDescriptor beanDescriptor = null;\n");
            stringBuilder.append("    private static BeanDescriptor getBdescriptor(){\n\n");
            this.bis.setDescriptorSection(stringBuilder.toString(), "\n        return beanDescriptor;\n    }\n\n");
            return;
        }
        for (BiFeature.Descriptor descriptor : this.getDescriptor()) {
            if (!descriptor.isIncluded()) continue;
            stringBuilder.append(TAB + GenerateBeanInfoAction.getString("COMMENT_BeanDescriptor"));
            if (!this.lazyDescriptor) {
                stringBuilder.append("    private static BeanDescriptor beanDescriptor = ");
                stringBuilder.append(descriptor.getCreationString());
                stringBuilder.append(';');
                this.appendNoi18nText(stringBuilder);
                stringBuilder.append("\n\n");
                stringBuilder.append("    private static BeanDescriptor getBdescriptor(){\n");
                stringBuilder.append("        return beanDescriptor;\n    }\n\n");
                stringBuilder.append("    static {\n");
            } else {
                stringBuilder.append("    /*lazy BeanDescriptor*/\n");
                stringBuilder.append("    private static BeanDescriptor getBdescriptor(){\n");
                stringBuilder.append("        BeanDescriptor beanDescriptor = ");
                stringBuilder.append(descriptor.getCreationString());
                stringBuilder.append(';');
                this.appendNoi18nText(stringBuilder);
                stringBuilder.append('\n');
            }
            for (String string : descriptor.getCustomizationStrings()) {
                stringBuilder.append("        beanDescriptor.");
                stringBuilder.append(string).append(";\n");
            }
            if (!this.lazyDescriptor) {
                this.bis.setDescriptorSection(stringBuilder.toString(), "}\n");
                continue;
            }
            this.bis.setDescriptorSection(stringBuilder.toString(), "        return beanDescriptor;\n    }\n");
        }
    }

    private void regenerateProperties() {
        StringBuilder stringBuilder = new StringBuilder(512);
        int n = 0;
        if (this.nullProperties) {
            stringBuilder.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullProperties"));
            stringBuilder.append("    private static PropertyDescriptor[] properties = null;\n");
            stringBuilder.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            this.bis.setPropertiesSection(stringBuilder.toString(), "        return properties;\n    }\n\n");
            return;
        }
        TreeSet<BiFeature.Property> treeSet = new TreeSet<BiFeature.Property>(this.getProperties());
        treeSet.addAll(this.getIdxProperties());
        stringBuilder.append(TAB + GenerateBeanInfoAction.getString("COMMENT_PropertyIdentifiers"));
        for (BiFeature.Property property : treeSet) {
            if (!property.isIncluded()) continue;
            stringBuilder.append("    private static final int ");
            stringBuilder.append("PROPERTY_" + property.getName());
            stringBuilder.append(" = " + n++ + ";");
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_PropertyArray"));
        if (!this.lazyProperties) {
            stringBuilder.append("    private static PropertyDescriptor[] properties = new PropertyDescriptor[" + n + "];\n\n");
            stringBuilder.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            stringBuilder.append("        return properties;\n    }\n\n");
        } else {
            stringBuilder.append("    /*lazy PropertyDescriptor*/\n");
            stringBuilder.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            stringBuilder.append("        PropertyDescriptor[] properties = new PropertyDescriptor[");
            stringBuilder.append(n);
            stringBuilder.append("];\n");
        }
        if (n > 0) {
            if (!this.lazyProperties) {
                stringBuilder.append("    static {\n        try {\n");
            } else {
                stringBuilder.append("    \n        try {\n");
            }
        }
        for (BiFeature.Property property : treeSet) {
            if (!property.isIncluded()) continue;
            stringBuilder.append("            properties[PROPERTY_").append(property.getName()).append("] = ");
            stringBuilder.append(property.getCreationString());
            stringBuilder.append(';');
            this.appendNoi18nText(stringBuilder);
            stringBuilder.append('\n');
            for (String string : property.getCustomizationStrings()) {
                stringBuilder.append("            properties[PROPERTY_").append(property.getName()).append("].");
                stringBuilder.append(string).append(";\n");
            }
        }
        if (n > 0) {
            stringBuilder.append("        }\n        catch(IntrospectionException e) {\n            e.printStackTrace();\n        }");
        }
        if (!this.lazyProperties) {
            this.bis.setPropertiesSection(stringBuilder.toString(), n > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setPropertiesSection(stringBuilder.toString(), "        return properties;\n    }\n");
        }
    }

    private void regenerateMethods() {
        StringBuilder stringBuilder = new StringBuilder(512);
        int n = 0;
        if (this.nullMethods) {
            stringBuilder.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullMethods"));
            stringBuilder.append("    private static MethodDescriptor[] methods = null;\n");
            stringBuilder.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            this.bis.setMethodsSection(stringBuilder.toString(), "        return methods;\n    }\n\n");
            return;
        }
        TreeSet<BiFeature.Method> treeSet = new TreeSet<BiFeature.Method>(this.getMethods());
        stringBuilder.append(TAB + GenerateBeanInfoAction.getString("COMMENT_MethodIdentifiers"));
        for (BiFeature.Method method : treeSet) {
            if (!method.isIncluded()) continue;
            stringBuilder.append("    private static final int ");
            stringBuilder.append("METHOD_" + method.getName() + n);
            stringBuilder.append(" = " + n++ + ";");
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_MethodArray"));
        if (!this.lazyMethods) {
            stringBuilder.append("    private static MethodDescriptor[] methods = new MethodDescriptor[" + n + "];\n\n");
            stringBuilder.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            stringBuilder.append("        return methods;\n    }\n\n");
        } else {
            stringBuilder.append("    /*lazy MethodDescriptor*/\n");
            stringBuilder.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            stringBuilder.append("        MethodDescriptor[] methods = new MethodDescriptor[");
            stringBuilder.append(n);
            stringBuilder.append("];\n");
        }
        if (n > 0) {
            if (!this.lazyMethods) {
                stringBuilder.append("    static {\n        try {\n");
            } else {
                stringBuilder.append("    \n        try {\n");
            }
        }
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            BiFeature biFeature = (BiFeature)iterator.next();
            if (!biFeature.isIncluded()) continue;
            stringBuilder.append("            methods[METHOD_").append(biFeature.getName()).append(n3++ + "] = ");
            stringBuilder.append(biFeature.getCreationString());
            stringBuilder.append(';');
            this.appendNoi18nText(stringBuilder);
            stringBuilder.append('\n');
            for (String string : biFeature.getCustomizationStrings()) {
                stringBuilder.append("            methods[METHOD_").append(biFeature.getName()).append(n2 + "].");
                stringBuilder.append(string).append(";\n");
            }
            ++n2;
        }
        if (n > 0) {
            stringBuilder.append("        }\n        catch( Exception e) {}");
        }
        if (!this.lazyMethods) {
            this.bis.setMethodsSection(stringBuilder.toString(), n > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setMethodsSection(stringBuilder.toString(), "        return methods;\n    }\n");
        }
    }

    private void regenerateEvents() {
        StringBuilder stringBuilder = new StringBuilder(512);
        int n = 0;
        if (this.nullEventSets) {
            stringBuilder.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullEventSets"));
            stringBuilder.append("    private static EventSetDescriptor[] eventSets = null;\n");
            stringBuilder.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            this.bis.setEventSetsSection(stringBuilder.toString(), "        return eventSets;\n    }\n\n");
            return;
        }
        stringBuilder.append(TAB + GenerateBeanInfoAction.getString("COMMENT_EventSetsIdentifiers"));
        TreeSet<BiFeature.EventSet> treeSet = new TreeSet<BiFeature.EventSet>(this.eventSets);
        for (BiFeature.EventSet eventSet : treeSet) {
            if (!eventSet.isIncluded()) continue;
            stringBuilder.append("    private static final int ");
            stringBuilder.append("EVENT_" + eventSet.getName());
            stringBuilder.append(" = " + n++ + ";");
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_EventSetsArray"));
        if (!this.lazyEventSets) {
            stringBuilder.append("    private static EventSetDescriptor[] eventSets = new EventSetDescriptor[" + n + "];\n\n");
            stringBuilder.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            stringBuilder.append("        return eventSets;\n    }\n\n");
        } else {
            stringBuilder.append("    /*lazy EventSetDescriptor*/\n");
            stringBuilder.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            stringBuilder.append("        EventSetDescriptor[] eventSets = new EventSetDescriptor[");
            stringBuilder.append(n);
            stringBuilder.append("];\n");
        }
        if (n > 0) {
            if (!this.lazyEventSets) {
                stringBuilder.append("    static {\n        try {\n");
            } else {
                stringBuilder.append("    \n        try {\n");
            }
        }
        for (BiFeature.EventSet eventSet : treeSet) {
            if (!eventSet.isIncluded()) continue;
            stringBuilder.append("            eventSets[EVENT_").append(eventSet.getName()).append("] = ");
            stringBuilder.append(eventSet.getCreationString());
            stringBuilder.append(';');
            this.appendNoi18nText(stringBuilder);
            stringBuilder.append('\n');
            for (String string : eventSet.getCustomizationStrings()) {
                stringBuilder.append("            eventSets[EVENT_").append(eventSet.getName()).append("].");
                stringBuilder.append(string).append(";\n");
            }
        }
        if (n > 0) {
            stringBuilder.append("        }\n        catch(IntrospectionException e) {\n            e.printStackTrace();\n        }");
        }
        if (!this.lazyEventSets) {
            this.bis.setEventSetsSection(stringBuilder.toString(), n > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setEventSetsSection(stringBuilder.toString(), "        return eventSets;\n    }\n");
        }
    }

    private void regenerateIcons() {
        if (this.iconBlockRequired()) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(BiAnalyser.getIconDeclaration(ICONNAME_C16, this.iconC16));
            stringBuilder.append(BiAnalyser.getIconDeclaration(ICONNAME_C32, this.iconC32));
            stringBuilder.append(BiAnalyser.getIconDeclaration(ICONNAME_M16, this.iconM16));
            stringBuilder.append(BiAnalyser.getIconDeclaration(ICONNAME_M32, this.iconM32));
            this.bis.setIconsSection(stringBuilder.toString());
        }
    }

    private boolean iconBlockRequired() {
        return this.iconC16 != null | this.iconC32 != null | this.iconM16 != null | this.iconM32 != null;
    }

    private static String getIconDeclaration(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("    private static String ").append(string).append(" = ");
        if (string2 == null || string2.trim().length() == 0) {
            stringBuilder.append("null;\n");
        } else {
            stringBuilder.append("\"").append(string2.trim()).append("\";\n");
        }
        return stringBuilder.toString();
    }

    private void regenerateDefaultIdx() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("    private static final int defaultPropertyIndex = ").append(this.defaultPropertyIndex).append(";\n");
        stringBuilder.append("    private static final int defaultEventIndex = ").append(this.defaultEventIndex).append(";\n");
        this.bis.setDefaultIdxSection(stringBuilder.toString());
    }

    private void regenerateSuperclass() {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (this.isUseSuperClass()) {
            stringBuilder.append("    public BeanInfo[] getAdditionalBeanInfo() {\n");
            stringBuilder.append("        Class superclass = " + this.classfqn + ".class.getSuperclass();\n");
            stringBuilder.append("        BeanInfo sbi = null;\n");
            stringBuilder.append("        try {\n");
            stringBuilder.append("            sbi = Introspector.getBeanInfo(superclass);\n");
            this.bis.setSuperclassSection(stringBuilder.toString(), "            }\ncatch(IntrospectionException ex) {\n}\n\nreturn new BeanInfo[] { sbi };\n}\n");
        } else {
            this.bis.setSuperclassSection("\n", "\n");
        }
    }

    private void analyzeBeanInfoSource() throws GenerateBeanException {
        if (!this.bis.isNbBeanInfo()) {
            return;
        }
        String string = this.bis.getIconsSection();
        List<String> list = BiAnalyser.normalizeText(string);
        this.setIconsFromBeanInfo(list);
        string = this.bis.getDefaultIdxSection();
        list = BiAnalyser.normalizeText(string);
        this.setDefaultIdxFromBeanInfo(list);
        string = this.bis.getDescriptorSection();
        list = BiAnalyser.normalizeText(string);
        this.nullDescriptor = this.setPropertiesFromBeanInfo(this.descriptor, list, "BeanDescriptor");
        if (!this.nullDescriptor) {
            this.setLazyDescriptor(BiAnalyser.isLazy(list, "BeanDescriptor"));
        }
        string = this.bis.getPropertiesSection();
        list = BiAnalyser.normalizeText(string);
        this.nullProperties = this.setPropertiesFromBeanInfo(this.properties, list, "PropertyDescriptor[]");
        if (!this.nullProperties) {
            this.setLazyProperties(BiAnalyser.isLazy(list, "PropertyDescriptor"));
            this.setPropertiesFromBeanInfo(this.idxProperties, list, "PropertyDescriptor[]");
        }
        if ((string = this.bis.getMethodsSection()) == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)GenerateBeanInfoAction.getString("MSG_Old_Version"), 2));
            this.nullMethods = true;
        } else {
            list = BiAnalyser.normalizeText(string);
            this.nullMethods = this.setPropertiesFromBeanInfo(this.methods, list, "MethodDescriptor[]");
            if (!this.nullMethods) {
                this.setLazyMethods(BiAnalyser.isLazy(list, "MethodDescriptor"));
            }
        }
        string = this.bis.getEventSetsSection();
        list = BiAnalyser.normalizeText(string);
        this.nullEventSets = this.setPropertiesFromBeanInfo(this.eventSets, list, "EventSetDescriptor[]");
        if (!this.nullEventSets) {
            this.setLazyEventSets(BiAnalyser.isLazy(list, "EventSetDescriptor"));
        }
        string = this.bis.getSuperclassSection();
        list = BiAnalyser.normalizeText(string);
        this.setUseSuperClass(BiAnalyser.hasSuperClass(list));
    }

    static List<String> normalizeText(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder(100);
        int n = 1;
        int n2 = NOI18N_COMMENT.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        block4: for (int i = 0; string != null && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\"') {
                bl3 = false;
            }
            switch (n) {
                case 0: {
                    if (!Character.isWhitespace(c)) {
                        if (c == ';') {
                            stringBuilder.append(c);
                            if (i + n2 < string.length() && NOI18N_COMMENT.equals(string.substring(i + 1, i + 1 + n2))) {
                                stringBuilder.append(NOI18N_COMMENT);
                                i += n2;
                            }
                            arrayList.add(stringBuilder.toString());
                            stringBuilder.setLength(0);
                            n = 1;
                            bl = false;
                            continue block4;
                        }
                        if (c == '\\') {
                            bl3 = true;
                            stringBuilder.append(c);
                            continue block4;
                        }
                        if (c == '\"') {
                            if (!bl3) {
                                bl2 = !bl2;
                            }
                            bl3 = false;
                            stringBuilder.append(c);
                            continue block4;
                        }
                        stringBuilder.append(c);
                        continue block4;
                    }
                    if (bl2) {
                        stringBuilder.append(c);
                        continue block4;
                    }
                    char c2 = string.charAt(i - 1);
                    bl = Character.isJavaIdentifierPart(c2) || c2 == ']';
                    n = 1;
                    continue block4;
                }
                case 1: {
                    if (Character.isWhitespace(c)) continue block4;
                    if (bl && Character.isJavaIdentifierStart(c)) {
                        stringBuilder.append(' ');
                    } else if (c == '\\') {
                        bl3 = true;
                        stringBuilder.append(c);
                    } else if (c == '\"') {
                        if (!bl3) {
                            bl2 = !bl2;
                        }
                        bl3 = false;
                    }
                    stringBuilder.append(c);
                    n = 0;
                }
            }
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    static String[] getParameters(String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        if (n == -1 || n2 == -1 || ++n >= n2) {
            return new String[0];
        }
        String string2 = string.substring(n, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        return stringArray;
    }

    static String getArgumentParameter(String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        if (n != -1 && n2 != -1 && ++n < n2) {
            return string.substring(n, n2);
        }
        return null;
    }

    static String getInitializer(String string) {
        int n = string.lastIndexOf(61);
        int n2 = string.lastIndexOf(59);
        if (n != -1 && n2 != -1 && ++n < n2) {
            return string.substring(n, n2).trim();
        }
        return null;
    }

    static boolean isLazy(List<String> list, String string) {
        for (String string2 : list) {
            if (string2.indexOf(string) == -1 || string2.indexOf("/*lazy " + string + "*/") == -1) continue;
            return true;
        }
        return false;
    }

    static boolean hasSuperClass(List<String> list) {
        for (String string : list) {
            if (string.indexOf("public BeanInfo[] getAdditionalBeanInfo()") == -1) continue;
            return true;
        }
        return false;
    }

    static String removeQuotation(String string) {
        int n = string.indexOf(34);
        int n2 = string.lastIndexOf(34);
        if (n != -1 && n2 != -1 && ++n < n2) {
            return string.substring(n, n2);
        }
        return null;
    }

    boolean setPropertiesFromBeanInfo(List<? extends BiFeature> list, List<String> list2, String string) throws GenerateBeanException {
        for (String object : list2) {
            if (object.indexOf(string) == -1) continue;
            if (!"null".equals(BiAnalyser.getInitializer(object))) break;
            return true;
        }
        for (BiFeature biFeature : list) {
            biFeature.setBrackets(biFeature.getBrackets());
            biFeature.analyzeCustomization(list2);
        }
        return false;
    }

    void setIconsFromBeanInfo(List<String> list) {
        for (String string : list) {
            if (string.indexOf(ICONNAME_C16) != -1) {
                this.iconC16 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(string));
                continue;
            }
            if (string.indexOf(ICONNAME_C32) != -1) {
                this.iconC32 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(string));
                continue;
            }
            if (string.indexOf(ICONNAME_M16) != -1) {
                this.iconM16 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(string));
                continue;
            }
            if (string.indexOf(ICONNAME_M32) == -1) continue;
            this.iconM32 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(string));
        }
    }

    void setDefaultIdxFromBeanInfo(List<String> list) {
        for (String string : list) {
            if (string.indexOf(DEFAULT_PROPERTY_INDEX) != -1) {
                try {
                    this.defaultPropertyIndex = Integer.parseInt(BiAnalyser.getInitializer(string));
                }
                catch (NumberFormatException numberFormatException) {
                    this.defaultPropertyIndex = -1;
                }
                continue;
            }
            if (string.indexOf(DEFAULT_EVENT_INDEX) == -1) continue;
            try {
                this.defaultEventIndex = Integer.parseInt(BiAnalyser.getInitializer(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.defaultEventIndex = -1;
            }
        }
    }

    private void appendNoi18nText(StringBuilder stringBuilder) {
        stringBuilder.append(NOI18N_COMMENT);
    }

    void setModified() {
        if (this.isUpdateMode) {
            this.isModified = true;
            BIEditorSupport bIEditorSupport = (BIEditorSupport)((Object)this.bis.getDataObject().getLookup().lookup(BIEditorSupport.class));
            bIEditorSupport.notifyModified();
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public boolean isBeanBroken() {
        return this.isBeanBroken;
    }
}

