/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLReader;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ConfigurationDescriptorProvider {
    public static final String USG_PROJECT_CONFIG_CND = "USG_PROJECT_CONFIG_CND";
    public static final String USG_PROJECT_OPEN_CND = "USG_PROJECT_OPEN_CND";
    private FileObject projectDirectory;
    private ConfigurationDescriptor projectDescriptor = null;
    boolean hasTried = false;
    private String relativeOffset = null;
    private final Object readLock = new Object();

    public ConfigurationDescriptorProvider(FileObject fileObject) {
        this.projectDirectory = fileObject;
    }

    public void setRelativeOffset(String string) {
        this.relativeOffset = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationDescriptor getConfigurationDescriptor() {
        if (this.projectDescriptor == null && !this.hasTried) {
            Object object = this.readLock;
            synchronized (object) {
                if (!this.hasTried) {
                    ConfigurationXMLReader configurationXMLReader = new ConfigurationXMLReader(this.projectDirectory);
                    if (SwingUtilities.isEventDispatchThread()) {
                        ProjectReader projectReader = new ProjectReader(configurationXMLReader, this.relativeOffset);
                        RequestProcessor.Task task = RequestProcessor.getDefault().post((Runnable)projectReader);
                        task.waitFinished();
                        this.projectDescriptor = projectReader.projectDescriptor;
                    } else {
                        try {
                            this.projectDescriptor = configurationXMLReader.read(this.relativeOffset);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.hasTried = true;
                    ConfigurationDescriptorProvider.recordMetrics(USG_PROJECT_OPEN_CND, this.projectDescriptor);
                }
            }
        }
        return this.projectDescriptor;
    }

    public boolean gotDescriptor() {
        return this.projectDescriptor != null;
    }

    public static ConfigurationAuxObjectProvider[] getAuxObjectProviders() {
        HashSet hashSet = new HashSet();
        Lookup.Template template = new Lookup.Template(ConfigurationAuxObjectProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection collection = result.allInstances();
        for (Object e : collection) {
            if (!(e instanceof ConfigurationAuxObjectProvider)) continue;
            hashSet.add(e);
        }
        return hashSet.toArray(new ConfigurationAuxObjectProvider[hashSet.size()]);
    }

    public static void recordMetrics(String string, ConfigurationDescriptor configurationDescriptor) {
        if (!(configurationDescriptor instanceof MakeConfigurationDescriptor)) {
            return;
        }
        Logger logger = Logger.getLogger("org.netbeans.ui.metrics.cnd");
        if (logger.isLoggable(Level.INFO)) {
            CharSequence charSequence;
            String string2;
            String string3;
            String[] stringArray;
            String string4;
            LogRecord logRecord = new LogRecord(Level.INFO, string);
            MakeConfiguration makeConfiguration = (MakeConfiguration)configurationDescriptor.getConfs().getActive();
            switch (makeConfiguration.getConfigurationType().getValue()) {
                case 0: {
                    string4 = "MAKEFILE";
                    break;
                }
                case 1: {
                    string4 = "APPLICATION";
                    break;
                }
                case 2: {
                    string4 = "DYNAMIC_LIB";
                    break;
                }
                case 3: {
                    string4 = "STATIC_LIB";
                    break;
                }
                default: {
                    string4 = "UNKNOWN";
                }
            }
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet != null) {
                stringArray = compilerSet.getCompilerFlavor().getToolchainDescriptor().getFamily();
                string3 = compilerSet.getCompilerFlavor().toString();
            } else {
                stringArray = new String[]{};
                string3 = makeConfiguration.getCompilerSet().getFlavor();
            }
            if (stringArray.length == 0) {
                string2 = "UKNOWN";
            } else {
                charSequence = new StringBuilder();
                for (int i = 0; i < stringArray.length; ++i) {
                    ((StringBuilder)charSequence).append(stringArray[i]);
                    if (i >= stringArray.length - 1) continue;
                    ((StringBuilder)charSequence).append(",");
                }
                string2 = ((StringBuilder)charSequence).toString();
            }
            charSequence = makeConfiguration.getDevelopmentHost().isLocalhost() ? "LOCAL" : "REMOTE";
            String string5 = Platforms.getPlatform(makeConfiguration.getCompilerSet().getPlatform()) != null ? Platforms.getPlatform(makeConfiguration.getCompilerSet().getPlatform()).getName() : "UNKNOWN_PLATFORM";
            makeConfiguration.reCountLanguages((MakeConfigurationDescriptor)configurationDescriptor);
            Item[] itemArray = ((MakeConfigurationDescriptor)configurationDescriptor).getProjectItems();
            int n = 0;
            int n2 = itemArray.length;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            block12: for (Item item : itemArray) {
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue()) continue;
                ++n;
                switch (itemConfiguration.getTool()) {
                    case 0: {
                        bl = true;
                        continue block12;
                    }
                    case 1: {
                        bl2 = true;
                        continue block12;
                    }
                    case 2: {
                        bl3 = true;
                    }
                }
            }
            String string6 = bl2 ? "USE_CPP" : "NO_CPP";
            String string7 = bl ? "USE_C" : "NO_C";
            String string8 = bl3 ? "USE_FORTRAN" : "NO_FORTRAN";
            logRecord.setParameters(new Object[]{string4, string3, string2, charSequence, string5, ConfigurationDescriptorProvider.toSizeString(n2), ConfigurationDescriptorProvider.toSizeString(n), string6, string7, string8});
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
    }

    private static String toSizeString(int n) {
        String string = n < 25 ? "25" : (n < 100 ? "100" : (n < 500 ? "500" : (n < 1000 ? "1000" : (n < 2000 ? "2000" : (n < 5000 ? "5000" : (n < 10000 ? "10000" : (n < 20000 ? "20000" : (n < 50000 ? "50000" : "99999"))))))));
        return string;
    }

    private class ProjectReader
    implements Runnable {
        public ConfigurationDescriptor projectDescriptor = null;
        private ConfigurationXMLReader reader;
        private String relativeOffset;

        public ProjectReader(ConfigurationXMLReader configurationXMLReader, String string) {
            this.reader = configurationXMLReader;
            this.relativeOffset = string;
        }

        public void run() {
            try {
                this.projectDescriptor = this.reader.read(this.relativeOffset);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

