/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.loaders.CCDataLoader;
import org.netbeans.modules.cnd.loaders.CCDataObject;
import org.netbeans.modules.cnd.loaders.CDataLoader;
import org.netbeans.modules.cnd.loaders.CDataObject;
import org.netbeans.modules.cnd.loaders.FortranDataLoader;
import org.netbeans.modules.cnd.loaders.FortranDataObject;
import org.netbeans.modules.cnd.loaders.HDataLoader;
import org.netbeans.modules.cnd.loaders.HDataObject;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class Item
implements NativeFileItem,
PropertyChangeListener {
    private final String path;
    private final String sortName;
    private Folder folder;
    private File file = null;
    private String id = null;
    private DataObject myDataObject = null;

    public Item(String string) {
        this.path = string;
        this.sortName = IpeUtils.getBaseName((String)string).toLowerCase();
        this.folder = null;
    }

    public void rename(String string) {
        String string2;
        if (string == null || string.length() == 0 || this.getFolder() == null) {
            return;
        }
        int n = this.path.lastIndexOf(47);
        n = n < 0 ? 0 : ++n;
        int n2 = this.path.lastIndexOf(46);
        if (n2 < n) {
            n2 = -1;
        }
        if ((string2 = n2 >= 0 ? this.path.substring(n, n2) : this.path.substring(n)).equals(string)) {
            return;
        }
        String string3 = "";
        if (n > 0) {
            string3 = this.path.substring(0, n);
        }
        string3 = string3 + string;
        if (n2 >= 0) {
            string3 = string3 + this.path.substring(n2);
        }
        this.moveTo(string3);
    }

    public void moveTo(String string) {
        Folder folder = this.getFolder();
        String string2 = this.getAbsPath();
        folder.removeItem(this);
        Item item = new Item(string);
        folder.addItem(item);
        folder.renameItemAction(string2, item);
    }

    public String getPath() {
        return this.path;
    }

    public String getSortName() {
        return this.sortName;
    }

    public String getPath(boolean bl) {
        String string = "./";
        if (bl && this.getPath().startsWith(string)) {
            return this.getPath().substring(2);
        }
        return this.getPath();
    }

    public String getAbsPath() {
        String string = null;
        if (IpeUtils.isPathAbsolute((String)this.getPath())) {
            string = this.getPath();
            string = FilePathAdaptor.mapToLocal(string);
        } else if (this.getFolder() != null) {
            string = this.getFolder().getConfigurationDescriptor().getBaseDir() + '/' + this.getPath();
        }
        return string;
    }

    public void setFolder(Folder folder) {
        this.folder = folder;
        if (folder != null) {
            this.addPropertyChangeListener();
        }
    }

    public void addPropertyChangeListener() {
        this.myDataObject = this.getDataObject();
        if (this.myDataObject != null) {
            this.myDataObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void removePropertyChangeListener() {
        if (this.myDataObject != null) {
            this.myDataObject.removePropertyChangeListener((PropertyChangeListener)this);
            this.myDataObject = null;
        }
    }

    public DataObject getLastDataObject() {
        return this.myDataObject;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("name")) {
            this.rename((String)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("valid")) {
            if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.getFolder().refresh(this);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("primaryFile")) {
            FileObject fileObject = (FileObject)propertyChangeEvent.getNewValue();
            String string = FileUtil.toFile((FileObject)fileObject).getPath();
            if (!IpeUtils.isPathAbsolute((String)this.getPath())) {
                string = IpeUtils.toRelativePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)string);
            }
            string = FilePathAdaptor.normalize(string);
            this.moveTo(string);
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    public File getFile() {
        String string = this.getAbsPath();
        if (string != null) {
            return FileUtil.normalizeFile((File)new File(string));
        }
        return null;
    }

    public File getCanonicalFile() {
        if (this.file == null) {
            try {
                this.file = new File(this.getAbsPath()).getCanonicalFile();
            }
            catch (IOException iOException) {
                this.file = new File(this.getAbsPath());
            }
        }
        return this.file;
    }

    public String getId() {
        if (this.id == null) {
            this.id = "i-" + this.getPath();
        }
        return this.id;
    }

    public ItemConfiguration getItemConfiguration(Configuration configuration) {
        if (configuration != null) {
            return (ItemConfiguration)configuration.getAuxObject(this.getId());
        }
        return null;
    }

    public ItemConfiguration[] getItemConfigurations() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return new ItemConfiguration[0];
        }
        Configuration[] configurationArray = makeConfigurationDescriptor.getConfs().getConfs();
        ItemConfiguration[] itemConfigurationArray = new ItemConfiguration[configurationArray.length];
        for (int i = 0; i < configurationArray.length; ++i) {
            itemConfigurationArray[i] = this.getItemConfiguration(configurationArray[i]);
        }
        return itemConfigurationArray;
    }

    public FileObject getFileObject() {
        File file = this.getCanonicalFile();
        FileObject fileObject = null;
        try {
            fileObject = FileUtil.toFileObject((File)file.getCanonicalFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileObject;
    }

    public DataObject getDataObject() {
        DataObject dataObject = null;
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
        }
        return dataObject;
    }

    public int getDefaultTool() {
        DataObject dataObject = this.getDataObject();
        int n = dataObject == null ? (CCDataLoader.getInstance().getExtensions().isRegistered(this.path) ? 1 : (CDataLoader.getInstance().getExtensions().isRegistered(this.path) ? 0 : (FortranDataLoader.getInstance().getExtensions().isRegistered(this.path) ? 2 : 3))) : (dataObject instanceof CDataObject ? 0 : (dataObject instanceof HDataObject ? 3 : (dataObject instanceof CCDataObject ? 1 : (CppSettings.getDefault().isFortranEnabled() && dataObject instanceof FortranDataObject ? 2 : 3))));
        return n;
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        if (this.getFolder() == null) {
            return null;
        }
        return (MakeConfigurationDescriptor)this.getFolder().getConfigurationDescriptor();
    }

    private MakeConfiguration getMakeConfiguration() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return null;
        }
        Configurations configurations = makeConfigurationDescriptor.getConfs();
        if (configurations == null) {
            return null;
        }
        return (MakeConfiguration)configurations.getActive();
    }

    public NativeProject getNativeProject() {
        Folder folder = this.getFolder();
        if (folder != null) {
            Project project = folder.getProject();
            return (NativeProject)project.getLookup().lookup(NativeProject.class);
        }
        return null;
    }

    public List getSystemIncludePaths() {
        ArrayList arrayList = new ArrayList();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return arrayList;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return arrayList;
        }
        BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(itemConfiguration.getTool());
        BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (basicCompilerConfiguration instanceof CCCCompilerConfiguration && basicCompiler != null && basicCompiler.getPath() != null && basicCompiler.getPath().length() > 0) {
            arrayList.addAll(basicCompiler.getSystemIncludeDirectories());
        }
        return arrayList;
    }

    public List getUserIncludePaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return arrayList;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return arrayList;
        }
        BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (basicCompilerConfiguration instanceof CCCCompilerConfiguration) {
            ArrayList arrayList2 = new ArrayList();
            CCCCompilerConfiguration cCCCompilerConfiguration = (CCCCompilerConfiguration)basicCompilerConfiguration;
            CCCCompilerConfiguration cCCCompilerConfiguration2 = (CCCCompilerConfiguration)cCCCompilerConfiguration.getMaster();
            while (cCCCompilerConfiguration2 != null && cCCCompilerConfiguration.getInheritIncludes().getValue()) {
                arrayList2.addAll(cCCCompilerConfiguration2.getIncludeDirectories().getValue());
                if (cCCCompilerConfiguration2.getInheritIncludes().getValue()) {
                    cCCCompilerConfiguration2 = (CCCCompilerConfiguration)cCCCompilerConfiguration2.getMaster();
                    continue;
                }
                cCCCompilerConfiguration2 = null;
            }
            arrayList2.addAll(cCCCompilerConfiguration.getIncludeDirectories().getValue());
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                arrayList.add(IpeUtils.toAbsolutePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)((String)iterator.next())));
            }
        }
        return arrayList;
    }

    public List getSystemMacroDefinitions() {
        ArrayList arrayList = new ArrayList();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return arrayList;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return arrayList;
        }
        BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(itemConfiguration.getTool());
        BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (basicCompilerConfiguration instanceof CCCCompilerConfiguration && basicCompiler != null && basicCompiler.getPath() != null && basicCompiler.getPath().length() > 0) {
            arrayList.addAll(basicCompiler.getSystemPreprocessorSymbols());
        }
        return arrayList;
    }

    public List getUserMacroDefinitions() {
        ArrayList arrayList = new ArrayList();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return arrayList;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return arrayList;
        }
        BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (basicCompilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cCCCompilerConfiguration = (CCCCompilerConfiguration)basicCompilerConfiguration;
            CCCCompilerConfiguration cCCCompilerConfiguration2 = (CCCCompilerConfiguration)cCCCompilerConfiguration.getMaster();
            while (cCCCompilerConfiguration2 != null && cCCCompilerConfiguration.getInheritPreprocessor().getValue()) {
                arrayList.addAll(cCCCompilerConfiguration2.getPreprocessorConfiguration().getValue());
                if (cCCCompilerConfiguration2.getInheritIncludes().getValue()) {
                    cCCCompilerConfiguration2 = (CCCCompilerConfiguration)cCCCompilerConfiguration2.getMaster();
                    continue;
                }
                cCCCompilerConfiguration2 = null;
            }
            arrayList.addAll(cCCCompilerConfiguration.getPreprocessorConfiguration().getValue());
        }
        return arrayList;
    }

    public boolean hasHeaderOrSourceExtension(boolean bl, boolean bl2) {
        String string = this.getPath();
        return HDataLoader.getInstance().getExtensions().isRegistered(string) || bl2 && CCDataLoader.getInstance().getExtensions().isRegistered(string) || bl && CDataLoader.getInstance().getExtensions().isRegistered(string);
    }

    public NativeFileItem.Language getLanguage() {
        int n;
        ItemConfiguration itemConfiguration = null;
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            itemConfiguration = this.getItemConfiguration(makeConfiguration);
        }
        NativeFileItem.Language language = (n = itemConfiguration != null ? itemConfiguration.getTool() : this.getDefaultTool()) == 0 ? NativeFileItem.Language.C : (n == 1 ? NativeFileItem.Language.CPP : (n == 2 ? NativeFileItem.Language.FORTRAN : (this.hasHeaderOrSourceExtension(true, true) ? NativeFileItem.Language.C_HEADER : NativeFileItem.Language.OTHER)));
        return language;
    }

    public NativeFileItem.LanguageFlavor getLanguageFlavor() {
        return NativeFileItem.LanguageFlavor.GENERIC;
    }

    public boolean isExcluded() {
        ItemConfiguration itemConfiguration = this.getItemConfiguration(this.getMakeConfiguration());
        if (itemConfiguration != null) {
            return itemConfiguration.getExcluded().getValue();
        }
        return true;
    }
}

