/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ItemXMLCodec;
import org.netbeans.modules.cnd.makeproject.configurations.ui.BooleanNodeProp;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class ItemConfiguration
implements ConfigurationAuxObject {
    private boolean needSave = false;
    private Configuration configuration;
    private Item item;
    private BooleanConfiguration excluded;
    private int tool = -1;
    private CustomToolConfiguration customToolConfiguration;
    private CCompilerConfiguration cCompilerConfiguration;
    private CCCompilerConfiguration ccCompilerConfiguration;
    private FortranCompilerConfiguration fortranCompilerConfiguration;
    private static ResourceBundle bundle = null;

    public ItemConfiguration(Configuration configuration, Item item) {
        this.configuration = configuration;
        this.setItem(item);
        this.excluded = new BooleanConfiguration(null, false);
        item.getFolder().getFolderConfiguration(configuration);
        this.clearChanged();
    }

    public boolean isCompilerToolConfiguration() {
        return this.getTool() == 0 || this.getTool() == 1 || this.getTool() == 2;
    }

    public BasicCompilerConfiguration getCompilerConfiguration() {
        if (this.getTool() == 0) {
            return this.getCCompilerConfiguration();
        }
        if (this.getTool() == 1) {
            return this.getCCCompilerConfiguration();
        }
        if (this.getTool() == 2) {
            return this.getFortranCompilerConfiguration();
        }
        assert (false);
        return null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Item getItem() {
        return this.item;
    }

    private void setItem(Item item) {
        if (this.item != item) {
            this.item = item;
            this.needSave = true;
        }
    }

    public BooleanConfiguration getExcluded() {
        return this.excluded;
    }

    public void setExcluded(BooleanConfiguration booleanConfiguration) {
        this.excluded = booleanConfiguration;
        this.needSave = true;
    }

    public void setTool(String string) {
        this.setTool(Tool.getTool((String)string));
    }

    public void setTool(int n) {
        this.tool = n;
    }

    public int getTool() {
        if (this.tool == -1) {
            this.tool = this.item.getDefaultTool();
        }
        return this.tool;
    }

    protected String[] getToolNames() {
        return Tool.getCompilerToolNames();
    }

    public void setCustomToolConfiguration(CustomToolConfiguration customToolConfiguration) {
        this.customToolConfiguration = customToolConfiguration;
    }

    public synchronized CustomToolConfiguration getCustomToolConfiguration() {
        if (this.customToolConfiguration == null) {
            this.customToolConfiguration = new CustomToolConfiguration();
        }
        return this.customToolConfiguration;
    }

    public void setCCompilerConfiguration(CCompilerConfiguration cCompilerConfiguration) {
        this.cCompilerConfiguration = cCompilerConfiguration;
    }

    public synchronized CCompilerConfiguration getCCompilerConfiguration() {
        if (this.cCompilerConfiguration == null) {
            this.cCompilerConfiguration = new CCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), this.item.getFolder().getFolderConfiguration(this.configuration).getCCompilerConfiguration());
        }
        return this.cCompilerConfiguration;
    }

    public void setCCCompilerConfiguration(CCCompilerConfiguration cCCompilerConfiguration) {
        this.ccCompilerConfiguration = cCCompilerConfiguration;
    }

    public synchronized CCCompilerConfiguration getCCCompilerConfiguration() {
        if (this.ccCompilerConfiguration == null) {
            this.ccCompilerConfiguration = new CCCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), this.item.getFolder().getFolderConfiguration(this.configuration).getCCCompilerConfiguration());
        }
        return this.ccCompilerConfiguration;
    }

    public void setFortranCompilerConfiguration(FortranCompilerConfiguration fortranCompilerConfiguration) {
        this.fortranCompilerConfiguration = fortranCompilerConfiguration;
    }

    public synchronized FortranCompilerConfiguration getFortranCompilerConfiguration() {
        if (this.fortranCompilerConfiguration == null) {
            this.fortranCompilerConfiguration = new FortranCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), ((MakeConfiguration)this.configuration).getFortranCompilerConfiguration());
        }
        return this.fortranCompilerConfiguration;
    }

    public boolean shared() {
        return true;
    }

    public boolean hasChanged() {
        return this.needSave;
    }

    public void clearChanged() {
        this.needSave = false;
    }

    public String getId() {
        return this.item.getId();
    }

    public void assign(ConfigurationAuxObject configurationAuxObject) {
        if (!(configurationAuxObject instanceof ItemConfiguration)) {
            System.err.println("Item - assign: Profile object type expected - got " + configurationAuxObject);
            return;
        }
        ItemConfiguration itemConfiguration = (ItemConfiguration)configurationAuxObject;
        if (!this.getId().equals(itemConfiguration.getItem().getId())) {
            System.err.println("Item - assign: Item ID " + this.getId() + " expected - got " + itemConfiguration.getItem().getId());
            return;
        }
        this.setConfiguration(itemConfiguration.getConfiguration());
        this.setItem(itemConfiguration.getItem());
        this.getExcluded().assign(itemConfiguration.getExcluded());
        this.setTool(itemConfiguration.getTool());
        this.getCustomToolConfiguration().assign(itemConfiguration.getCustomToolConfiguration());
        this.getCCompilerConfiguration().assign(itemConfiguration.getCCompilerConfiguration());
        this.getCCCompilerConfiguration().assign(itemConfiguration.getCCCompilerConfiguration());
        this.getFortranCompilerConfiguration().assign(itemConfiguration.getFortranCompilerConfiguration());
    }

    public void assignValues(ConfigurationAuxObject configurationAuxObject) {
        if (!(configurationAuxObject instanceof ItemConfiguration)) {
            System.err.println("Item - assign: Profile object type expected - got " + configurationAuxObject);
            return;
        }
        ItemConfiguration itemConfiguration = (ItemConfiguration)configurationAuxObject;
        this.getExcluded().assign(itemConfiguration.getExcluded());
        this.setTool(itemConfiguration.getTool());
        this.getCustomToolConfiguration().assign(itemConfiguration.getCustomToolConfiguration());
        this.getCCompilerConfiguration().assign(itemConfiguration.getCCompilerConfiguration());
        this.getCCCompilerConfiguration().assign(itemConfiguration.getCCCompilerConfiguration());
        this.getFortranCompilerConfiguration().assign(itemConfiguration.getFortranCompilerConfiguration());
    }

    public ItemConfiguration copy(MakeConfiguration makeConfiguration) {
        ItemConfiguration itemConfiguration = new ItemConfiguration(makeConfiguration, this.getItem());
        itemConfiguration.assign(this);
        return itemConfiguration;
    }

    public Object clone() {
        ItemConfiguration itemConfiguration = new ItemConfiguration(this.getConfiguration(), this.getItem());
        itemConfiguration.setExcluded((BooleanConfiguration)this.getExcluded().clone());
        itemConfiguration.setTool(this.getTool());
        itemConfiguration.setCustomToolConfiguration((CustomToolConfiguration)this.getCustomToolConfiguration().clone());
        itemConfiguration.setCCompilerConfiguration((CCompilerConfiguration)this.getCCompilerConfiguration().clone());
        itemConfiguration.setCCCompilerConfiguration((CCCompilerConfiguration)this.getCCCompilerConfiguration().clone());
        itemConfiguration.setFortranCompilerConfiguration((FortranCompilerConfiguration)this.getFortranCompilerConfiguration().clone());
        return itemConfiguration;
    }

    public XMLDecoder getXMLDecoder() {
        return new ItemXMLCodec(this);
    }

    public XMLEncoder getXMLEncoder() {
        return new ItemXMLCodec(this);
    }

    public void initialize() {
    }

    public Sheet getGeneralSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Item");
        set.setDisplayName(ItemConfiguration.getString("ItemTxt"));
        set.setShortDescription(ItemConfiguration.getString("ItemHint"));
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("NameTxt"), IpeUtils.getBaseName((String)this.item.getPath())));
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("FilePathTxt"), this.item.getPath()));
        String string = IpeUtils.toAbsolutePath((String)((MakeConfiguration)this.configuration).getBaseDir(), (String)this.item.getPath());
        String string2 = "";
        File file = new File(string);
        if (file.exists()) {
            string2 = DateFormat.getDateInstance().format(new Date(file.lastModified()));
            string2 = string2 + " " + DateFormat.getTimeInstance().format(new Date(file.lastModified()));
        }
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("FullFilePathTxt"), string));
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("LastModifiedTxt"), string2));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("ItemConfiguration");
        set.setDisplayName(ItemConfiguration.getString("ItemConfigurationTxt"));
        set.setShortDescription(ItemConfiguration.getString("ItemConfigurationHint"));
        if (this.getConfiguration() instanceof MakeConfiguration && ((MakeConfiguration)this.getConfiguration()).isMakefileConfiguration()) {
            set.put((Node.Property)new BooleanNodeProp(this.getExcluded(), true, "ExcludedFromBuild", ItemConfiguration.getString("ExcludedFromCodeAssistanceTxt"), ItemConfiguration.getString("ExcludedFromCodeAssistanceHint")));
        } else {
            set.put((Node.Property)new BooleanNodeProp(this.getExcluded(), true, "ExcludedFromBuild", ItemConfiguration.getString("ExcludedFromBuildTxt"), ItemConfiguration.getString("ExcludedFromBuildHint")));
        }
        set.put((Node.Property)new ToolNodeProp());
        sheet.put(set);
        return sheet;
    }

    public String toString() {
        return this.getItem().getPath();
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(ItemConfiguration.class);
        }
        return bundle.getString(string);
    }

    private class StringRONodeProp
    extends PropertySupport {
        String value;

        public StringRONodeProp(String string, String string2) {
            super(string, String.class, string, string, true, false);
            this.value = string2;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
        }
    }

    private class ToolEditor
    extends PropertyEditorSupport {
        private ToolEditor() {
        }

        public String getJavaInitializationString() {
            return this.getAsText();
        }

        public String getAsText() {
            int n = (Integer)this.getValue();
            return Tool.getName((int)n);
        }

        public void setAsText(String string) throws IllegalArgumentException {
            this.setValue(string);
        }

        public String[] getTags() {
            return ItemConfiguration.this.getToolNames();
        }
    }

    private class ToolNodeProp
    extends Node.Property {
        public ToolNodeProp() {
            super(Integer.class);
        }

        public String getName() {
            return ItemConfiguration.getString("ToolTxt1");
        }

        public Object getValue() {
            return new Integer(ItemConfiguration.this.getTool());
        }

        public void setValue(Object object) {
            String string = (String)object;
            ItemConfiguration.this.setTool(string);
        }

        public boolean canWrite() {
            return true;
        }

        public boolean canRead() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            return new ToolEditor();
        }
    }
}

