/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.utils.ElfDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.ElfExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.ElfStaticLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.MacOSXDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.MacOSXExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.PeDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.PeExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.PeStaticLibraryFileFilter;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MakefileConfiguration {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration buildCommandWorkingDir;
    private StringConfiguration buildCommand;
    private StringConfiguration cleanCommand;
    private StringConfiguration output;
    private static ResourceBundle bundle;

    public MakefileConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.buildCommandWorkingDir = new StringConfiguration(null, "ExistingProjectRoot");
        this.buildCommand = new StringConfiguration(null, "${MAKE} -f ExistingMakefile");
        this.cleanCommand = new StringConfiguration(null, "${MAKE} -f ExistingMakefile clean");
        this.output = new StringConfiguration(null, "");
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public StringConfiguration getBuildCommandWorkingDir() {
        return this.buildCommandWorkingDir;
    }

    public String getBuildCommandWorkingDirValue() {
        if (this.buildCommandWorkingDir.getValue().length() == 0) {
            return ".";
        }
        return this.buildCommandWorkingDir.getValue();
    }

    public void setBuildCommandWorkingDir(StringConfiguration stringConfiguration) {
        this.buildCommandWorkingDir = stringConfiguration;
    }

    public StringConfiguration getBuildCommand() {
        return this.buildCommand;
    }

    public void setBuildCommand(StringConfiguration stringConfiguration) {
        this.buildCommand = stringConfiguration;
    }

    public StringConfiguration getCleanCommand() {
        return this.cleanCommand;
    }

    public void setCleanCommand(StringConfiguration stringConfiguration) {
        this.cleanCommand = stringConfiguration;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setOutput(StringConfiguration stringConfiguration) {
        this.output = stringConfiguration;
    }

    public boolean canBuild() {
        return this.getBuildCommand().getValue().length() > 0;
    }

    public String getAbsBuildCommandWorkingDir() {
        if (this.getBuildCommandWorkingDirValue().length() > 0 && IpeUtils.isPathAbsolute((String)this.getBuildCommandWorkingDirValue())) {
            return this.getBuildCommandWorkingDirValue();
        }
        return this.getMakeConfiguration().getBaseDir() + "/" + this.getBuildCommandWorkingDirValue();
    }

    public boolean canClean() {
        return this.getCleanCommand().getValue().length() > 0;
    }

    public String getAbsOutput() {
        if (this.getOutput().getValue().length() == 0) {
            return "";
        }
        if (this.getOutput().getValue().length() > 0 && IpeUtils.isPathAbsolute((String)this.getOutput().getValue())) {
            return this.getOutput().getValue();
        }
        return this.getMakeConfiguration().getBaseDir() + "/" + this.getOutput().getValue();
    }

    public void assign(MakefileConfiguration makefileConfiguration) {
        this.setMakeConfiguration(makefileConfiguration.getMakeConfiguration());
        this.getBuildCommandWorkingDir().assign(makefileConfiguration.getBuildCommandWorkingDir());
        this.getBuildCommand().assign(makefileConfiguration.getBuildCommand());
        this.getCleanCommand().assign(makefileConfiguration.getCleanCommand());
        this.getOutput().assign(makefileConfiguration.getOutput());
    }

    public Object clone() {
        MakefileConfiguration makefileConfiguration = new MakefileConfiguration(this.getMakeConfiguration());
        makefileConfiguration.setBuildCommandWorkingDir((StringConfiguration)this.getBuildCommandWorkingDir().clone());
        makefileConfiguration.setBuildCommand((StringConfiguration)this.getBuildCommand().clone());
        makefileConfiguration.setCleanCommand((StringConfiguration)this.getCleanCommand().clone());
        makefileConfiguration.setOutput((StringConfiguration)this.getOutput().clone());
        return makefileConfiguration;
    }

    public Sheet getSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Makefile");
        set.setDisplayName(MakefileConfiguration.getString("MakefileTxt"));
        set.setShortDescription(MakefileConfiguration.getString("MakefileHint"));
        set.put((Node.Property)new DirStringNodeProp(this.getBuildCommandWorkingDir(), "WorkingDirectory", MakefileConfiguration.getString("WorkingDirectory_LBL"), MakefileConfiguration.getString("WorkingDirectory_TT")));
        set.put((Node.Property)new StringNodeProp(this.getBuildCommand(), "BuildCommandLine", MakefileConfiguration.getString("BuildCommandLine_LBL"), MakefileConfiguration.getString("BuildCommandLine_TT")));
        set.put((Node.Property)new StringNodeProp(this.getCleanCommand(), "CleanCommandLine", MakefileConfiguration.getString("CleanCommandLine_LBL"), MakefileConfiguration.getString("CleanCommandLine_TT")));
        set.put((Node.Property)new OutputStringNodeProp(this.getOutput(), "BuildResult", MakefileConfiguration.getString("BuildResult_LBL"), MakefileConfiguration.getString("BuildResult_TT")));
        sheet.put(set);
        return sheet;
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(MakefileConfiguration.class);
        }
        return bundle.getString(string);
    }

    class ElfPanel
    extends FileChooser
    implements PropertyChangeListener {
        PropertyEditorSupport editor;

        public ElfPanel(String string, PropertyEditorSupport propertyEditorSupport, PropertyEnv propertyEnv) {
            super("", "", 0, null, string, true);
            this.setControlButtonsAreShown(false);
            if (Utilities.isWindows()) {
                this.addChoosableFileFilter((FileFilter)PeExecutableFileFilter.getInstance());
                this.addChoosableFileFilter((FileFilter)PeStaticLibraryFileFilter.getInstance());
                this.addChoosableFileFilter((FileFilter)PeDynamicLibraryFileFilter.getInstance());
            } else if (Utilities.getOperatingSystem() == 4096) {
                this.addChoosableFileFilter((FileFilter)MacOSXExecutableFileFilter.getInstance());
                this.addChoosableFileFilter((FileFilter)ElfStaticLibraryFileFilter.getInstance());
                this.addChoosableFileFilter((FileFilter)MacOSXDynamicLibraryFileFilter.getInstance());
            } else {
                this.addChoosableFileFilter((FileFilter)ElfExecutableFileFilter.getInstance());
                this.addChoosableFileFilter((FileFilter)ElfStaticLibraryFileFilter.getInstance());
                this.addChoosableFileFilter((FileFilter)ElfDynamicLibraryFileFilter.getInstance());
            }
            this.setFileFilter(this.getAcceptAllFileFilter());
            this.editor = propertyEditorSupport;
            propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID && this.getSelectedFile() != null) {
                String string = IpeUtils.toRelativePath((String)MakefileConfiguration.this.makeConfiguration.getBaseDir(), (String)this.getSelectedFile().getPath());
                string = FilePathAdaptor.normalize(string);
                this.editor.setValue(string);
            }
        }
    }

    private class ElfEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private String seed;

        public ElfEditor(String string) {
            this.seed = string;
        }

        public void setAsText(String string) {
            MakefileConfiguration.this.getOutput().setValue(string);
        }

        public String getAsText() {
            return MakefileConfiguration.this.getOutput().getValue();
        }

        public Object getValue() {
            return MakefileConfiguration.this.getOutput().getValue();
        }

        public void setValue(Object object) {
            MakefileConfiguration.this.getOutput().setValue((String)object);
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            return new ElfPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propertyEnv) {
            this.propenv = propertyEnv;
        }
    }

    class DirPanel
    extends FileChooser
    implements PropertyChangeListener {
        PropertyEditorSupport editor;

        public DirPanel(String string, PropertyEditorSupport propertyEditorSupport, PropertyEnv propertyEnv) {
            super(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("Run_Directory"), ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("SelectLabel"), 1, null, string, true);
            this.setControlButtonsAreShown(false);
            this.editor = propertyEditorSupport;
            propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
                String string = IpeUtils.toRelativePath((String)MakefileConfiguration.this.makeConfiguration.getBaseDir(), (String)this.getSelectedFile().getPath());
                string = FilePathAdaptor.normalize(string);
                this.editor.setValue(string);
            }
        }
    }

    private class DirEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private String seed;

        public DirEditor(String string) {
            this.seed = string;
        }

        public void setAsText(String string) {
            MakefileConfiguration.this.getBuildCommandWorkingDir().setValue(string);
        }

        public String getAsText() {
            return MakefileConfiguration.this.getBuildCommandWorkingDir().getValue();
        }

        public Object getValue() {
            return MakefileConfiguration.this.getBuildCommandWorkingDir().getValue();
        }

        public void setValue(Object object) {
            MakefileConfiguration.this.getBuildCommandWorkingDir().setValue((String)object);
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            return new DirPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propertyEnv) {
            this.propenv = propertyEnv;
        }
    }

    private class OutputStringNodeProp
    extends StringNodeProp {
        public OutputStringNodeProp(StringConfiguration stringConfiguration, String string, String string2, String string3) {
            super(stringConfiguration, string, string2, string3);
        }

        public void setValue(Object object) {
            String string = IpeUtils.toRelativePath((String)MakefileConfiguration.this.getMakeConfiguration().getBaseDir(), (String)((String)object));
            string = FilePathAdaptor.normalize(string);
            super.setValue(string);
        }

        public PropertyEditor getPropertyEditor() {
            String string = MakefileConfiguration.this.getAbsOutput();
            if (string.length() == 0) {
                string = MakefileConfiguration.this.getMakeConfiguration().getBaseDir();
            }
            return new ElfEditor(string);
        }
    }

    private class DirStringNodeProp
    extends StringNodeProp {
        public DirStringNodeProp(StringConfiguration stringConfiguration, String string, String string2, String string3) {
            super(stringConfiguration, string, string2, string3);
        }

        public void setValue(Object object) {
            String string = IpeUtils.toRelativePath((String)MakefileConfiguration.this.getMakeConfiguration().getBaseDir(), (String)((String)object));
            string = FilePathAdaptor.normalize(string);
            super.setValue(string);
        }

        public PropertyEditor getPropertyEditor() {
            return new DirEditor(MakefileConfiguration.this.getAbsBuildCommandWorkingDir());
        }
    }
}

