/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsEditorPanel;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.PropertySupport;

public class OptionsNodeProp
extends PropertySupport {
    private OptionsConfiguration commandLineConfiguration;
    private BooleanConfiguration inheritValues;
    private AllOptionsProvider optionsProvider;
    private BasicCompiler compiler;
    private String delimiter = "";
    private String txt1;
    private String txt2;
    private String txt3;
    private String[] texts;

    public OptionsNodeProp(OptionsConfiguration optionsConfiguration, BooleanConfiguration booleanConfiguration, AllOptionsProvider allOptionsProvider, BasicCompiler basicCompiler, String string, String[] stringArray) {
        super("ID", String.class, stringArray[0], stringArray[1], true, true);
        this.commandLineConfiguration = optionsConfiguration;
        this.inheritValues = booleanConfiguration;
        this.optionsProvider = allOptionsProvider;
        this.compiler = basicCompiler;
        if (string != null) {
            this.delimiter = string;
        }
        this.texts = stringArray;
    }

    public String getHtmlDisplayName() {
        if (this.commandLineConfiguration.getModified()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public Object getValue() {
        return this.commandLineConfiguration.getValue();
    }

    public void setValue(Object object) {
        String string = CppUtils.reformatWhitespaces((String)((String)object));
        this.commandLineConfiguration.setValue(string);
    }

    public PropertyEditor getPropertyEditor() {
        return new CommandLinePropEditor();
    }

    public void restoreDefaultValue() {
        this.commandLineConfiguration.optionsReset();
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return !this.commandLineConfiguration.getModified();
    }

    private class CommandLinePropEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv env;

        private CommandLinePropEditor() {
        }

        public void setAsText(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            if (OptionsNodeProp.this.delimiter.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, OptionsNodeProp.this.delimiter);
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuilder.append(stringTokenizer.nextToken());
                }
            } else {
                stringBuilder.append(string);
            }
            this.setValue(stringBuilder.toString());
        }

        public String getAsText() {
            String string = (String)this.getValue();
            return CppUtils.reformatWhitespaces((String)string, (String)"", (String)OptionsNodeProp.this.delimiter);
        }

        public Component getCustomEditor() {
            OptionsEditorPanel optionsEditorPanel = new OptionsEditorPanel(OptionsNodeProp.this.texts, OptionsNodeProp.this.inheritValues, this, this.env);
            optionsEditorPanel.setAllOptions(OptionsNodeProp.this.optionsProvider.getAllOptions(OptionsNodeProp.this.compiler));
            optionsEditorPanel.setAdditionalOptions((String)this.getValue());
            return optionsEditorPanel;
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv propertyEnv) {
            this.env = propertyEnv;
        }
    }
}

