/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.openide.util.NbBundle;

public class ConfSelectorPanel
extends JPanel {
    private static Configuration[] lastConfigurationItems;
    private static JCheckBox[] lastCheckBoxes;
    private Configuration[] configurationItems;
    private JCheckBox[] checkBoxes;
    JButton[] actionButtons;
    private JPanel buttonPanel;
    private JPanel confPanel;
    private JButton deselectAllButton;
    private JPanel innerPanel;
    private JLabel label;
    private JScrollPane scrollPanel;
    private JButton selectAllButton;
    private static ResourceBundle bundle;

    public ConfSelectorPanel(String string, char c, Configuration[] configurationArray, JButton[] jButtonArray) {
        GridBagConstraints gridBagConstraints;
        int n;
        this.initComponents();
        this.configurationItems = configurationArray;
        this.actionButtons = jButtonArray;
        this.label.setText(string);
        this.label.setDisplayedMnemonic(c);
        CheckBoxActionListener checkBoxActionListener = new CheckBoxActionListener();
        this.checkBoxes = new JCheckBox[configurationArray.length];
        for (n = 0; n < configurationArray.length; ++n) {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.addActionListener(checkBoxActionListener);
            jCheckBox.setBackground(new Color(255, 255, 255));
            jCheckBox.setText(configurationArray[n].toString());
            if (this.sameAsLastTime(configurationArray)) {
                jCheckBox.setSelected(lastCheckBoxes[n].isSelected());
            } else {
                jCheckBox.setSelected(true);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.anchor = 18;
            if (n == configurationArray.length - 1) {
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
            }
            this.innerPanel.add((Component)jCheckBox, gridBagConstraints);
            this.checkBoxes[n] = jCheckBox;
            jCheckBox.getAccessibleContext().setAccessibleDescription("");
        }
        if (jButtonArray != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            for (n = 0; n < jButtonArray.length; ++n) {
                ++gridBagConstraints.gridy;
                this.buttonPanel.add((Component)jButtonArray[n], gridBagConstraints);
            }
        }
        this.innerPanel.setBackground(new Color(255, 255, 255));
        this.setPreferredSize(new Dimension(350, 250));
        this.getAccessibleContext().setAccessibleDescription(ConfSelectorPanel.getString("SELECTED_CONF_AD"));
        this.label.setDisplayedMnemonic(ConfSelectorPanel.getString("SELECTED_CONF_MN").charAt(0));
        this.selectAllButton.getAccessibleContext().setAccessibleDescription(ConfSelectorPanel.getString("SELECT_ALL_BUTTON_AD"));
        this.deselectAllButton.getAccessibleContext().setAccessibleDescription(ConfSelectorPanel.getString("DESELECT_ALL_BUTTON_AD"));
        this.checkCheckBoxes();
    }

    private boolean sameAsLastTime(Configuration[] configurationArray) {
        if (lastConfigurationItems == null || lastCheckBoxes == null) {
            return false;
        }
        if (configurationArray.length != lastConfigurationItems.length) {
            return false;
        }
        if (configurationArray.length != lastCheckBoxes.length) {
            return false;
        }
        for (int i = 0; i < configurationArray.length; ++i) {
            if (configurationArray[i] == lastConfigurationItems[i]) continue;
            return false;
        }
        return true;
    }

    public void checkCheckBoxes() {
        int n;
        boolean bl = false;
        for (n = 0; n < this.checkBoxes.length; ++n) {
            if (!this.checkBoxes[n].isSelected()) continue;
            bl = true;
            break;
        }
        if (this.actionButtons != null) {
            for (n = 0; n < this.actionButtons.length; ++n) {
                this.actionButtons[n].setEnabled(bl);
            }
        }
    }

    public Configuration[] getSelectedConfs() {
        lastConfigurationItems = this.configurationItems;
        lastCheckBoxes = this.checkBoxes;
        Vector<Configuration> vector = new Vector<Configuration>();
        for (int i = 0; i < this.configurationItems.length; ++i) {
            if (!this.checkBoxes[i].isSelected()) continue;
            vector.add(this.configurationItems[i]);
        }
        return vector.toArray(new Configuration[vector.size()]);
    }

    private void initComponents() {
        this.label = new JLabel();
        this.confPanel = new JPanel();
        this.scrollPanel = new JScrollPane();
        this.innerPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.selectAllButton = new JButton();
        this.deselectAllButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.label.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("SELECTED_CONF_MN").charAt(0));
        this.label.setLabelFor(this.innerPanel);
        this.label.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("SELECTED_CONF_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 2, 0);
        this.add((Component)this.label, gridBagConstraints);
        this.confPanel.setLayout(new GridBagLayout());
        this.innerPanel.setLayout(new GridBagLayout());
        this.innerPanel.setBackground(new Color(255, 255, 255));
        this.scrollPanel.setViewportView(this.innerPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.confPanel.add((Component)this.scrollPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.confPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.selectAllButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("SELECT_ALL_BUTTON_MN").charAt(0));
        this.selectAllButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("SELECT_ALL_BUTTON_TXT"));
        this.selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfSelectorPanel.this.selectAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.buttonPanel.add((Component)this.selectAllButton, gridBagConstraints);
        this.deselectAllButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("DESELECT_ALL_BUTTON_MN").charAt(0));
        this.deselectAllButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle").getString("DESELECT_ALL_BUTTON_TXT"));
        this.deselectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfSelectorPanel.this.deselectAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.deselectAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 12);
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void deselectAllButtonActionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            this.checkBoxes[i].setSelected(false);
        }
        this.checkCheckBoxes();
    }

    private void selectAllButtonActionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            this.checkBoxes[i].setSelected(true);
        }
        this.checkCheckBoxes();
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(ConfSelectorPanel.class);
        }
        return bundle.getString(string);
    }

    class CheckBoxActionListener
    implements ActionListener {
        CheckBoxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConfSelectorPanel.this.checkCheckBoxes();
        }
    }
}

