/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.utils.ElfDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.ElfExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.ElfStaticLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.MacOSXDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.MacOSXExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.PeDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.PeExecutableFileFilter;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.ui.wizards.BuildActionsDescriptorPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class BuildActionsPanel
extends JPanel
implements HelpCtx.Provider {
    private DocumentListener documentListener;
    private boolean valid = false;
    private BuildActionsDescriptorPanel buildActionsDescriptorPanel;
    private String makefileName = null;
    private static String DEF_WORKING_DIR = "";
    private static String DEF_BUILD_COMMAND = "make";
    private static String DEF_CLEAN_COMMAND = "make clean";
    private static String DEF_BUILD_COMMAND_FMT = "{0} -f {1}";
    private static String DEF_CLEAN_COMMAND_FMT = "{0} -f {1} clean";
    private JLabel buildCommandLabel;
    private JTextField buildCommandTextField;
    private JButton buildCommandWorkingDirBrowseButton;
    private JLabel buildCommandWorkingDirLabel;
    private JTextField buildCommandWorkingDirTextField;
    private JLabel cleanCommandLabel;
    private JTextField cleanCommandTextField;
    private JLabel group2Label;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JButton outputBrowseButton;
    private JLabel outputLabel;
    private JTextField outputTextField;

    public BuildActionsPanel(BuildActionsDescriptorPanel buildActionsDescriptorPanel) {
        this.initComponents();
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.buildActionsDescriptorPanel = buildActionsDescriptorPanel;
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BuildActionsPanel.this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                BuildActionsPanel.this.update(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                BuildActionsPanel.this.update(documentEvent);
            }
        };
        this.buildCommandTextField.getDocument().addDocumentListener(this.documentListener);
        this.buildCommandWorkingDirTextField.getDocument().addDocumentListener(this.documentListener);
        this.cleanCommandTextField.getDocument().addDocumentListener(this.documentListener);
        this.outputTextField.getDocument().addDocumentListener(this.documentListener);
        this.buildCommandWorkingDirTextField.selectAll();
        this.buildCommandWorkingDirTextField.requestFocus();
        this.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("BUILD_ACTIONS_PANEL_AD"));
        this.buildCommandTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("BUILD_COMMAND_AD"));
        this.buildCommandWorkingDirTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("WORKING_DIR_AD"));
        this.cleanCommandTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("CLEAN_COMMAND_AD"));
        this.outputTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("OUTPUT_AD"));
        this.buildCommandWorkingDirBrowseButton.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("WORKING_DIR_BROWSE_BUTTON_AD"));
        this.outputBrowseButton.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("OUTPUT_BROWSE_BUTTON_AD"));
    }

    private void makefileFieldChanged() {
        File file = new File(this.makefileName);
        if (file.getParent() != null) {
            this.buildCommandWorkingDirTextField.setText(FilePathAdaptor.normalize(file.getParent()));
            String string = MessageFormat.format(DEF_BUILD_COMMAND_FMT, DEF_BUILD_COMMAND, file.getName());
            String string2 = MessageFormat.format(DEF_CLEAN_COMMAND_FMT, DEF_BUILD_COMMAND, file.getName());
            this.buildCommandTextField.setText(string);
            this.cleanCommandTextField.setText(string2);
        }
    }

    private void initFields() {
        this.buildCommandWorkingDirTextField.setText(DEF_WORKING_DIR);
        this.buildCommandTextField.setText(DEF_BUILD_COMMAND);
        this.cleanCommandTextField.setText(DEF_CLEAN_COMMAND);
        this.outputTextField.setText("");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BuildActionsPanel.class);
    }

    private void update(DocumentEvent documentEvent) {
        this.buildActionsDescriptorPanel.stateChanged(null);
    }

    void read(WizardDescriptor wizardDescriptor) {
        String string = (String)wizardDescriptor.getProperty("makefileName");
        if (this.makefileName == null || !this.makefileName.equals(string)) {
            this.initFields();
            this.makefileName = string;
            this.makefileFieldChanged();
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("buildCommandWorkingDirTextField", (Object)this.buildCommandWorkingDirTextField.getText());
        wizardDescriptor.putProperty("buildCommandTextField", (Object)this.buildCommandTextField.getText());
        wizardDescriptor.putProperty("cleanCommandTextField", (Object)this.cleanCommandTextField.getText());
        wizardDescriptor.putProperty("outputTextField", (Object)this.outputTextField.getText());
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.buildCommandWorkingDirTextField.getText().length() == 0) {
            String string = NbBundle.getMessage(BuildActionsPanel.class, (String)"NOWORKINGDIR");
            this.buildActionsDescriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        if (!(this.buildCommandWorkingDirTextField.getText().length() <= 0 || IpeUtils.isPathAbsolute((String)this.buildCommandWorkingDirTextField.getText()) && new File(this.buildCommandWorkingDirTextField.getText()).exists())) {
            String string = NbBundle.getMessage(BuildActionsPanel.class, (String)"WORKINGDIRDOESNOTEXIST");
            this.buildActionsDescriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        if (this.outputTextField.getText().length() > 0 && !IpeUtils.isPathAbsolute((String)this.outputTextField.getText())) {
            String string = NbBundle.getMessage(BuildActionsPanel.class, (String)"BUILDRESULTNOTABSOLUTE");
            this.buildActionsDescriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.buildCommandWorkingDirLabel = new JLabel();
        this.buildCommandWorkingDirTextField = new JTextField();
        this.buildCommandWorkingDirBrowseButton = new JButton();
        this.buildCommandLabel = new JLabel();
        this.buildCommandTextField = new JTextField();
        this.cleanCommandLabel = new JLabel();
        this.cleanCommandTextField = new JTextField();
        this.outputLabel = new JLabel();
        this.outputTextField = new JTextField();
        this.outputBrowseButton = new JButton();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.group2Label = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(323, 223));
        this.buildCommandWorkingDirLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("WORKING_DIR_MN").charAt(0));
        this.buildCommandWorkingDirLabel.setLabelFor(this.buildCommandWorkingDirTextField);
        this.buildCommandWorkingDirLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("WORKING_DIR_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.buildCommandWorkingDirLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.buildCommandWorkingDirTextField, gridBagConstraints);
        this.buildCommandWorkingDirBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("WORKING_DIR_BROWSE_BUTTON_MN").charAt(0));
        this.buildCommandWorkingDirBrowseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("WORKING_DIR_BROWSE_BUTTON_TXT"));
        this.buildCommandWorkingDirBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BuildActionsPanel.this.buildCommandWorkingDirBrowseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.buildCommandWorkingDirBrowseButton, gridBagConstraints);
        this.buildCommandLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("BUILD_COMMAND_MN").charAt(0));
        this.buildCommandLabel.setLabelFor(this.buildCommandTextField);
        this.buildCommandLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("BUILD_COMMAND_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.buildCommandLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.buildCommandTextField, gridBagConstraints);
        this.cleanCommandLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CLEAN_COMMAND_MN").charAt(0));
        this.cleanCommandLabel.setLabelFor(this.cleanCommandTextField);
        this.cleanCommandLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CLEAN_COMMAND_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.cleanCommandLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.cleanCommandTextField, gridBagConstraints);
        this.outputLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("OUTPUT_MN").charAt(0));
        this.outputLabel.setLabelFor(this.outputTextField);
        this.outputLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("OUTPUT_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.outputLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.outputTextField, gridBagConstraints);
        this.outputBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("OUTPUT_BROWSE_BUTTON_MN").charAt(0));
        this.outputBrowseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("OUTPUT_BROWSE_BUTTON_TXT"));
        this.outputBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BuildActionsPanel.this.outputBrowseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.outputBrowseButton, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("BuildActionsInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.group2Label.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("GROUP2_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.group2Label, gridBagConstraints);
    }

    private void outputBrowseButtonActionPerformed(ActionEvent actionEvent) {
        String string = null;
        string = this.outputTextField.getText().length() > 0 ? this.outputTextField.getText() : (this.buildCommandWorkingDirTextField.getText().length() > 0 ? this.buildCommandWorkingDirTextField.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home")));
        FileFilter[] fileFilterArray = Utilities.isWindows() ? new FileFilter[]{PeExecutableFileFilter.getInstance(), ElfStaticLibraryFileFilter.getInstance(), PeDynamicLibraryFileFilter.getInstance()} : (Utilities.getOperatingSystem() == 4096 ? new FileFilter[]{MacOSXExecutableFileFilter.getInstance(), ElfStaticLibraryFileFilter.getInstance(), MacOSXDynamicLibraryFileFilter.getInstance()} : new FileFilter[]{ElfExecutableFileFilter.getInstance(), ElfStaticLibraryFileFilter.getInstance(), ElfDynamicLibraryFileFilter.getInstance()});
        FileChooser fileChooser = new FileChooser(BuildActionsPanel.getString("OUTPUT_CHOOSER_TITLE_TXT"), BuildActionsPanel.getString("OUTPUT_CHOOSER_BUTTON_TXT"), 0, fileFilterArray, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return;
        }
        String string2 = FilePathAdaptor.normalize(fileChooser.getSelectedFile().getPath());
        this.outputTextField.setText(string2);
    }

    private void buildCommandWorkingDirBrowseButtonActionPerformed(ActionEvent actionEvent) {
        String string = null;
        string = this.buildCommandWorkingDirTextField.getText().length() > 0 ? this.buildCommandWorkingDirTextField.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
        FileChooser fileChooser = new FileChooser(BuildActionsPanel.getString("WORKING_DIR_CHOOSER_TITLE_TXT"), BuildActionsPanel.getString("WORKING_DIR_BUTTON_TXT"), 1, null, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return;
        }
        String string2 = fileChooser.getSelectedFile().getPath();
        string2 = FilePathAdaptor.normalize(string2);
        this.buildCommandWorkingDirTextField.setText(string2);
    }

    private static String getString(String string) {
        return NbBundle.getBundle(BuildActionsPanel.class).getString(string);
    }

    class MakefileDocumentListener
    implements DocumentListener {
        MakefileDocumentListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            BuildActionsPanel.this.makefileFieldChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BuildActionsPanel.this.makefileFieldChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            BuildActionsPanel.this.makefileFieldChanged();
        }
    }
}

