/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.utils.ConfigureFileFilter;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.MakefileFileFilter;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.ui.wizards.BuildActionsPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.MakefileOrConfigureDescriptorPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MakefileOrConfigurePanel
extends JPanel
implements HelpCtx.Provider {
    private DocumentListener documentListener;
    private boolean valid = false;
    private MakefileOrConfigureDescriptorPanel descriptorPanel;
    private ButtonGroup buttonGroup;
    private JLabel configureArgumentsLabel;
    private JTextField configureArgumentsTextField;
    private JButton configureBrowseButton;
    private JLabel configureMakefileNameLabel;
    private JTextField configureMakefileNameTextField;
    private JLabel configureNameLabel;
    private JTextField configureNameTextField;
    private JRadioButton configureRadioButton;
    private JLabel infoLabel;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JButton makefileBrowseButton;
    private JLabel makefileNameLabel;
    private JTextField makefileNameTextField;
    private JRadioButton makefileRadioButton;
    private JCheckBox runConfigureCheckBox;

    public MakefileOrConfigurePanel(MakefileOrConfigureDescriptorPanel makefileOrConfigureDescriptorPanel) {
        this.initComponents();
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.descriptorPanel = makefileOrConfigureDescriptorPanel;
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MakefileOrConfigurePanel.this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MakefileOrConfigurePanel.this.update(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                MakefileOrConfigurePanel.this.update(documentEvent);
            }
        };
        this.buttonGroup.add(this.makefileRadioButton);
        this.buttonGroup.add(this.configureRadioButton);
        this.makefileNameTextField.getDocument().addDocumentListener(this.documentListener);
        this.configureNameTextField.getDocument().addDocumentListener(this.documentListener);
        this.makefileNameTextField.requestFocus();
        this.getAccessibleContext().setAccessibleDescription(MakefileOrConfigurePanel.getString("MakefileOrConfigureName_AD"));
        this.makefileNameTextField.getAccessibleContext().setAccessibleDescription(MakefileOrConfigurePanel.getString("MAKEFILE_NAME_AD"));
        this.makefileBrowseButton.getAccessibleContext().setAccessibleDescription(MakefileOrConfigurePanel.getString("MAKEFILE_BROWSE_BUTTON_AD"));
    }

    private void initFields() {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NewMakeWizardP11");
    }

    private void update(DocumentEvent documentEvent) {
        this.descriptorPanel.stateChanged(null);
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.initFields();
    }

    void store(WizardDescriptor wizardDescriptor) {
        if (this.makefileRadioButton.isSelected()) {
            wizardDescriptor.putProperty("makefileName", (Object)this.makefileNameTextField.getText());
            wizardDescriptor.putProperty("configureName", (Object)"");
            wizardDescriptor.putProperty("configureArguments", (Object)"");
            wizardDescriptor.putProperty("runConfigure", (Object)"");
        } else {
            wizardDescriptor.putProperty("makefileName", (Object)this.configureMakefileNameTextField.getText());
            wizardDescriptor.putProperty("configureName", (Object)this.configureNameTextField.getText());
            wizardDescriptor.putProperty("configureArguments", (Object)this.configureArgumentsTextField.getText());
            wizardDescriptor.putProperty("runConfigure", (Object)(this.runConfigureCheckBox.isSelected() ? "true" : "false"));
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.makefileRadioButton.isSelected()) {
            this.makefileNameLabel.setEnabled(true);
            this.makefileNameTextField.setEnabled(true);
            this.makefileBrowseButton.setEnabled(true);
            this.configureNameLabel.setEnabled(false);
            this.configureNameTextField.setEnabled(false);
            this.configureArgumentsLabel.setEnabled(false);
            this.configureBrowseButton.setEnabled(false);
            this.configureArgumentsTextField.setEnabled(false);
            this.configureMakefileNameTextField.setEnabled(false);
            this.configureMakefileNameLabel.setEnabled(false);
            this.runConfigureCheckBox.setEnabled(false);
        } else {
            this.makefileNameLabel.setEnabled(false);
            this.makefileNameTextField.setEnabled(false);
            this.makefileBrowseButton.setEnabled(false);
            this.configureNameLabel.setEnabled(true);
            this.configureNameTextField.setEnabled(true);
            this.configureArgumentsLabel.setEnabled(true);
            this.configureBrowseButton.setEnabled(true);
            this.configureArgumentsTextField.setEnabled(true);
            this.configureMakefileNameTextField.setEnabled(true);
            this.configureMakefileNameLabel.setEnabled(true);
            this.runConfigureCheckBox.setEnabled(true);
        }
        if (this.makefileRadioButton.isSelected()) {
            String string;
            if (this.makefileNameTextField.getText().length() == 0) {
                String string2 = NbBundle.getMessage(BuildActionsPanel.class, (String)"NOMAKEFILE");
                this.descriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)string2);
                return false;
            }
            if (!IpeUtils.isPathAbsolute((String)this.makefileNameTextField.getText()) || !new File(this.makefileNameTextField.getText()).exists() || new File(this.makefileNameTextField.getText()).isDirectory()) {
                String string3 = NbBundle.getMessage(BuildActionsPanel.class, (String)"MAKEFILEDOESNOTEXIST");
                this.descriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)string3);
                return false;
            }
            String string4 = this.makefileNameTextField.getText();
            int n = string4.lastIndexOf(47);
            if (n > 0 && new File(string = string4.substring(0, n + 1) + "configure").exists()) {
                this.configureNameTextField.getDocument().removeDocumentListener(this.documentListener);
                this.configureNameTextField.setText(string);
                this.configureMakefileNameTextField.setText(string4);
                this.configureNameTextField.getDocument().addDocumentListener(this.documentListener);
            }
        } else {
            this.configureMakefileNameTextField.setText("");
            if (this.configureNameTextField.getText().length() == 0) {
                String string = NbBundle.getMessage(BuildActionsPanel.class, (String)"NOCONFIGUREFILE");
                this.descriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)string);
                return false;
            }
            if (!IpeUtils.isPathAbsolute((String)this.configureNameTextField.getText()) || !new File(this.configureNameTextField.getText()).exists() || new File(this.configureNameTextField.getText()).isDirectory()) {
                String string = NbBundle.getMessage(BuildActionsPanel.class, (String)"CONFIGUREFILEDOESNOTEXIST");
                this.descriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)string);
                return false;
            }
            int n = this.configureNameTextField.getText().lastIndexOf(47);
            if (n > 0) {
                String string = this.configureNameTextField.getText().substring(0, n + 1) + "Makefile";
                this.configureMakefileNameTextField.setText(string);
                if (new File(string).exists()) {
                    this.makefileNameTextField.getDocument().removeDocumentListener(this.documentListener);
                    this.makefileNameTextField.setText(string);
                    this.makefileNameTextField.getDocument().addDocumentListener(this.documentListener);
                }
            }
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.infoLabel = new JLabel();
        this.makefileRadioButton = new JRadioButton();
        this.makefileNameLabel = new JLabel();
        this.makefileNameTextField = new JTextField();
        this.makefileBrowseButton = new JButton();
        this.configureRadioButton = new JRadioButton();
        this.configureNameLabel = new JLabel();
        this.configureNameTextField = new JTextField();
        this.configureBrowseButton = new JButton();
        this.configureArgumentsLabel = new JLabel();
        this.configureArgumentsTextField = new JTextField();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.configureMakefileNameLabel = new JLabel();
        this.configureMakefileNameTextField = new JTextField();
        this.runConfigureCheckBox = new JCheckBox();
        this.setPreferredSize(new Dimension(323, 223));
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        this.infoLabel.setText(resourceBundle.getString("INTRO_LABEL_TXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.infoLabel, gridBagConstraints);
        this.makefileRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MAKEFILE_RADIO_BUTTON_MN").charAt(0));
        this.makefileRadioButton.setSelected(true);
        this.makefileRadioButton.setText(resourceBundle.getString("MAKEFILE_RADIO_BUTTON_TXT"));
        this.makefileRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.makefileRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MakefileOrConfigurePanel.this.makefileRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.makefileRadioButton, gridBagConstraints);
        this.makefileRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakefileOrConfigurePanel.class, (String)"MAKEFILE_RADIO_BUTTON_AD"));
        this.makefileNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MAKEFILE_NAME_MN").charAt(0));
        this.makefileNameLabel.setLabelFor(this.makefileNameTextField);
        this.makefileNameLabel.setText(resourceBundle.getString("MAKEFILE_NAME_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.add((Component)this.makefileNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.makefileNameTextField, gridBagConstraints);
        this.makefileBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MAKEFILE_BROWSE_BUTTON_MN").charAt(0));
        this.makefileBrowseButton.setText(resourceBundle.getString("MAKEFILE_BROWSE_BUTTON"));
        this.makefileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MakefileOrConfigurePanel.this.makefileBrowseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.makefileBrowseButton, gridBagConstraints);
        this.configureRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CONFIGURE_RADIO_BUTTON_MN").charAt(0));
        this.configureRadioButton.setText(resourceBundle.getString("CONFIGURE_RADIO_BUTTON_TXT"));
        this.configureRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.configureRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MakefileOrConfigurePanel.this.configureRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.configureRadioButton, gridBagConstraints);
        this.configureRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakefileOrConfigurePanel.class, (String)"CONFIGURE_RADIO_BUTTON_AD"));
        this.configureNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CONFIGURE_NAME_MN").charAt(0));
        this.configureNameLabel.setLabelFor(this.configureNameTextField);
        this.configureNameLabel.setText(resourceBundle.getString("CONFIGURE_NAME_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.add((Component)this.configureNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.configureNameTextField, gridBagConstraints);
        this.configureBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CONFIGURE_BROWSE_BUTTON_MN").charAt(0));
        this.configureBrowseButton.setText(resourceBundle.getString("CONFIGURE_BROWSE_BUTTON"));
        this.configureBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MakefileOrConfigurePanel.this.configureBrowseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.configureBrowseButton, gridBagConstraints);
        this.configureArgumentsLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CONFIGURE_ARGUMENT_LABEL_MN").charAt(0));
        this.configureArgumentsLabel.setLabelFor(this.configureArgumentsTextField);
        this.configureArgumentsLabel.setText(resourceBundle.getString("CONFIGURE_ARGUMENT_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.add((Component)this.configureArgumentsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.configureArgumentsTextField, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setText(resourceBundle.getString("MakefileOrConfigureInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        this.instructionsTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MakefileOrConfigurePanel.class, (String)"CONFIGURE_HELP"));
        this.instructionsTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakefileOrConfigurePanel.class, (String)"CONFIGURE_HELP_AD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.configureMakefileNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CONFIGURE_MAKEFILE_NAME_MN").charAt(0));
        this.configureMakefileNameLabel.setLabelFor(this.configureMakefileNameTextField);
        this.configureMakefileNameLabel.setText(resourceBundle.getString("CONFIGURE_MAKEFILE_NAME_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.configureMakefileNameLabel, gridBagConstraints);
        this.configureMakefileNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.configureMakefileNameTextField, gridBagConstraints);
        this.runConfigureCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("RUN_CONFIGURE_CHECKBOX").charAt(0));
        this.runConfigureCheckBox.setSelected(true);
        this.runConfigureCheckBox.setText(resourceBundle.getString("RUN_CONFIGURE_CHECKBOX"));
        this.runConfigureCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 16, 0, 0);
        this.add((Component)this.runConfigureCheckBox, gridBagConstraints);
    }

    private void configureRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.descriptorPanel.stateChanged(null);
    }

    private void makefileRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.descriptorPanel.stateChanged(null);
    }

    private void configureBrowseButtonActionPerformed(ActionEvent actionEvent) {
        String string = null;
        string = this.makefileNameTextField.getText().length() > 0 ? this.makefileNameTextField.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
        FileChooser fileChooser = new FileChooser(MakefileOrConfigurePanel.getString("CONFIGURE_CHOOSER_TITLE_TXT"), MakefileOrConfigurePanel.getString("MAKEFILE_CHOOSER_BUTTON_TXT"), 0, new FileFilter[]{ConfigureFileFilter.getInstance()}, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return;
        }
        String string2 = fileChooser.getSelectedFile().getPath();
        string2 = FilePathAdaptor.normalize(string2);
        this.configureNameTextField.setText(string2);
    }

    private void makefileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        String string = null;
        string = this.makefileNameTextField.getText().length() > 0 ? this.makefileNameTextField.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
        FileChooser fileChooser = new FileChooser(MakefileOrConfigurePanel.getString("MAKEFILE_CHOOSER_TITLE_TXT"), MakefileOrConfigurePanel.getString("MAKEFILE_CHOOSER_BUTTON_TXT"), 0, new FileFilter[]{MakefileFileFilter.getInstance()}, string, false);
        int n = fileChooser.showOpenDialog(this);
        if (n == 1) {
            return;
        }
        String string2 = fileChooser.getSelectedFile().getPath();
        string2 = FilePathAdaptor.normalize(string2);
        this.makefileNameTextField.setText(string2);
    }

    private static String getString(String string) {
        return NbBundle.getBundle(BuildActionsPanel.class).getString(string);
    }
}

