/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.cnd.api.utils.AllFileFilter;
import org.netbeans.modules.cnd.api.utils.AllSourceFileFilter;
import org.netbeans.modules.cnd.api.utils.CCSourceFileFilter;
import org.netbeans.modules.cnd.api.utils.CSourceFileFilter;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.FortranSourceFileFilter;
import org.netbeans.modules.cnd.api.utils.HeaderSourceFileFilter;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.ResourceFileFilter;
import org.netbeans.modules.cnd.api.utils.SourceFileFilter;
import org.netbeans.modules.cnd.makeproject.ui.wizards.FolderEntry;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.openide.util.NbBundle;

public class SourceFilesPanel
extends JPanel {
    private Vector data = new Vector();
    private SourceFileTable sourceFileTable = null;
    private String baseDir;
    private String wd;
    private JButton addButton;
    private JPanel buttonPanel;
    private JButton deleteButton;
    private JComboBox filterComboBox;
    private JLabel filterText;
    private JList list;
    private JScrollPane scrollPane;
    private JLabel sourceFilesLabel;

    public SourceFilesPanel() {
        this.initComponents();
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.filterComboBox.removeAllItems();
        this.filterComboBox.addItem(CSourceFileFilter.getInstance().getSuffixesAsString());
        this.filterComboBox.addItem(CCSourceFileFilter.getInstance().getSuffixesAsString());
        this.filterComboBox.addItem(HeaderSourceFileFilter.getInstance().getSuffixesAsString());
        if (CppSettings.getDefault().isFortranEnabled()) {
            this.filterComboBox.addItem(FortranSourceFileFilter.getInstance().getSuffixesAsString());
        }
        this.filterComboBox.addItem(ResourceFileFilter.getInstance().getSuffixesAsString());
        this.filterComboBox.addItem(AllSourceFileFilter.getInstance().getSuffixesAsString());
        this.filterComboBox.addItem(AllFileFilter.getInstance().getSuffixesAsString());
        this.filterComboBox.setSelectedItem(AllSourceFileFilter.getInstance().getSuffixesAsString());
        this.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("SourceFilesPanelAD"));
        this.addButton.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("AddButtonAD"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("DeleteButtonAD"));
        this.refresh();
        this.initFocus();
    }

    public void setSeed(String string, String string2) {
        this.baseDir = string;
        this.wd = string2;
    }

    public void initFocus() {
        IpeUtils.requestFocus((Component)this.addButton);
    }

    public Vector getListData() {
        String string = (String)this.filterComboBox.getSelectedItem();
        FolderEntry.setFileFilter((FileFilter)((Object)new CustomFileFilter(string)));
        return this.data;
    }

    private void validateSelection() {
        this.addButton.setEnabled(true);
        if (this.data.size() == 0 || this.sourceFileTable.getSelectedRow() < 0) {
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
        }
    }

    private void refresh() {
        this.sourceFileTable = new SourceFileTable();
        this.scrollPane.setViewportView(this.sourceFileTable);
        this.sourceFilesLabel.setLabelFor(this.sourceFileTable);
        this.validateSelection();
    }

    private void initComponents() {
        this.sourceFilesLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.filterText = new JLabel();
        this.filterComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.sourceFilesLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("SourceFileFoldersMN").charAt(0));
        this.sourceFilesLabel.setLabelFor(this.list);
        this.sourceFilesLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("SourceFileFoldersLbl"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceFilesLabel, gridBagConstraints);
        this.scrollPane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.addButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("AddButtonMN").charAt(0));
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("AddButtonTxt"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFilesPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        this.deleteButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("DeleteButtonMn").charAt(0));
        this.deleteButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("DeleteButtonTxt"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFilesPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.buttonPanel.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.buttonPanel, gridBagConstraints);
        this.filterText.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("FileTypesFilterMN").charAt(0));
        this.filterText.setLabelFor(this.filterComboBox);
        this.filterText.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("FileTypesFilterLBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.filterText, gridBagConstraints);
        this.filterComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.filterComboBox, gridBagConstraints);
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.sourceFileTable.getSelectedRow();
        if (n < 0 || n >= this.data.size()) {
            return;
        }
        this.data.remove(n);
        this.refresh();
        if (this.data.size() > 0) {
            if (this.data.size() > n) {
                this.sourceFileTable.getSelectionModel().setSelectionInterval(n, n);
            } else {
                this.sourceFileTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        FileChooser fileChooser;
        int n;
        String string = null;
        if (FileChooser.getCurrectChooserFile() != null) {
            string = FileChooser.getCurrectChooserFile().getPath();
        }
        if (string == null) {
            string = this.wd != null && this.wd.length() > 0 && !IpeUtils.isPathAbsolute((String)this.wd) ? this.baseDir + File.separator + this.wd : (this.wd != null ? this.wd : this.baseDir);
        }
        if ((n = (fileChooser = new FileChooser(SourceFilesPanel.getString("FOLDER_CHOOSER_TITLE_TXT"), SourceFilesPanel.getString("FOLDER_CHOOSER_BUTTON_TXT"), 1, null, string, true)).showOpenDialog((Component)this)) == 1) {
            return;
        }
        if (!fileChooser.getSelectedFile().exists() || !fileChooser.getSelectedFile().isDirectory()) {
            return;
        }
        this.data.add(new FolderEntry(fileChooser.getSelectedFile(), IpeUtils.toAbsoluteOrRelativePath((String)this.baseDir, (String)fileChooser.getSelectedFile().getPath())));
        this.refresh();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(SourceFilesPanel.class, (String)string);
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        MyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setBackground(Color.WHITE);
                jCheckBox.setSelected(((FolderEntry)SourceFilesPanel.this.data.elementAt(n)).isAddSubfoldersSelected());
                return jCheckBox;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return " " + SourceFilesPanel.getString("TABLE_COLUMN_0_TXT");
            }
            return " " + SourceFilesPanel.getString("TABLE_COLUMN_1_TXT");
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return SourceFilesPanel.this.data.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return SourceFilesPanel.this.data.elementAt(n);
            }
            return ((FolderEntry)SourceFilesPanel.this.data.elementAt(n)).getFolderName();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }

    class SourceFileTable
    extends JTable {
        public SourceFileTable() {
            this.setModel(new MyTableModel());
            ((DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
            this.getColumnModel().getColumn(0).setPreferredWidth(95);
            this.getColumnModel().getColumn(0).setMaxWidth(95);
            this.getColumnModel().getColumn(0).setResizable(false);
            this.getSelectionModel().setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new TargetSelectionListener());
            this.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("SourceFileTableAD"));
        }

        public boolean getShowHorizontalLines() {
            return false;
        }

        public boolean getShowVerticalLines() {
            return false;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return new MyTableCellRenderer();
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            JCheckBox jCheckBox = new JCheckBox();
            return new DefaultCellEditor(jCheckBox);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                FolderEntry folderEntry;
                folderEntry.setAddSubfoldersSelected(!(folderEntry = (FolderEntry)SourceFilesPanel.this.data.elementAt(n)).isAddSubfoldersSelected());
            }
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            SourceFilesPanel.this.validateSelection();
        }
    }

    private class CustomFileFilter
    extends SourceFileFilter {
        String[] suffixes;

        CustomFileFilter(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.charAt(0) == '.') {
                    string2 = string2.substring(1);
                }
                vector.add(string2);
            }
            this.suffixes = vector.toArray(new String[vector.size()]);
        }

        public String getDescription() {
            return "";
        }

        public String[] getSuffixes() {
            return this.suffixes;
        }
    }
}

