/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.vmd.api.model.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeUtils {
    public static SimpleSection findSectionByPrefix(Iterable<? extends GuardedSection> iterable, String string) {
        for (GuardedSection guardedSection : iterable) {
            if (!(guardedSection instanceof SimpleSection) || !guardedSection.getName().startsWith(string)) continue;
            return (SimpleSection)guardedSection;
        }
        return null;
    }

    public static ArrayList<SimpleSection> findSectionsByPrefix(Iterable<? extends GuardedSection> iterable, String string) {
        ArrayList<SimpleSection> arrayList = new ArrayList<SimpleSection>();
        for (GuardedSection guardedSection : iterable) {
            if (!(guardedSection instanceof SimpleSection) || !guardedSection.getName().startsWith(string)) continue;
            arrayList.add((SimpleSection)guardedSection);
        }
        return arrayList;
    }

    public static void sortSections(ArrayList<SimpleSection> arrayList) {
        Collections.sort(arrayList, new Comparator<SimpleSection>(){

            @Override
            public int compare(SimpleSection simpleSection, SimpleSection simpleSection2) {
                return simpleSection.getName().compareTo(simpleSection2.getName());
            }
        });
    }

    public static GuardedSection findLast(Iterable<? extends GuardedSection> iterable) {
        GuardedSection guardedSection = null;
        for (GuardedSection guardedSection2 : iterable) {
            if (guardedSection == null) {
                guardedSection = guardedSection2;
                continue;
            }
            if (guardedSection.getEndPosition().getOffset() >= guardedSection2.getEndPosition().getOffset()) continue;
            guardedSection = guardedSection2;
        }
        return guardedSection;
    }

    public static SimpleSection createSimpleSectionAfter(StyledDocument styledDocument, GuardedSection guardedSection, String string) {
        GuardedSectionManager guardedSectionManager = GuardedSectionManager.getInstance((StyledDocument)styledDocument);
        try {
            return guardedSectionManager.createSimpleSection(styledDocument.createPosition(guardedSection.getEndPosition().getOffset() + 1), string);
        }
        catch (BadLocationException badLocationException) {
            throw Debug.error((Object[])new Object[]{badLocationException});
        }
    }
}

