/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.util.Comparator;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskComparator {
    private static Comparator<Task> DEFAULT_COMPARATOR;

    private TaskComparator() {
    }

    public static Comparator<Task> getDefault() {
        if (null == DEFAULT_COMPARATOR) {
            DEFAULT_COMPARATOR = new Comparator<Task>(){

                @Override
                public int compare(Task task, Task task2) {
                    int n = 0;
                    n = Accessor.getGroup(task).compareTo(Accessor.getGroup(task2));
                    if (0 == n) {
                        FileObject fileObject = Accessor.getResource(task);
                        FileObject fileObject2 = Accessor.getResource(task2);
                        if (null == fileObject && null != fileObject2) {
                            n = -1;
                        } else if (null != fileObject && null == fileObject2) {
                            n = 1;
                        } else if (null != fileObject && null != fileObject2) {
                            n = fileObject.getPath().compareTo(fileObject2.getPath());
                        }
                    }
                    if (0 == n) {
                        if (Accessor.getLine(task) <= 0 && Accessor.getLine(task2) > 0) {
                            n = -1;
                        } else if (Accessor.getLine(task) > 0 && Accessor.getLine(task2) <= 0) {
                            n = 1;
                        } else if (Accessor.getLine(task) > 0 && Accessor.getLine(task2) > 0) {
                            n = Accessor.getLine(task) - Accessor.getLine(task2);
                        }
                    }
                    if (0 == n) {
                        n = Accessor.getDescription(task).compareTo(Accessor.getDescription(task2));
                    }
                    return n;
                }
            };
        }
        return DEFAULT_COMPARATOR;
    }

    public static Comparator<Task> getDescriptionComparator(boolean bl) {
        return new DescriptionComparator(bl);
    }

    public static Comparator<Task> getLocationComparator(boolean bl) {
        return new LocationComparator(bl);
    }

    public static Comparator<Task> getLineComparator(boolean bl) {
        return new LineComparator(bl);
    }

    public static Comparator<Task> getFileComparator(boolean bl) {
        return new FileComparator(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocationComparator
    implements Comparator<Task> {
        private boolean asc;

        public LocationComparator(boolean bl) {
            this.asc = bl;
        }

        @Override
        public int compare(Task task, Task task2) {
            int n = 0;
            FileObject fileObject = Accessor.getResource(task);
            FileObject fileObject2 = Accessor.getResource(task2);
            if (null == fileObject && null != fileObject2) {
                n = -1;
            } else if (null != fileObject && null == fileObject2) {
                n = 1;
            } else if (null != fileObject && null != fileObject2) {
                n = fileObject.getPath().compareTo(fileObject2.getPath());
            }
            if (0 == n) {
                n = TaskComparator.getDefault().compare(task, task2);
            } else if (!this.asc) {
                n *= -1;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LocationComparator locationComparator = (LocationComparator)object;
            return this.asc == locationComparator.asc;
        }

        public int hashCode() {
            int n = 7;
            n = 99 * n + (this.asc ? 1 : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileComparator
    implements Comparator<Task> {
        private boolean asc;

        public FileComparator(boolean bl) {
            this.asc = bl;
        }

        @Override
        public int compare(Task task, Task task2) {
            int n = 0;
            FileObject fileObject = Accessor.getResource(task);
            FileObject fileObject2 = Accessor.getResource(task2);
            if (null == fileObject && null != fileObject2) {
                n = -1;
            } else if (null != fileObject && null == fileObject2) {
                n = 1;
            } else if (null != fileObject && null != fileObject2) {
                n = fileObject.getNameExt().compareTo(fileObject2.getNameExt());
            }
            if (0 == n) {
                n = TaskComparator.getDefault().compare(task, task2);
            } else if (!this.asc) {
                n *= -1;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FileComparator fileComparator = (FileComparator)object;
            return this.asc == fileComparator.asc;
        }

        public int hashCode() {
            int n = 7;
            n = 89 * n + (this.asc ? 1 : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LineComparator
    implements Comparator<Task> {
        private boolean asc;

        public LineComparator(boolean bl) {
            this.asc = bl;
        }

        @Override
        public int compare(Task task, Task task2) {
            int n = 0;
            if (Accessor.getLine(task) <= 0 && Accessor.getLine(task2) > 0) {
                n = -1;
            } else if (Accessor.getLine(task) > 0 && Accessor.getLine(task2) <= 0) {
                n = 1;
            } else if (Accessor.getLine(task) > 0 && Accessor.getLine(task2) > 0) {
                n = Accessor.getLine(task) - Accessor.getLine(task2);
            }
            if (0 == n) {
                n = TaskComparator.getDefault().compare(task, task2);
            } else if (!this.asc) {
                n *= -1;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LineComparator lineComparator = (LineComparator)object;
            return this.asc == lineComparator.asc;
        }

        public int hashCode() {
            int n = 7;
            n = 79 * n + (this.asc ? 1 : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescriptionComparator
    implements Comparator<Task> {
        private boolean asc;

        public DescriptionComparator(boolean bl) {
            this.asc = bl;
        }

        @Override
        public int compare(Task task, Task task2) {
            int n = Accessor.getDescription(task).compareTo(Accessor.getDescription(task2));
            if (0 == n) {
                n = TaskComparator.getDefault().compare(task, task2);
            } else if (!this.asc) {
                n *= -1;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DescriptionComparator descriptionComparator = (DescriptionComparator)object;
            return this.asc == descriptionComparator.asc;
        }

        public int hashCode() {
            int n = 7;
            n = 69 * n + (this.asc ? 1 : 0);
            return n;
        }
    }
}

