/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskComparator;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.modules.tasklist.ui.TaskListModel;
import org.netbeans.spi.tasklist.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FoldingTaskListModel
extends TaskListModel {
    private LinkedList<FoldingGroup> groups = new LinkedList();
    private HashMap<String, FoldingGroup> groupMap = new HashMap(10);

    public FoldingTaskListModel(TaskList taskList) {
        super(taskList);
        this.sortTaskList();
        this.tasksAdded(taskList.getTasks());
    }

    @Override
    public int getRowCount() {
        if (null == this.list) {
            return 0;
        }
        int n = 0;
        for (FoldingGroup foldingGroup : this.groups) {
            n += foldingGroup.getRowCount();
        }
        return n;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (0 == n) {
            return FoldingGroup.class;
        }
        return super.getColumnClass(n);
    }

    @Override
    protected Task getTaskAtRow(int n) {
        if (this.isGroupRow(n)) {
            return null;
        }
        int n2 = 0;
        for (FoldingGroup foldingGroup : this.groups) {
            if (n < n2 + foldingGroup.getRowCount()) {
                return foldingGroup.getTaskAt(n - n2 - 1);
            }
            n2 += foldingGroup.getRowCount();
        }
        return null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        FoldingGroup foldingGroup = this.getGroupAtRow(n);
        if (null != foldingGroup) {
            switch (n2) {
                case 0: {
                    return foldingGroup;
                }
            }
            return null;
        }
        return super.getValueAt(n, n2);
    }

    FoldingGroup getGroupAtRow(int n) {
        int n2 = 0;
        for (FoldingGroup foldingGroup : this.groups) {
            if (foldingGroup.isEmpty()) continue;
            if (n == n2) {
                return foldingGroup;
            }
            n2 += foldingGroup.getRowCount();
        }
        return null;
    }

    private Map<FoldingGroup, List<Task>> divideByGroup(List<? extends Task> list) {
        HashMap<FoldingGroup, List<Task>> hashMap = new HashMap<FoldingGroup, List<Task>>(this.groupMap.size());
        for (Task task : list) {
            LinkedList<Task> linkedList;
            TaskGroup taskGroup = Accessor.getGroup(task);
            FoldingGroup foldingGroup = this.groupMap.get(taskGroup.getName());
            if (null == foldingGroup) {
                foldingGroup = new FoldingGroup(taskGroup);
                this.groupMap.put(taskGroup.getName(), foldingGroup);
                this.groups.add(foldingGroup);
                Collections.sort(this.groups);
            }
            if (null == (linkedList = (LinkedList<Task>)hashMap.get(foldingGroup))) {
                linkedList = new LinkedList<Task>();
                hashMap.put(foldingGroup, linkedList);
            }
            linkedList.add(task);
        }
        return hashMap;
    }

    @Override
    public void tasksAdded(List<? extends Task> list) {
        if (list.isEmpty()) {
            return;
        }
        Map<FoldingGroup, List<Task>> map = this.divideByGroup(list);
        for (FoldingGroup foldingGroup : map.keySet()) {
            List<Task> list2 = map.get(foldingGroup);
            foldingGroup.add(list2);
        }
    }

    @Override
    public void tasksRemoved(List<? extends Task> list) {
        if (list.isEmpty()) {
            return;
        }
        Map<FoldingGroup, List<Task>> map = this.divideByGroup(list);
        for (FoldingGroup foldingGroup : map.keySet()) {
            List<Task> list2 = map.get(foldingGroup);
            foldingGroup.remove(list2);
        }
    }

    @Override
    public void cleared() {
        for (FoldingGroup foldingGroup : this.groups) {
            foldingGroup.clear();
        }
    }

    public boolean isGroupRow(int n) {
        return null != this.getGroupAtRow(n);
    }

    public void toggleGroupExpanded(int n) {
        FoldingGroup foldingGroup = this.getGroupAtRow(n);
        if (null != foldingGroup) {
            foldingGroup.toggleExpanded();
        }
    }

    private int getFoldingGroupStartingRow(FoldingGroup foldingGroup) {
        if (foldingGroup.isEmpty()) {
            return -1;
        }
        int n = 0;
        int n2 = this.groups.indexOf(foldingGroup);
        for (int i = 0; i < n2; ++i) {
            n += this.groups.get(i).getRowCount();
        }
        return n;
    }

    @Override
    protected void sortTaskList() {
        Comparator<Task> comparator = null;
        switch (this.sortingCol) {
            case 1: {
                comparator = TaskComparator.getDescriptionComparator(this.ascending);
                break;
            }
            case 3: {
                comparator = TaskComparator.getLineComparator(this.ascending);
                break;
            }
            case 4: {
                comparator = TaskComparator.getLocationComparator(this.ascending);
                break;
            }
            case 2: {
                comparator = TaskComparator.getFileComparator(this.ascending);
                break;
            }
            default: {
                comparator = TaskComparator.getDefault();
            }
        }
        if (null != this.groups) {
            for (FoldingGroup foldingGroup : this.groups) {
                foldingGroup.setComparator(comparator);
            }
            Settings.getDefault().setSortingColumn(this.sortingCol);
            Settings.getDefault().setAscendingSort(this.ascending);
        }
        this.fireTableDataChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FoldingGroup
    implements Comparable<FoldingGroup> {
        private TaskGroup tg;
        private ArrayList<Task> tasks = new ArrayList(100);
        private boolean isExpanded;
        private Comparator<Task> comparator;

        public FoldingGroup(TaskGroup taskGroup) {
            this.tg = taskGroup;
            this.isExpanded = Settings.getDefault().isGroupExpanded(taskGroup.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(List<Task> list) {
            boolean bl = this.isEmpty();
            ArrayList<Task> arrayList = this.tasks;
            synchronized (arrayList) {
                this.tasks.addAll(list);
                Collections.sort(this.tasks, this.getComparator());
            }
            int n = FoldingTaskListModel.this.getFoldingGroupStartingRow(this);
            if (bl) {
                FoldingTaskListModel.this.fireTableRowsInserted(n, n + this.getRowCount());
            } else {
                if (this.isExpanded) {
                    int n2 = Integer.MAX_VALUE;
                    int n3 = Integer.MIN_VALUE;
                    for (Task task : list) {
                        int n4 = this.tasks.indexOf(task);
                        if (n4 < n2) {
                            n2 = n4;
                        }
                        if (n4 <= n3) continue;
                        n3 = n4;
                    }
                    FoldingTaskListModel.this.fireTableRowsInserted(n2 + n + 1, n3 + n + 1);
                }
                FoldingTaskListModel.this.fireTableCellUpdated(n, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(List<Task> list) {
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            int n3 = this.getRowCount();
            if (this.isExpanded) {
                for (Task task : list) {
                    int n4 = this.tasks.indexOf(task);
                    if (n4 < n) {
                        n = n4;
                    }
                    if (n4 <= n2) continue;
                    n2 = n4;
                }
            }
            ArrayList<Task> arrayList = this.tasks;
            synchronized (arrayList) {
                this.tasks.removeAll(list);
            }
            int n5 = FoldingTaskListModel.this.getFoldingGroupStartingRow(this);
            if (this.isEmpty()) {
                FoldingTaskListModel.this.fireTableRowsDeleted(n5, n5 + n3);
            } else {
                if (this.isExpanded) {
                    FoldingTaskListModel.this.fireTableRowsDeleted(n + n5 + 1, n2 + n5 + 1);
                }
                FoldingTaskListModel.this.fireTableCellUpdated(n5, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (this.isEmpty()) {
                return;
            }
            int n = this.getRowCount();
            int n2 = FoldingTaskListModel.this.getFoldingGroupStartingRow(this);
            ArrayList<Task> arrayList = this.tasks;
            synchronized (arrayList) {
                this.tasks.clear();
            }
            FoldingTaskListModel.this.fireTableRowsDeleted(n2, n2 + n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            ArrayList<Task> arrayList = this.tasks;
            synchronized (arrayList) {
                return this.tasks.isEmpty();
            }
        }

        public void setExpanded(boolean bl) {
            if (this.isExpanded == bl) {
                return;
            }
            this.toggleExpanded();
        }

        public void toggleExpanded() {
            int n;
            this.isExpanded = !this.isExpanded;
            Settings.getDefault().setGroupExpanded(this.tg.getName(), this.isExpanded);
            int n2 = 0;
            int n3 = FoldingTaskListModel.this.groups.indexOf(this);
            for (n = 0; n < n3; ++n) {
                n2 += ((FoldingGroup)FoldingTaskListModel.this.groups.get(n)).getRowCount();
            }
            n = n2 + this.getTaskCount();
            ++n2;
            if (this.isExpanded) {
                FoldingTaskListModel.this.fireTableRowsInserted(n2, n);
            } else {
                FoldingTaskListModel.this.fireTableRowsDeleted(n2, n);
            }
            FoldingTaskListModel.this.fireTableCellUpdated(n2 - 1, 0);
        }

        public int getRowCount() {
            return this.isEmpty() ? 0 : (this.isExpanded ? 1 + this.tasks.size() : 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getTaskCount() {
            ArrayList<Task> arrayList = this.tasks;
            synchronized (arrayList) {
                return this.tasks.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task getTaskAt(int n) {
            ArrayList<Task> arrayList = this.tasks;
            synchronized (arrayList) {
                return this.tasks.get(n);
            }
        }

        @Override
        public int compareTo(FoldingGroup foldingGroup) {
            List list = TaskGroup.getGroups();
            int n = list.indexOf(this.tg);
            int n2 = list.indexOf(foldingGroup.tg);
            return n - n2;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public TaskGroup getGroup() {
            return this.tg;
        }

        private Comparator<Task> getComparator() {
            if (null == this.comparator) {
                this.comparator = TaskComparator.getDefault();
            }
            return this.comparator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setComparator(Comparator<Task> comparator) {
            if (((Object)this.getComparator()).equals(comparator)) {
                return;
            }
            this.comparator = comparator;
            ArrayList<Task> arrayList = this.tasks;
            synchronized (arrayList) {
                if (!this.tasks.isEmpty()) {
                    Collections.sort(this.tasks, this.getComparator());
                    if (this.isExpanded()) {
                        int n;
                        int n2 = 0;
                        int n3 = FoldingTaskListModel.this.groups.indexOf(this);
                        for (n = 0; n < n3; ++n) {
                            n2 += ((FoldingGroup)FoldingTaskListModel.this.groups.get(n)).getRowCount();
                        }
                        n = n2 + this.getTaskCount();
                        FoldingTaskListModel.this.fireTableRowsUpdated(++n2, n);
                    }
                }
            }
        }
    }
}

