/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NbSafeDeleteRefactoringPlugin
extends AbstractRefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();

    public NbSafeDeleteRefactoringPlugin(AbstractRefactoring abstractRefactoring) {
        super(abstractRefactoring);
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem problem;
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        try {
            SafeDeleteRefactoring safeDeleteRefactoring = (SafeDeleteRefactoring)this.refactoring;
            problem = null;
            Lookup lookup = safeDeleteRefactoring.getRefactoringSource();
            AbstractRefactoringPlugin.InfoHolder infoHolder = this.examineLookup(lookup);
            TreePathHandle treePathHandle = (TreePathHandle)lookup.lookup(TreePathHandle.class);
            Project project = FileOwnerQuery.getOwner((FileObject)treePathHandle.getFileObject());
            if (project == null || project.getLookup().lookup(NbModuleProvider.class) == null) {
                Problem problem2 = null;
                return problem2;
            }
            if (infoHolder.isClass) {
                this.checkManifest(project, infoHolder.fullName, refactoringElementsBag);
                this.checkMetaInfServices(project, infoHolder.fullName, refactoringElementsBag);
                this.checkLayer(project, infoHolder.fullName, refactoringElementsBag);
            }
            if (infoHolder.isMethod) {
                this.checkMethodLayer(infoHolder, treePathHandle.getFileObject(), refactoringElementsBag);
            }
            if (infoHolder.isConstructor) {
                this.checkConstructorLayer(infoHolder, treePathHandle.getFileObject(), refactoringElementsBag);
            }
            err.log("Gonna return problem: " + problem);
            Problem problem3 = problem;
            return problem3;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            problem = null;
            return problem;
        }
        finally {
            semafor.set(null);
        }
    }

    protected RefactoringElementImplementation createManifestRefactoring(String string, FileObject fileObject, String string2, String string3, String string4) {
        return new ManifestSafeDeleteRefactoringElement(fileObject, string3, string2, string4);
    }

    protected RefactoringElementImplementation createMetaInfServicesRefactoring(String string, FileObject fileObject, int n) {
        return new ServicesSafeDeleteRefactoringElement(string, fileObject);
    }

    protected RefactoringElementImplementation createConstructorLayerRefactoring(String string, String string2, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string3) {
        return new LayerSafeDeleteRefactoringElement(string, layerHandle, fileObject);
    }

    protected RefactoringElementImplementation createLayerRefactoring(String string, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string2) {
        return new LayerSafeDeleteRefactoringElement(string, layerHandle, fileObject, string2);
    }

    protected RefactoringElementImplementation createMethodLayerRefactoring(String string, String string2, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string3) {
        return new LayerSafeDeleteRefactoringElement(string, layerHandle, fileObject);
    }

    public final class LayerSafeDeleteRefactoringElement
    extends AbstractRefactoringElement {
        private FileObject layerFO;
        private LayerUtils.LayerHandle handle;
        private String attribute;

        public LayerSafeDeleteRefactoringElement(String string, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string2) {
            this(string, layerHandle, fileObject);
            this.attribute = string2;
        }

        public LayerSafeDeleteRefactoringElement(String string, LayerUtils.LayerHandle layerHandle, FileObject fileObject) {
            this.name = string;
            this.handle = layerHandle;
            this.parentFile = layerHandle.getLayerFile();
            this.layerFO = fileObject;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(NbSafeDeleteRefactoringPlugin.class, (String)"TXT_LayerDelete", (Object)this.layerFO.getNameExt());
        }

        public void performChange() {
            boolean bl = this.handle.isAutosave();
            if (!bl) {
                this.handle.setAutosave(true);
            }
            try {
                if (this.attribute != null) {
                    this.layerFO.setAttribute(this.attribute, null);
                    if ("originalFile".equals(this.attribute)) {
                        this.layerFO.delete();
                    }
                } else {
                    this.layerFO.delete();
                }
                this.deleteEmptyParent(this.layerFO.getParent());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            if (!bl) {
                this.handle.setAutosave(false);
            }
        }

        private void deleteEmptyParent(FileObject fileObject) throws IOException {
            if (fileObject != null && !fileObject.getChildren(true).hasMoreElements() && !fileObject.getAttributes().hasMoreElements()) {
                FileObject fileObject2 = fileObject.getParent();
                fileObject.delete();
                this.deleteEmptyParent(fileObject2);
            }
        }

        public void undoChange() {
        }
    }

    public final class ServicesSafeDeleteRefactoringElement
    extends AbstractRefactoringElement {
        private String oldName;
        private String oldContent;
        private File parent;

        public ServicesSafeDeleteRefactoringElement(String string, FileObject fileObject) {
            this.name = string.substring(string.lastIndexOf(46));
            this.parentFile = fileObject;
            this.oldName = string;
            this.oldContent = Utility.readFileIntoString(this.parentFile);
            this.parent = FileUtil.toFile((FileObject)this.parentFile);
        }

        public String getDisplayText() {
            return NbBundle.getMessage(NbSafeDeleteRefactoringPlugin.class, (String)"TXT_ServicesDelete", (Object)this.name);
        }

        public void performChange() {
            String string = Utility.readFileIntoString(this.parentFile);
            if (string != null) {
                String string2 = this.oldName;
                string2 = string2.replaceAll("[.]", "\\.");
                string = string.replaceAll("^" + string2 + "[ \\\n]?", "");
                boolean bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    if (string3.length() <= 0 || Pattern.matches("^[#].*", string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    Utility.writeFileFromString(this.parentFile, string);
                } else {
                    try {
                        this.parentFile.delete();
                    }
                    catch (IOException iOException) {
                        AbstractRefactoringPlugin.err.notify((Throwable)iOException);
                    }
                }
            }
        }

        public void undoChange() {
            try {
                if (this.oldContent != null) {
                    FileObject fileObject;
                    if (!this.parent.exists() && (fileObject = FileUtil.toFileObject((File)this.parent.getParentFile())) != null) {
                        this.parentFile = fileObject.createData(this.parent.getName());
                    }
                    Utility.writeFileFromString(this.parentFile, this.oldContent);
                }
            }
            catch (IOException iOException) {
                AbstractRefactoringPlugin.err.notify((Throwable)iOException);
            }
        }
    }

    public final class ManifestSafeDeleteRefactoringElement
    extends AbstractRefactoringElement {
        private String attrName;
        private String sectionName = null;
        private String oldContent;

        public ManifestSafeDeleteRefactoringElement(FileObject fileObject, String string, String string2) {
            this.name = string;
            this.parentFile = fileObject;
            this.attrName = string2;
            this.oldContent = Utility.readFileIntoString(fileObject);
        }

        public ManifestSafeDeleteRefactoringElement(FileObject fileObject, String string, String string2, String string3) {
            this(fileObject, string, string2);
            this.sectionName = string3;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage(NbSafeDeleteRefactoringPlugin.class, (String)"TXT_ManifestSectionDelete", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage(NbSafeDeleteRefactoringPlugin.class, (String)"TXT_ManifestDelete", (Object)this.name, (Object)this.attrName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performChange() {
            FileLock fileLock = null;
            OutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                inputStream = this.parentFile.getInputStream();
                EditableManifest editableManifest = new EditableManifest(inputStream);
                inputStream.close();
                inputStream = null;
                if (this.sectionName != null) {
                    editableManifest.removeSection(this.name);
                } else {
                    editableManifest.removeAttribute(this.attrName, null);
                }
                fileLock = this.parentFile.lock();
                outputStream = this.parentFile.getOutputStream(fileLock);
                editableManifest.write(outputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                AbstractRefactoringPlugin.err.notify((Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                AbstractRefactoringPlugin.err.notify((Throwable)iOException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        AbstractRefactoringPlugin.err.notify((Throwable)iOException);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        AbstractRefactoringPlugin.err.notify((Throwable)iOException);
                    }
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        public void undoChange() {
            if (this.oldContent != null) {
                Utility.writeFileFromString(this.parentFile, this.oldContent);
            }
        }
    }
}

