/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg.input;

import javax.microedition.lcdui.Display;
import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGTextField;
import org.netbeans.microedition.svg.input.TextInputHandler;

public class NumPadInputHandler
extends TextInputHandler {
    private static final int MAX_REPEAT_TIME = 1000;
    private static final int CARET_BLINK_TIME = 500;
    private static final String[] NUMKEY_MAPPING = new String[]{"0", " .,?!1@'-_():;&/%*#+<=>\"\u00c2\u00bf\u00c2\u00a1\u00c2\u00a7$\u00c2\u00a3\u00c2\u00a5\u00c2\u00a4", "abc2\u00c3\u00a4\u00c3\u00a0\u00c3\u00a1\u00c3\u00a2\u00c3\u00a3\u00c3\u00a5\u00c3\u00a6\u00c3\u00a7", "def3\u00c3\u00a8\u00c3\u00a9\u00c3\u00aa\u00c3\u00ab", "ghi4\u00c3\u00ac\u00c3\u00ad\u00c3\u00ae\u00c3\u00af", "jkl5", "mno6\u00c3\u00b1\u00c3\u00b6\u00c3\u00b2\u00c3\u00b3\u00c3\u00b4\u00c3\u00b5\u00c3\u00b8", "pqrs7", "tuv8\u00c3\u00bc\u00c3\u00b9\u00c3\u00ba\u00c3\u00bb", "wxyz9\u00c3\u00bd\u00c3\u00bf\u00c3\u00be"};
    private final Thread caretBlinkThread = new Thread(){

        public void run() {
            int sleepTime = 500;
            boolean isVisible = true;
            while (true) {
                try {
                    while (true) {
                        NumPadInputHandler.this.fireCaretVisibilityChanged(isVisible);
                        Thread.sleep(sleepTime);
                        isVisible = !isVisible;
                        sleepTime = 500;
                    }
                }
                catch (InterruptedException e) {
                    sleepTime = 1000;
                    isVisible = false;
                    continue;
                }
                break;
            }
        }
    };
    private int nPreviousKey;
    private int nCharIndex;
    private long nPrevPressTime;

    public NumPadInputHandler(Display display) {
        super(display);
        this.caretBlinkThread.setPriority(1);
        this.caretBlinkThread.start();
    }

    public boolean handleKeyPress(SVGComponent comp, int nKeyCode) {
        if (nKeyCode == -5) {
            return super.handleKeyPress(comp, nKeyCode);
        }
        StringBuffer aText = new StringBuffer(this.getText(comp));
        int nCaret = this.getCaretPosition(comp);
        if (nCaret == -1) {
            return false;
        }
        long nTime = System.currentTimeMillis();
        long nDiff = nTime - this.nPrevPressTime;
        char cChar = '\u0000';
        if (nKeyCode >= 48 && nKeyCode <= 57) {
            String sKeyChars = NUMKEY_MAPPING[nKeyCode - 48];
            if (nKeyCode == this.nPreviousKey && nDiff < 1000L) {
                ++this.nCharIndex;
                if (this.nCharIndex >= sKeyChars.length()) {
                    this.nCharIndex = 0;
                }
                cChar = sKeyChars.charAt(this.nCharIndex);
                aText.setCharAt(nCaret - 1, cChar);
            } else {
                this.resetKeyState();
                cChar = sKeyChars.charAt(0);
                aText.insert(nCaret, cChar);
                ++nCaret;
            }
        } else {
            switch (nKeyCode) {
                case -3: {
                    if (nCaret <= 0) break;
                    this.setCaretPosition(comp, nCaret - 1);
                    return true;
                }
                case -4: {
                    if (nCaret >= aText.length()) break;
                    this.setCaretPosition(comp, nCaret + 1);
                    return true;
                }
                case -8: {
                    if (nCaret <= 0) break;
                    aText.deleteCharAt(--nCaret);
                    cChar = '\u0001';
                    break;
                }
                case 35: {
                    break;
                }
                case 42: {
                    break;
                }
            }
        }
        this.nPreviousKey = nKeyCode;
        this.nPrevPressTime = nTime;
        if (cChar != '\u0000') {
            this.setText(comp, aText.toString());
            this.setCaretPosition(comp, nCaret);
            this.caretBlinkThread.interrupt();
            return true;
        }
        return false;
    }

    protected void setCaretPosition(SVGComponent comp, int position) {
        if (comp instanceof SVGTextField) {
            SVGTextField field = (SVGTextField)comp;
            field.setCaretPosition(position);
        }
    }

    protected void setText(SVGComponent comp, String text) {
        if (comp instanceof SVGTextField) {
            SVGTextField field = (SVGTextField)comp;
            field.setText(text);
        }
    }

    protected int getCaretPosition(SVGComponent comp) {
        if (comp instanceof SVGTextField) {
            SVGTextField field = (SVGTextField)comp;
            return field.getCaretPosition();
        }
        return -1;
    }

    protected String getText(SVGComponent comp) {
        if (comp instanceof SVGTextField) {
            SVGTextField field = (SVGTextField)comp;
            return field.getText();
        }
        return null;
    }

    private void resetKeyState() {
        this.nPreviousKey = 0;
        this.nCharIndex = 0;
        this.nPrevPressTime = 0L;
    }
}

