/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.TopLogging;
import org.netbeans.modules.autoupdate.services.DependencyChecker;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.InstallManager;
import org.netbeans.modules.autoupdate.services.InstallSupportImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleProvider;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.KeyStoreProvider;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.updater.ModuleDeactivator;
import org.netbeans.updater.UpdateTracking;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static final String UPDATE_DIR = "update";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    public static final String NBM_EXTENTSION = ".nbm";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    public static final String ATTR_VISIBLE = "AutoUpdate-Show-In-Client";
    public static final String ATTR_ESSENTIAL = "AutoUpdate-Essential-Module";
    private static final String USER_KS_KEY = "userKS";
    private static final String USER_KS_FILE_NAME = "user.ks";
    private static final String KS_USER_PASSWORD = "open4user";
    private static Lookup.Result<KeyStoreProvider> result;
    private static Logger err;
    private static ModuleManager mgr;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SPEC_VERSION = "specification_version";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_NBM_NAME = "nbm_name";
    private static String productVersion;

    private Utilities() {
    }

    public static Collection<KeyStore> getKeyStore() {
        Collection collection;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(KeyStoreProvider.class));
            result.addLookupListener((LookupListener)new KeyStoreProviderListener());
        }
        if ((collection = result.allInstances()) == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyStore> arrayList = new ArrayList<KeyStore>();
        for (KeyStoreProvider keyStoreProvider : collection) {
            KeyStore keyStore = keyStoreProvider.getKeyStore();
            if (keyStore == null) continue;
            arrayList.add(keyStore);
        }
        return arrayList;
    }

    private static File getInstallLater(File file) {
        File file2 = new File(file.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + "install_later.xml");
        return file2;
    }

    public static void deleteAllDoLater() {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            for (File file2 : Utilities.findDoLater(file)) {
                file2.delete();
            }
        }
    }

    private static Collection<File> findDoLater(File file) {
        if (!file.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>();
        if (Utilities.getInstallLater(file).exists()) {
            hashSet.add(Utilities.getInstallLater(file));
        }
        if (ModuleDeactivator.getDeactivateLater(file).exists()) {
            hashSet.add(ModuleDeactivator.getDeactivateLater(file));
        }
        return hashSet;
    }

    public static void writeInstallLater(Map<UpdateElementImpl, File> map) {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            Utilities.writeInstallLaterToCluster(file, map);
        }
    }

    private static void writeInstallLaterToCluster(File file, Map<UpdateElementImpl, File> map) {
        Document document = XMLUtil.createDocument((String)"installed_modules", null, null, null);
        Element element = document.getDocumentElement();
        if (map.isEmpty()) {
            return;
        }
        boolean bl = true;
        for (UpdateElementImpl updateElementImpl : map.keySet()) {
            File file2 = map.get(updateElementImpl);
            if (!file.equals(file2)) continue;
            Element element2 = document.createElement("module");
            element2.setAttribute("codename", updateElementImpl.getCodeName());
            element2.setAttribute(ATTR_NAME, updateElementImpl.getDisplayName());
            element2.setAttribute(ATTR_SPEC_VERSION, updateElementImpl.getSpecificationVersion().toString());
            element2.setAttribute(ATTR_SIZE, Long.toString(updateElementImpl.getDownloadSize()));
            element2.setAttribute(ATTR_NBM_NAME, InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), true).getName());
            element.appendChild(element2);
            bl = false;
        }
        if (bl) {
            return;
        }
        Utilities.writeXMLDocumentToFile(document, Utilities.getInstallLater(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXMLDocumentToFile(Document document, File file) {
        document.getDocumentElement().normalize();
        file.getParentFile().mkdirs();
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = null;
        try {
            try {
                XMLUtil.write((Document)document, (OutputStream)byteArrayOutputStream, (String)"UTF-8");
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                outputStream = new FileOutputStream(file);
                inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public static void writeDeactivateLater(Collection<File> collection) {
        File file = InstallManager.getUserDir();
        assert (file != null && file.exists()) : "Userdir " + file + " found and exists.";
        Utilities.writeMarkedFilesToFile(collection, ModuleDeactivator.getDeactivateLater(file));
    }

    public static void writeFileMarkedForDelete(Collection<File> collection) {
        Utilities.writeMarkedFilesToFile(collection, ModuleDeactivator.getControlFileForMarkedForDelete(InstallManager.getUserDir()));
    }

    public static void writeFileMarkedForDisable(Collection<File> collection) {
        Utilities.writeMarkedFilesToFile(collection, ModuleDeactivator.getControlFileForMarkedForDisable(InstallManager.getUserDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMarkedFilesToFile(Collection<File> collection, File file) {
        String string = "";
        if (file.exists()) {
            string = string + ModuleDeactivator.readStringFromFile(file);
        }
        for (File object2 : collection) {
            string = string + object2.getAbsolutePath() + UpdateTracking.PATH_SEPARATOR;
        }
        if (string == null || string.length() == 0) {
            return;
        }
        file.getParentFile().mkdirs();
        assert (file.getParentFile().exists() && file.getParentFile().isDirectory()) : "Parent of " + file + " exists and is directory.";
        Object object3 = null;
        OutputStream outputStream = null;
        try {
            FileOutputStream fileOutputStream;
            block12: {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    object3 = new ByteArrayInputStream(string.getBytes());
                    FileUtil.copy((InputStream)object3, (OutputStream)fileOutputStream);
                    if (object3 == null) break block12;
                }
                catch (Throwable iOException) {
                    if (object3 != null) {
                        ((InputStream)object3).close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw iOException;
                }
                ((InputStream)object3).close();
            }
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public static void writeAdditionalInformation(Map<UpdateElementImpl, File> map) {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            Utilities.writeAdditionalInformationToCluster(file, map);
        }
    }

    public static File locateUpdateTracking(ModuleInfo moduleInfo) {
        String string = "update_tracking/" + moduleInfo.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(string, moduleInfo.getCodeNameBase(), false);
    }

    public static String readSourceFromUpdateTracking(ModuleInfo moduleInfo) {
        Node node;
        String string = null;
        File file = Utilities.locateUpdateTracking(moduleInfo);
        if (file != null && (node = Utilities.getModuleConfiguration(file)) != null) {
            Node node2 = node.getAttributes().getNamedItem("origin");
            assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_ORIGIN attribute.";
            if (!"updater".equals(node2.getNodeValue()) && !"installer".equals(node2.getNodeValue())) {
                string = node2.getNodeValue();
            }
        }
        return string;
    }

    public static Date readInstallTimeFromUpdateTracking(ModuleInfo moduleInfo) {
        Node node;
        Date date = null;
        String string = null;
        File file = Utilities.locateUpdateTracking(moduleInfo);
        if (file != null && (node = Utilities.getModuleConfiguration(file)) != null) {
            Node node2 = node.getAttributes().getNamedItem("install_time");
            assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_INSTALL attribute.";
            string = node2.getNodeValue();
        }
        if (string != null) {
            try {
                long l = Long.parseLong(string);
                date = new Date(l);
            }
            catch (NumberFormatException numberFormatException) {
                Utilities.getLogger().log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeUpdateOfUpdaterJar(JarEntry jarEntry, JarFile jarFile, File file) {
        File file2 = new File(file, UPDATE_DIR + UpdateTracking.FILE_SEPARATOR + "new_updater" + UpdateTracking.FILE_SEPARATOR + "updater.jar");
        file2.getParentFile().mkdirs();
        assert (file2.getParentFile().exists() && file2.getParentFile().isDirectory()) : "Parent of " + file2 + " exists and is directory.";
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file2);
                inputStream = jarFile.getInputStream(jarEntry);
                FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.getLogger().log(Level.INFO, fileNotFoundException.getLocalizedMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
    }

    static void cleanUpdateOfUpdaterJar() {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            File file2 = new File(file, UPDATE_DIR + UpdateTracking.FILE_SEPARATOR + "new_updater");
            if (!file2.exists() || !file2.isDirectory()) continue;
            for (File file3 : file2.listFiles()) {
                file3.delete();
            }
            file2.delete();
        }
    }

    static Module toModule(UpdateUnit updateUnit) {
        return Utilities.getModuleInstance(updateUnit.getCodeName(), null);
    }

    public static Module toModule(String string, SpecificationVersion specificationVersion) {
        return Utilities.getModuleInstance(string, specificationVersion);
    }

    public static Module toModule(ModuleInfo moduleInfo) {
        return Utilities.getModuleInstance(moduleInfo.getCodeNameBase(), moduleInfo.getSpecificationVersion());
    }

    public static boolean isFixed(ModuleInfo moduleInfo) {
        Module module = Utilities.toModule(moduleInfo);
        assert (!moduleInfo.isEnabled() || module != null) : "Module found for enabled " + moduleInfo;
        return module == null ? false : module.isFixed();
    }

    public static boolean isValid(ModuleInfo moduleInfo) {
        Module module = Utilities.toModule(moduleInfo);
        assert (!moduleInfo.isEnabled() || module != null) : "Module found for enabled " + moduleInfo;
        return module == null ? false : module.isValid();
    }

    static UpdateUnit toUpdateUnit(Module module) {
        return UpdateManagerImpl.getInstance().getUpdateUnit(module.getCodeNameBase());
    }

    static UpdateUnit toUpdateUnit(String string) {
        return UpdateManagerImpl.getInstance().getUpdateUnit(string);
    }

    private static Set<Dependency> takeDependencies(UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        assert (UpdateManager.TYPE.MODULE == updateElementImpl.getType() || UpdateManager.TYPE.KIT_MODULE == updateElementImpl.getType()) : "Only for UpdateElement for modules.";
        return Utilities.takeModuleInfo(updateElement).getDependencies();
    }

    private static Collection<UpdateElement> findRequiredUpdateElements(Dependency dependency) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>(2);
        switch (dependency.getType()) {
            case 5: 
            case 6: 
            case 7: {
                UpdateManagerImpl updateManagerImpl = UpdateManagerImpl.getInstance();
                if (updateManagerImpl.getInstalledProviders(dependency.getName()).size() > 0) break;
                for (ModuleInfo moduleInfo : updateManagerImpl.getAvailableProviders(dependency.getName())) {
                    UpdateUnit updateUnit = Utilities.toUpdateUnit(moduleInfo.getCodeNameBase());
                    assert (updateUnit != null) : "UpdateUnit found with codeName " + moduleInfo.getCodeNameBase();
                    assert (updateUnit.getAvailableUpdates().size() > 0) : "UpdateUnit " + updateUnit + " has available updates.";
                    hashSet.add(updateUnit.getAvailableUpdates().get(0));
                }
                break;
            }
            case 1: {
                ModuleInfo moduleInfo;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String string = dependency.getName();
                UpdateUnit updateUnit = UpdateManagerImpl.getInstance().getUpdateUnit(string);
                if (updateUnit == null) {
                    return null;
                }
                if (updateUnit.getInstalled() != null) {
                    object4 = updateUnit.getInstalled();
                    object3 = Trampoline.API.impl((UpdateElement)object4);
                    object2 = ((UpdateElementImpl)object3).getModuleInfos();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        moduleInfo = object.next();
                        if (!DependencyChecker.checkDependencyModule(dependency, moduleInfo)) continue;
                        return null;
                    }
                }
                object4 = updateUnit.getAvailableUpdates();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (UpdateElement)object3.next();
                    object = Trampoline.API.impl((UpdateElement)object2);
                    if (object instanceof ModuleUpdateElementImpl) {
                        moduleInfo = ((UpdateElementImpl)object).getModuleInfos().get(0);
                        if (!DependencyChecker.checkDependencyModule(dependency, moduleInfo)) continue;
                        return Collections.singleton(object2);
                    }
                    assert (false) : "Not implemented yet.";
                }
                break;
            }
            case 3: {
                Utilities.getLogger().log(Level.FINE, "Check dependency on Java platform. Dependency: " + dependency);
                break;
            }
            default: {
                Utilities.getLogger().log(Level.FINE, "Uncovered Dependency " + dependency);
            }
        }
        return hashSet;
    }

    private static Set<UpdateElement> findAffectedModules(Set<UpdateElement> set) {
        if (set.isEmpty()) {
            return set;
        }
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>(set);
        Set<UpdateElement> set2 = new HashSet<UpdateElement>(set);
        Set<Object> set3 = Collections.emptySet();
        while (hashSet.addAll(set3 = Utilities.findAffectedModulesImpl(set2))) {
            set2 = set3;
        }
        return hashSet;
    }

    private static Set<UpdateElement> findAffectedModulesImpl(Set<UpdateElement> set) {
        Object object;
        HashSet<Module> hashSet = new HashSet<Module>();
        for (UpdateElement object32 : set) {
            Object object2;
            Module module;
            UpdateElement updateElement = object32.getUpdateUnit().getInstalled();
            if (updateElement == null || !((object = Trampoline.API.impl(updateElement)) instanceof ModuleUpdateElementImpl) || (module = Utilities.toModule((ModuleInfo)(object2 = ((ModuleUpdateElementImpl)object).getModuleInfo()))) == null) continue;
            hashSet.add(module);
        }
        HashSet hashSet2 = new HashSet();
        for (UpdateElement updateElement : set) {
            object = Trampoline.API.impl(updateElement);
            if (!(object instanceof ModuleUpdateElementImpl)) continue;
            hashSet2.add(((ModuleUpdateElementImpl)object).getModuleInfo());
        }
        if (hashSet.isEmpty()) {
            return set;
        }
        HashSet<UpdateElement> hashSet3 = new HashSet<UpdateElement>();
        Collection<ModuleInfo> collection = Utilities.getInstalledModules(hashSet2);
        object = new HashSet<ModuleInfo>(collection);
        object.addAll(hashSet2);
        for (Module module : hashSet) {
            for (Module module2 : Utilities.findDependingModules(module, module.getManager())) {
                Set<Dependency> set2;
                if (module2.getProblems() != null && !module2.getProblems().isEmpty() || (set2 = DependencyChecker.findBrokenDependencies(module2.getDependencies(), (Collection<ModuleInfo>)object)).isEmpty()) continue;
                Utilities.getLogger().log(Level.FINEST, "Module " + module2 + " has broken dependecies " + set2);
                UpdateUnit updateUnit = UpdateManagerImpl.getInstance().getUpdateUnit(module2.getCodeNameBase());
                List<UpdateElement> list = updateUnit.getAvailableUpdates();
                if (list == null || list.isEmpty()) continue;
                UpdateElement updateElement = list.get(0);
                Utilities.getLogger().log(Level.FINEST, "Try to resolve by newone module " + updateElement);
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                if (!(updateElementImpl instanceof ModuleUpdateElementImpl)) continue;
                ModuleInfo moduleInfo = ((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo();
                set2 = DependencyChecker.findBrokenDependencies(moduleInfo.getDependencies(), (Collection<ModuleInfo>)object);
                if (set2.isEmpty()) {
                    Utilities.getLogger().log(Level.FINEST, "Newone module " + updateElement + " passed all dependencies!");
                    hashSet3.add(updateElement);
                    continue;
                }
                Utilities.getLogger().log(Level.FINE, "Newone module " + updateElement + " still don't match all dependencies " + set2);
            }
        }
        if (!hashSet3.isEmpty()) {
            Utilities.getLogger().log(Level.FINE, "Added affected modules " + hashSet3);
            set.addAll(hashSet3);
        }
        return set;
    }

    static Set<UpdateElement> findRequiredModules(Set<Dependency> set, Collection<ModuleInfo> collection) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (Object object : set) {
            Collection<UpdateElement> collection2 = Utilities.findRequiredUpdateElements(object);
            if (collection2 == null || collection2.size() <= 0) continue;
            for (UpdateElement updateElement : collection2) {
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                List<ModuleInfo> list = updateElementImpl.getModuleInfos();
                assert (list != null);
                if (collection.containsAll(list)) continue;
                hashSet.add(updateElement);
                collection.add(Utilities.takeModuleInfo(updateElement));
            }
        }
        for (Object object : new HashSet(hashSet)) {
            hashSet.addAll(Utilities.findRequiredModules(Utilities.takeDependencies((UpdateElement)object), collection));
        }
        return hashSet;
    }

    private static List<ModuleInfo> getInstalledModules() {
        return new ArrayList<ModuleInfo>(InstalledModuleProvider.getInstalledModules().values());
    }

    private static Collection<ModuleInfo> getInstalledModules(Collection<? extends ModuleInfo> collection) {
        HashMap<String, ModuleInfo> hashMap = new HashMap<String, ModuleInfo>(InstalledModuleProvider.getInstalledModules());
        for (ModuleInfo moduleInfo : collection) {
            hashMap.remove(moduleInfo.getCodeNameBase());
        }
        return new ArrayList<ModuleInfo>(hashMap.values());
    }

    public static Set<UpdateElement> findRequiredUpdateElements(UpdateElement updateElement, List<ModuleInfo> list) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        Set<UpdateElement> set = new HashSet<UpdateElement>();
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                Object object;
                Set set2 = ((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo().getDependencies();
                List<ModuleInfo> list2 = Utilities.getInstalledModules();
                list2.addAll(list);
                Set<Dependency> set3 = DependencyChecker.findBrokenDependencies(set2, list2);
                set = Utilities.findRequiredModules(set3, list2);
                set = Utilities.findAffectedModules(set);
                HashSet<Dependency> hashSet = new HashSet<Dependency>(set2);
                for (UpdateElement object22 : set) {
                    object = Trampoline.API.impl(object22);
                    hashSet.addAll(((ModuleUpdateElementImpl)object).getModuleInfo().getDependencies());
                }
                Set<Dependency> set4 = Utilities.takeRecommendsRequiresNeeds(hashSet);
                if (set4.isEmpty()) break;
                Collection<UpdateElement> featureUpdateElementImpl = Utilities.checkUpdateTokenProvider((Collection<Dependency>)set4);
                set.addAll(featureUpdateElementImpl);
                object = new HashSet();
                for (UpdateElement updateElement2 : featureUpdateElementImpl) {
                    UpdateElementImpl updateElementImpl2 = Trampoline.API.impl(updateElement2);
                    object.addAll(((ModuleUpdateElementImpl)updateElementImpl2).getModuleInfo().getDependencies());
                }
                set3 = DependencyChecker.findBrokenDependencies((Set<Dependency>)object, list2);
                set.addAll(Utilities.findRequiredModules(set3, list2));
                set = Utilities.findAffectedModules(set);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : featureUpdateElementImpl.getContainedModuleElements()) {
                    set.addAll(Utilities.findRequiredUpdateElements(moduleUpdateElementImpl.getUpdateElement(), list));
                }
                break;
            }
            default: {
                assert (false) : "Not implement for type " + (Object)((Object)updateElementImpl.getType()) + " of UpdateElement " + updateElementImpl;
                break;
            }
        }
        return set;
    }

    private static Collection<UpdateElement> checkUpdateTokenProvider(Collection<Dependency> collection) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        UpdateManagerImpl updateManagerImpl = UpdateManagerImpl.getInstance();
        for (Dependency dependency : collection) {
            if (!updateManagerImpl.getInstalledProviders(dependency.getName()).isEmpty()) continue;
            for (ModuleInfo moduleInfo : updateManagerImpl.getAvailableProviders(dependency.getName())) {
                UpdateUnit updateUnit = Utilities.toUpdateUnit(moduleInfo.getCodeNameBase());
                assert (updateUnit != null) : "UpdateUnit found with codeName " + moduleInfo.getCodeNameBase();
                assert (updateUnit.getAvailableUpdates().size() > 0) : "UpdateUnit " + updateUnit + " has available updates.";
                hashSet.add(updateUnit.getAvailableUpdates().get(0));
            }
        }
        return hashSet;
    }

    private static Collection<Module> getAffectedModules(UpdateElement updateElement, Collection<String> collection) {
        ModuleInfo moduleInfo;
        Module module;
        UpdateElementImpl updateElementImpl;
        HashSet<Module> hashSet = new HashSet<Module>();
        UpdateElement updateElement2 = updateElement.getUpdateUnit().getInstalled();
        if (updateElement2 != null && (updateElementImpl = Trampoline.API.impl(updateElement2)) instanceof ModuleUpdateElementImpl && (module = Utilities.toModule(moduleInfo = ((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo())) != null) {
            for (Module module2 : Utilities.findDependingModules(module, module.getManager())) {
                if (collection.contains(module2.getCodeNameBase())) continue;
                hashSet.add(module2);
            }
        }
        return hashSet;
    }

    private static Collection<String> getCodeNames(Collection<ModuleInfo> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ModuleInfo moduleInfo : collection) {
            hashSet.add(moduleInfo.getCodeNameBase());
        }
        return hashSet;
    }

    private static Set<Dependency> findBrokenDependencies(UpdateElement updateElement, List<ModuleInfo> list) {
        Object object2;
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        Collection<ModuleInfo> collection = Utilities.getInstalledModules(list);
        HashSet<ModuleInfo> hashSet2 = new HashSet<ModuleInfo>(collection);
        hashSet2.addAll(list);
        for (Object object2 : Utilities.getAffectedModules(updateElement, Utilities.getCodeNames(list))) {
            Set<Dependency> set;
            if (object2.getProblems() != null && !object2.getProblems().isEmpty() || (set = DependencyChecker.findBrokenDependencies(object2.getDependencies(), hashSet2)).isEmpty()) continue;
            Utilities.getLogger().log(Level.FINEST, "Module " + object2 + " has broken dependecies " + set);
            hashSet.addAll(set);
        }
        Set<Dependency> set = Utilities.collectAllDependencies(updateElement);
        object2 = Utilities.findRequiredUpdateElements(updateElement, list);
        hashSet2.addAll(Utilities.getModuleInfos((Collection<UpdateElement>)object2));
        hashSet.addAll(DependencyChecker.findBrokenDependencies(set, hashSet2));
        return hashSet;
    }

    private static Set<Dependency> collectAllDependencies(UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        assert (updateElementImpl != null) : "UpdateElementImpl found for UpdateElement " + updateElement;
        List<Object> list = null;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                list = updateElementImpl.getModuleInfos();
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                list = updateElementImpl.getModuleInfos();
                break;
            }
            case CUSTOM_HANDLED_COMPONENT: {
                list = Collections.emptyList();
                Utilities.getLogger().log(Level.INFO, "CUSTOM_HANDLED_COMPONENT should support UpdateItem<->UpdateItem dependencies.");
                break;
            }
            default: {
                assert (false) : "Unsupported for " + updateElement + "[impl: " + updateElementImpl.getClass() + "]";
                break;
            }
        }
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (ModuleInfo moduleInfo : list) {
            hashSet.addAll(Utilities.filterTypeRecommends(moduleInfo.getDependencies()));
        }
        return hashSet;
    }

    private static Set<Dependency> filterTypeRecommends(Collection<Dependency> collection) {
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (Dependency dependency : collection) {
            if (7 == dependency.getType()) continue;
            hashSet.add(dependency);
        }
        return hashSet;
    }

    private static Set<Dependency> takeRecommendsRequiresNeeds(Collection<Dependency> collection) {
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (Dependency dependency : collection) {
            switch (dependency.getType()) {
                case 5: 
                case 6: 
                case 7: {
                    if ("org.openide.modules.ModuleFormat1".equals(dependency.getName())) break;
                    hashSet.add(dependency);
                }
            }
        }
        return hashSet;
    }

    static Set<String> getBrokenDependencies(UpdateElement updateElement, List<ModuleInfo> list) {
        assert (updateElement != null) : "UpdateElement cannot be null";
        HashSet<String> hashSet = new HashSet<String>();
        for (Dependency dependency : Utilities.findBrokenDependencies(updateElement, list)) {
            hashSet.add(dependency.toString());
        }
        return hashSet;
    }

    static Set<String> getBrokenDependenciesInInstalledModules(UpdateElement updateElement) {
        assert (updateElement != null) : "UpdateElement cannot be null";
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (ModuleInfo object : Utilities.getModuleInfos(Collections.singleton(updateElement))) {
            hashSet.addAll(DependencyChecker.findBrokenDependenciesTransitive(object, InstalledModuleProvider.getInstalledModules().values(), new HashSet<ModuleInfo>()));
        }
        HashSet hashSet2 = new HashSet();
        for (Dependency dependency : hashSet) {
            hashSet2.add(dependency.toString());
        }
        return hashSet2;
    }

    static List<ModuleInfo> getModuleInfos(Collection<UpdateElement> collection) {
        ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>(collection.size());
        for (UpdateElement updateElement : collection) {
            if (updateElement.getUpdateUnit() != null && updateElement.getUpdateUnit().isPending()) continue;
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
            arrayList.addAll(updateElementImpl.getModuleInfos());
        }
        return arrayList;
    }

    private static Module getModuleInstance(String string, SpecificationVersion specificationVersion) {
        if (mgr == null) {
            mgr = Main.getModuleSystem().getManager();
        }
        assert (mgr != null);
        if (mgr == null || specificationVersion == null) {
            return mgr != null ? mgr.get(string) : null;
        }
        Module module = mgr.get(string);
        if (module == null) {
            return null;
        }
        if (module.getSpecificationVersion() == null) {
            return null;
        }
        return module.getSpecificationVersion().compareTo((Object)specificationVersion) >= 0 ? module : null;
    }

    public static boolean isAutomaticallyEnabled(String string) {
        Module module = Utilities.getModuleInstance(string, null);
        return module != null ? module.isAutoload() || module.isEager() || module.isFixed() : false;
    }

    public static ModuleInfo takeModuleInfo(UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        assert (updateElementImpl instanceof ModuleUpdateElementImpl);
        return ((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo();
    }

    public static String getProductVersion() {
        if (productVersion == null) {
            String string = System.getProperty("netbeans.buildnumber");
            productVersion = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)string);
        }
        return productVersion;
    }

    private static Node getModuleConfiguration(File file) {
        Document document = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            InputSource inputSource = new InputSource(bufferedInputStream);
            document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            Utilities.getLogger().log(Level.INFO, "SAXException when reading " + file, sAXException);
            return null;
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, "IOException when reading " + file, iOException);
            return null;
        }
        assert (document.getDocumentElement() != null) : "File " + file + " must contain <module> element.";
        if (document.getDocumentElement() == null) {
            return null;
        }
        return Utilities.getModuleElement(document.getDocumentElement());
    }

    private static Node getModuleElement(Element element) {
        Node node = null;
        assert ("module".equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList nodeList = element.getElementsByTagName("module_version");
        for (int i = 0; i < nodeList.getLength() && (node = Utilities.getModuleLastVersion(nodeList.item(i))) == null; ++i) {
        }
        return node;
    }

    private static Node getModuleLastVersion(Node node) {
        Node node2 = node.getAttributes().getNamedItem("last");
        assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_LAST attribute.";
        if (Boolean.valueOf(node2.getNodeValue()).booleanValue()) {
            return node;
        }
        return null;
    }

    private static File getAdditionalInformation(File file) {
        File file2 = new File(file.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + "additional_information.xml");
        return file2;
    }

    private static void writeAdditionalInformationToCluster(File file, Map<UpdateElementImpl, File> map) {
        if (map.isEmpty()) {
            return;
        }
        Document document = XMLUtil.createDocument((String)"module_additional", null, null, null);
        Element element = document.getDocumentElement();
        boolean bl = true;
        for (UpdateElementImpl updateElementImpl : map.keySet()) {
            File file2 = map.get(updateElementImpl);
            if (!file.equals(file2)) continue;
            Element element2 = document.createElement("module");
            element2.setAttribute(ATTR_NBM_NAME, InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), true).getName());
            element2.setAttribute("source-display-name", updateElementImpl.getSource());
            element.appendChild(element2);
            bl = false;
        }
        if (bl) {
            return;
        }
        Utilities.writeXMLDocumentToFile(document, Utilities.getAdditionalInformation(file));
    }

    public static UpdateItem createUpdateItem(UpdateItemImpl updateItemImpl) {
        assert (Trampoline.SPI != null);
        return Trampoline.SPI.createUpdateItem(updateItemImpl);
    }

    public static UpdateItemImpl getUpdateItemImpl(UpdateItem updateItem) {
        assert (Trampoline.SPI != null);
        return Trampoline.SPI.impl(updateItem);
    }

    public static boolean canDisable(Module module) {
        return module != null && module.isEnabled() && !Utilities.isEssentialModule((ModuleInfo)module) && !module.isAutoload() && !module.isEager();
    }

    public static boolean canEnable(Module module) {
        return module != null && !module.isEnabled() && !module.isAutoload() && !module.isEager();
    }

    public static boolean isElementInstalled(UpdateElement updateElement) {
        assert (updateElement != null) : "Invalid call isElementInstalled with null parameter.";
        if (updateElement == null) {
            return false;
        }
        return updateElement.equals(updateElement.getUpdateUnit().getInstalled());
    }

    public static boolean isKitModule(ModuleInfo moduleInfo) {
        Object object = moduleInfo.getAttribute(ATTR_VISIBLE);
        return object == null || Boolean.parseBoolean(object.toString());
    }

    public static boolean isEssentialModule(ModuleInfo moduleInfo) {
        Object object = moduleInfo.getAttribute(ATTR_ESSENTIAL);
        return Utilities.isFixed(moduleInfo) || object != null && Boolean.parseBoolean(object.toString());
    }

    private static Logger getLogger() {
        if (err == null) {
            err = Logger.getLogger(Utilities.class.getName());
        }
        return err;
    }

    public static Set<Module> findRequiredModules(Module module, ModuleManager moduleManager) {
        return moduleManager.getModuleInterdependencies(module, false, false);
    }

    public static Set<Module> findDependingModules(Module module, ModuleManager moduleManager) {
        return moduleManager.getModuleInterdependencies(module, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.parse(string);
        }
    }

    public static boolean canWriteInCluster(File file) {
        assert (file != null) : "dir cannot be null";
        if (file == null) {
            return false;
        }
        if (file.exists() && file.isDirectory()) {
            File file2 = null;
            File file3 = new File(file, UPDATE_DIR);
            File file4 = new File(file, DOWNLOAD_DIR);
            file2 = file4.exists() ? file4 : (file3.exists() ? file3 : file);
            if (file2.canWrite() && file2.canRead()) {
                boolean bl = Utilities.canWrite(file2);
                Utilities.getLogger().log(Level.FINE, "Can write into " + file2 + "? " + bl);
                return bl;
            }
            Utilities.getLogger().log(Level.FINE, "Can write into " + file2 + "? " + file2.canWrite());
            return file2.canWrite();
        }
        file.mkdirs();
        Utilities.getLogger().log(Level.FINE, "Can write into new cluster " + file + "? " + file.canWrite());
        return file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        if (org.openide.util.Utilities.isWindows()) {
            if (file.isFile()) {
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(file, true);
                    Utilities.getLogger().log(Level.FINE, file + " has write permission");
                }
                catch (IOException iOException) {
                    Utilities.getLogger().log(Level.FINE, file + " has no write permission", iOException);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
                return true;
            }
            try {
                File file2 = File.createTempFile("dummy", null, file);
                file2.delete();
                Utilities.getLogger().log(Level.FINE, file + " has write permission");
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.FINE, file + " has no write permission", iOException);
                return false;
            }
            return true;
        }
        return file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore() {
        String string = Utilities.getPreferences().get(USER_KS_KEY, null);
        if (string == null) {
            return null;
        }
        InputStream inputStream = null;
        KeyStore keyStore = null;
        try {
            File file = new File(Utilities.getCacheDirectory(), string);
            assert (file.exists()) : file + " exists.";
            inputStream = new BufferedInputStream(new FileInputStream(file));
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(inputStream, KS_USER_PASSWORD.toCharArray());
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Utilities.getLogger().log(Level.INFO, noSuchAlgorithmException.getLocalizedMessage(), noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            Utilities.getLogger().log(Level.INFO, certificateException.getLocalizedMessage(), certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeKeyStore(KeyStore keyStore) {
        OutputStream outputStream = null;
        try {
            File file = new File(Utilities.getCacheDirectory(), USER_KS_FILE_NAME);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            keyStore.store(outputStream, KS_USER_PASSWORD.toCharArray());
            Utilities.getPreferences().put(USER_KS_KEY, USER_KS_FILE_NAME);
        }
        catch (KeyStoreException keyStoreException) {
            Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Utilities.getLogger().log(Level.INFO, noSuchAlgorithmException.getLocalizedMessage(), noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            Utilities.getLogger().log(Level.INFO, certificateException.getLocalizedMessage(), certificateException);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    public static void addCertificates(Collection<Certificate> collection) {
        KeyStore keyStore = Utilities.loadKeyStore();
        if (keyStore == null) {
            try {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, KS_USER_PASSWORD.toCharArray());
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                return;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Utilities.getLogger().log(Level.INFO, noSuchAlgorithmException.getLocalizedMessage(), noSuchAlgorithmException);
                return;
            }
            catch (CertificateException certificateException) {
                Utilities.getLogger().log(Level.INFO, certificateException.getLocalizedMessage(), certificateException);
                return;
            }
            catch (KeyStoreException keyStoreException) {
                Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
                return;
            }
        }
        for (Certificate certificate : collection) {
            try {
                if (keyStore.getCertificateAlias(certificate) != null) continue;
                String string = null;
                for (int i = 0; i < 9999 && keyStore.containsAlias(string = "genAlias" + i); ++i) {
                }
                if (string == null) {
                    Utilities.getLogger().log(Level.INFO, "Too many certificates with " + certificate);
                }
                keyStore.setCertificateEntry(string, certificate);
            }
            catch (KeyStoreException keyStoreException) {
                Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
            }
        }
        Utilities.storeKeyStore(keyStore);
    }

    private static File getCacheDirectory() {
        File file = null;
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            file = new File(new File(new File(string, "var"), "cache"), "catalogcache");
        } else {
            File file2 = FileUtil.toFile((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
            file = new File(file2, "catalogcache");
        }
        file.mkdirs();
        return file;
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    static {
        err = null;
        mgr = null;
        productVersion = null;
    }

    private static class KeyStoreProviderListener
    implements LookupListener {
        private KeyStoreProviderListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Utilities.result = null;
        }
    }
}

