/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MultiTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String DEFAULT_NEW_PACKAGE_NAME = NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_DefaultNewPackageName");
    private static final String NEW_CLASS_PREFIX = NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_NewJavaClassPrefix");
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private Project project;
    private String expectedExtension;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private int type;
    private SourceGroup[] groups;
    private boolean ignoreRootCombo;
    private JPanel bottomPanelContainer;
    private JLabel documentNameLabel;
    private JTextField documentNameTextField;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JTextField projectTextField;
    private JComboBox rootComboBox;
    private JSeparator targetSeparator;
    private RequestProcessor.Task updatePackagesTask = null;
    private static final ComboBoxModel WAIT_MODEL = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_PackageName_PleaseWait")});

    public MultiTargetChooserPanelGUI(Project project, SourceGroup[] sourceGroupArray, Component component, int n) {
        Component component2;
        this.type = n;
        this.project = project;
        this.groups = sourceGroupArray;
        this.initComponents();
        if (n == 1) {
            this.packageComboBox.setVisible(false);
            this.packageLabel.setVisible(false);
            Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_PackageName_Label"));
            this.documentNameTextField.getDocument().addDocumentListener(this);
        } else if (n == 2) {
            this.documentNameTextField.setEditable(false);
        } else {
            this.packageComboBox.getEditor().addActionListener(this);
            this.documentNameTextField.getDocument().addDocumentListener(this);
        }
        if (component != null) {
            this.bottomPanelContainer.add(component, "Center");
        }
        if ((component2 = this.packageComboBox.getEditor().getEditorComponent()) instanceof JTextField) {
            ((JTextField)component2).getDocument().addDocumentListener(this);
        } else {
            this.packageComboBox.addActionListener(this);
        }
        this.rootComboBox.setRenderer(new GroupListCellRenderer());
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.rootComboBox.addActionListener(this);
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getBundle(MultiTargetChooserPanelGUI.class).getString("LBL_JavaTargetChooserPanelGUI_Name"));
    }

    public void addNotify() {
        Dimension dimension = this.jPanel2.getPreferredSize();
        Dimension dimension2 = this.bottomPanelContainer.getPreferredSize();
        Dimension dimension3 = this.targetSeparator.getPreferredSize();
        int n = dimension.height + dimension2.height + dimension3.height + 12;
        if (n > MultiTargetChooserPanelGUI.PREF_DIM.height) {
            this.setPreferredSize(new Dimension(MultiTargetChooserPanelGUI.PREF_DIM.width, n));
        }
        super.addNotify();
    }

    public void initValues(FileObject fileObject, FileObject fileObject2) {
        String string;
        DataObject dataObject;
        assert (this.project != null) : "Project must be specified.";
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        assert (fileObject != null);
        String string2 = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            string2 = dataObject.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string2 = fileObject.getName();
        }
        this.putClientProperty("NewFileWizard_Title", string2);
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        dataObject = this.getPreselectedGroup(fileObject2);
        this.ignoreRootCombo = true;
        this.rootComboBox.setSelectedItem(dataObject);
        this.ignoreRootCombo = false;
        Object object = this.getPreselectedPackage((SourceGroup)dataObject, fileObject2, this.packageComboBox.getModel());
        if (this.type == 1) {
            string = object == null || object.toString().length() == 0 ? DEFAULT_NEW_PACKAGE_NAME : object.toString() + "." + DEFAULT_NEW_PACKAGE_NAME;
            this.documentNameTextField.setText(string);
            int n = string.length();
            int n2 = DEFAULT_NEW_PACKAGE_NAME.length();
            this.documentNameTextField.setSelectionEnd(n - 1);
            this.documentNameTextField.setSelectionStart(n - n2);
        } else {
            if (object != null) {
                this.packageComboBox.getEditor().setItem(object);
            }
            if (fileObject != null && this.documentNameTextField.getText().trim().length() == 0) {
                if (this.type == 2) {
                    this.documentNameTextField.setText(fileObject.getName());
                } else {
                    this.documentNameTextField.setText(NEW_CLASS_PREFIX + fileObject.getName());
                    this.documentNameTextField.selectAll();
                }
            }
            this.updatePackages(false);
        }
        string = fileObject == null ? "" : fileObject.getExt();
        this.expectedExtension = string.length() == 0 ? "" : "." + string;
        this.updateText();
    }

    public FileObject getRootFolder() {
        return ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
    }

    public String getPackageFileName() {
        if (this.type == 1) {
            return "";
        }
        String string = this.packageComboBox.getEditor().getItem().toString();
        return string.replace('.', '/');
    }

    String getPackageName() {
        if (this.type == 1) {
            return "";
        }
        return this.packageComboBox.getEditor().getItem().toString();
    }

    public String getTargetName() {
        String string = this.documentNameTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.documentNameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.rootComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.documentNameLabel.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_ClassName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.documentNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/Bundle");
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_projectTextField"));
        this.jLabel1.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_rootComboBox"));
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.packageLabel, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_packageComboBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_JavaTargetChooserPanelGUI"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.rootComboBox == actionEvent.getSource()) {
            if (!this.ignoreRootCombo && this.type != 1) {
                this.updatePackages(true);
            }
            this.updateText();
        } else if (this.packageComboBox == actionEvent.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox.getEditor() == actionEvent.getSource()) {
            this.updateText();
            this.fireChange();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateText();
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    private void updatePackages(final boolean bl) {
        WAIT_MODEL.setSelectedItem(this.packageComboBox.getEditor().getItem());
        this.packageComboBox.setModel(WAIT_MODEL);
        if (this.updatePackagesTask != null) {
            this.updatePackagesTask.cancel();
        }
        this.updatePackagesTask = new RequestProcessor("ComboUpdatePackages").post(new Runnable(){
            private ComboBoxModel model;

            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    this.model = PackageView.createListView((SourceGroup)((SourceGroup)MultiTargetChooserPanelGUI.this.rootComboBox.getSelectedItem()));
                    SwingUtilities.invokeLater(this);
                } else {
                    if (!bl) {
                        this.model.setSelectedItem(MultiTargetChooserPanelGUI.this.packageComboBox.getEditor().getItem());
                    }
                    MultiTargetChooserPanelGUI.this.packageComboBox.setModel(this.model);
                }
            }
        });
    }

    private void updateText() {
    }

    private SourceGroup getPreselectedGroup(FileObject fileObject) {
        for (int i = 0; fileObject != null && i < this.groups.length; ++i) {
            FileObject fileObject2 = this.groups[i].getRootFolder();
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return this.groups[i];
        }
        return this.groups[0];
    }

    private Object getPreselectedPackage(SourceGroup sourceGroup, FileObject fileObject, ListModel listModel) {
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = sourceGroup.getRootFolder();
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (string == null) {
            return null;
        }
        String string2 = string.replace('/', '.');
        return string2;
    }

    private static final class GroupListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            SourceGroup sourceGroup = (SourceGroup)object;
            super.getListCellRendererComponent((JList<?>)jList, sourceGroup.getDisplayName(), n, bl, bl2);
            this.setIcon(sourceGroup.getIcon(false));
            return this;
        }
    }
}

