/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FontFace;
import com.sun.perseus.model.Glyph;
import com.sun.perseus.model.HKern;
import com.sun.perseus.model.ModelNode;
import org.w3c.dom.DOMException;

public class Font
extends ElementNode {
    static final String[] REQUIRED_TRAITS = new String[]{"horiz-adv-x"};
    protected float horizontalOriginX;
    protected float horizontalAdvanceX;
    protected FontFace fontFace;
    protected Glyph missingGlyph;
    protected HKern firstHKern;
    protected HKern lastHKern;

    public Font(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    public String getLocalName() {
        return "font";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Font(doc);
    }

    public void setHorizontalOriginX(float newHorizontalOriginX) {
        if (newHorizontalOriginX == this.horizontalOriginX) {
            return;
        }
        this.modifyingNode();
        this.horizontalOriginX = newHorizontalOriginX;
        this.modifiedNode();
    }

    public float getHorizontalOriginX() {
        return this.horizontalOriginX;
    }

    public void setHorizontalAdvanceX(float newHorizontalAdvanceX) {
        if (newHorizontalAdvanceX == this.horizontalAdvanceX) {
            return;
        }
        this.modifyingNode();
        this.horizontalAdvanceX = newHorizontalAdvanceX;
        this.modifiedNode();
    }

    public float getHorizontalAdvanceX() {
        return this.horizontalAdvanceX;
    }

    public Glyph canDisplay(char[] s, int index) {
        int max = s.length - index;
        int glLength = 0;
        int j = 0;
        Glyph gl = null;
        ModelNode c = this.firstChild;
        while (c != null) {
            if (c instanceof Glyph) {
                gl = (Glyph)c;
                glLength = gl.getLength();
                if (gl.getUnicode() != null && glLength > 0 && index + glLength <= s.length) {
                    for (j = 0; j < glLength && s[index + j] == gl.getCharAt(j); ++j) {
                    }
                    if (j == glLength) {
                        return gl;
                    }
                }
            }
            c = c.nextSibling;
        }
        return null;
    }

    public Glyph getMissingGlyph() {
        return this.missingGlyph;
    }

    public void add(ElementNode node) {
        super.add(node);
        this.addSpecial(node);
    }

    protected void addSpecial(ModelNode node) {
        if (!(node instanceof Glyph)) {
            if (!(node instanceof FontFace)) {
                if (!(node instanceof HKern)) {
                    return;
                }
                this.addHKern((HKern)node);
            } else {
                this.addFontFace((FontFace)node);
            }
        } else {
            Glyph gl = (Glyph)node;
            if (gl.getUnicode() == null) {
                this.addMissingGlyph(gl);
            } else {
                this.addGlyph(gl);
            }
        }
    }

    protected void addFontFace(FontFace newFontFace) {
        if (this.fontFace != null) {
            return;
        }
        this.fontFace = newFontFace;
        this.updateGlyphEmSquare();
    }

    protected void addHKern(HKern hkern) {
        if (this.firstHKern != null) {
            this.lastHKern.nextHKern = hkern;
            this.lastHKern = hkern;
        } else {
            this.firstHKern = hkern;
            this.lastHKern = hkern;
            hkern.nextHKern = null;
        }
    }

    float getHKern(Glyph g1, Glyph g2) {
        if (g2.parent != this) {
            return 0.0f;
        }
        HKern k = this.firstHKern;
        while (!(k == null || k.matchesFirst(g1) && k.matchesSecond(g2))) {
            k = k.nextHKern;
        }
        if (k != null) {
            if (this.fontFace != null) {
                return k.k * this.fontFace.getEmSquareScale();
            }
            return k.k;
        }
        return 0.0f;
    }

    protected void updateGlyphEmSquare() {
        float emSquareScale = 1.0f;
        if (this.fontFace != null) {
            emSquareScale = this.fontFace.getEmSquareScale();
        }
        ElementNode c = this.firstChild;
        while (c != null) {
            if (c instanceof Glyph) {
                ((Glyph)c).setEmSquareScale(emSquareScale);
            }
            c = (ElementNode)c.nextSibling;
        }
    }

    protected void updateGlyphEmSquare(Glyph gl) {
        if (this.fontFace != null) {
            gl.setEmSquareScale(this.fontFace.getEmSquareScale());
        } else {
            gl.setEmSquareScale(1.0f);
        }
    }

    protected void addMissingGlyph(Glyph gl) {
        if (this.missingGlyph == null) {
            this.missingGlyph = gl;
        }
        this.updateGlyphEmSquare(gl);
    }

    protected void addGlyph(Glyph gl) {
        this.updateGlyphEmSquare(gl);
    }

    boolean supportsTrait(String traitName) {
        if ("horiz-origin-x" == traitName || "horiz-adv-x" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String[] getRequiredTraits() {
        return REQUIRED_TRAITS;
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("horiz-adv-x" == name) {
            return Float.toString(this.getHorizontalAdvanceX());
        }
        if ("horiz-origin-x" == name) {
            return Float.toString(this.getHorizontalOriginX());
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("horiz-adv-x" == name) {
            return this.getHorizontalAdvanceX();
        }
        if ("horiz-origin-x" == name) {
            return this.getHorizontalOriginX();
        }
        return super.getFloatTraitImpl(name);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("horiz-adv-x" == name) {
            this.checkWriteLoading(name);
            this.setHorizontalAdvanceX(this.parseFloatTrait(name, value));
        } else if ("horiz-origin-x" == name) {
            this.checkWriteLoading(name);
            this.setHorizontalOriginX(this.parseFloatTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("horiz-adv-x" == name) {
            this.setHorizontalAdvanceX(value);
        } else if ("horiz-origin-x" == name) {
            this.setHorizontalOriginX(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }
}

