/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.Image;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.syntax.spi.JSPColoringData;
import org.netbeans.modules.web.core.syntax.spi.JspContextInfo;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JspUtils {
    public static final String TAG_MIME_TYPE = "text/x-tag";

    public static String getContentLanguage() {
        return "text/html";
    }

    public static String getScriptingLanguage() {
        return "text/x-java";
    }

    public static JSPColoringData getJSPColoringData(Document document, FileObject fileObject) {
        JspContextInfo jspContextInfo;
        JSPColoringData jSPColoringData = null;
        if (document != null && fileObject != null && fileObject.isValid() && (jspContextInfo = JspContextInfo.getContextInfo(fileObject)) != null) {
            jSPColoringData = jspContextInfo.getJSPColoringData(document, fileObject);
        }
        return jSPColoringData;
    }

    public static JspParserAPI.ParseResult getCachedParseResult(Document document, FileObject fileObject, boolean bl, boolean bl2, boolean bl3) {
        JspContextInfo jspContextInfo = JspContextInfo.getContextInfo(fileObject);
        if (jspContextInfo == null) {
            return null;
        }
        return jspContextInfo.getCachedParseResult(document, fileObject, bl, bl2, bl3);
    }

    public static JspParserAPI.ParseResult getCachedParseResult(Document document, FileObject fileObject, boolean bl, boolean bl2) {
        return JspUtils.getCachedParseResult(document, fileObject, bl, bl2, false);
    }

    public static URLClassLoader getModuleClassLoader(Document document, FileObject fileObject) {
        return JspContextInfo.getContextInfo(fileObject).getModuleClassLoader(document, fileObject);
    }

    public static FileObject guessWebModuleRoot(Document document, FileObject fileObject) {
        return JspContextInfo.getContextInfo(fileObject).guessWebModuleRoot(document, fileObject);
    }

    public static FileObject getFileObject(Document document, String string) {
        FileObject fileObject;
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        FileObject fileObject2 = fileObject = dataObject != null ? NbEditorUtilities.getDataObject((Document)document).getPrimaryFile() : null;
        if (fileObject != null) {
            return JspUtils.getFileObject(document, fileObject, string);
        }
        return null;
    }

    public static FileObject getFileObject(Document document, FileObject fileObject, String string) {
        if (string == null) {
            return fileObject;
        }
        string = string.trim();
        FileObject fileObject2 = fileObject;
        if (!fileObject.isFolder()) {
            fileObject2 = fileObject.getParent();
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            fileObject2 = JspUtils.guessWebModuleRoot(document, fileObject);
            if (fileObject2 == null) {
                return null;
            }
            string = string.substring(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (fileObject2 != null && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("..".equals(string2)) {
                fileObject2 = fileObject2.getParent();
                continue;
            }
            if (".".equals(string2)) continue;
            fileObject2 = fileObject2.getFileObject(string2);
        }
        return fileObject2;
    }

    public static Map getTaglibMap(Document document, FileObject fileObject) {
        return JspContextInfo.getContextInfo(fileObject).getTaglibMap(document, fileObject);
    }

    public static Image getIcon(Document document, FileObject fileObject) {
        try {
            return DataObject.find((FileObject)fileObject).getNodeDelegate().getIcon(1);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(JspUtils.class.getName()).log(Level.INFO, "Cannot find icon for " + fileObject.getNameExt(), dataObjectNotFoundException);
            return null;
        }
    }

    public static String resolveRelativeURL(String string, String string2) {
        String string3;
        if (string2.startsWith("/")) {
            string3 = "/";
            string2 = string2.substring(1);
        } else {
            if (string == null || !string.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int n = (string = JspUtils.resolveRelativeURL(null, string)).lastIndexOf(47);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            string3 = string.substring(0, n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("/")) {
                if (string3.endsWith("/")) continue;
                string3 = string3 + "/";
                continue;
            }
            if (string4.equals("") || string4.equals(".")) continue;
            if (string4.equals("..")) {
                String string5 = string3.substring(0, string3.length() - 1);
                int n = string5.lastIndexOf("/");
                if (n == -1) continue;
                string3 = string5.substring(0, n + 1);
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    public static String mapToString(Map map, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object k : map.keySet()) {
            stringBuffer.append(string).append(k).append(" -> ").append(map.get(k)).append("\n");
        }
        return stringBuffer.toString();
    }

    public static boolean isInSubTree(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2 == fileObject) {
            return true;
        }
        return FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2);
    }

    public static String findRelativePath(FileObject fileObject, FileObject fileObject2) {
        String string = fileObject.getPath();
        String string2 = fileObject2.getPath();
        if (!JspUtils.isInSubTree(fileObject, fileObject2)) {
            throw new IllegalArgumentException("" + fileObject + " / " + fileObject2);
        }
        String string3 = string2.substring(string.length());
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    public static String findRelativeContextPath(FileObject fileObject, FileObject fileObject2) {
        String string = "/" + JspUtils.findRelativePath(fileObject, fileObject2);
        return fileObject2.isFolder() ? string + "/" : string;
    }

    public static FileObject findRelativeFileObject(FileObject fileObject, String string) {
        FileObject fileObject2;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        for (fileObject2 = fileObject; fileObject2 != null && stringTokenizer.hasMoreTokens(); fileObject2 = fileObject2.getFileObject(stringTokenizer.nextToken())) {
        }
        return fileObject2;
    }
}

