/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.formatting;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.html.HTMLFormatter;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.deprecated.JspMultiSyntax;
import org.netbeans.modules.web.core.syntax.deprecated.JspTagTokenContext;
import org.netbeans.modules.web.core.syntax.formatting.JspJavaFormatter;

public class JspFormatter
extends HTMLFormatter {
    private JavaFormatter jFormatter = new JspJavaFormatter(JavaKit.class);
    private static final Logger LOGGER = Logger.getLogger(JspFormatter.class.getName());

    public JspFormatter(Class clazz) {
        super(clazz);
    }

    public Writer reformat(BaseDocument baseDocument, int n, int n2, boolean bl) throws BadLocationException {
        super.reformat(baseDocument, n, n2, bl);
        LinkedList<ScriptletBlock> linkedList = new LinkedList<ScriptletBlock>();
        JspSyntaxSupport jspSyntaxSupport = JspSyntaxSupport.get((Document)baseDocument);
        TokenItem tokenItem = jspSyntaxSupport.getTokenChain(n, n + 1);
        if (tokenItem == null) {
            return null;
        }
        TokenItem tokenItem2 = null;
        int n3 = -1;
        int n4 = -1;
        while (tokenItem.getOffset() < n2) {
            if (tokenItem.getTokenContextPath().contains(JavaTokenContext.contextPath)) {
                if (tokenItem.getTokenID() != JavaTokenContext.WHITESPACE) {
                    if (n3 == -1) {
                        n3 = tokenItem.getOffset();
                    }
                    tokenItem2 = tokenItem;
                }
            } else if (n3 != -1) {
                n4 = tokenItem2.getOffset() + tokenItem2.getImage().length();
                linkedList.add(new ScriptletBlock(baseDocument, n3, n4));
                n3 = -1;
            }
            if ((tokenItem = tokenItem.getNext()) != null) continue;
        }
        for (ScriptletBlock scriptletBlock : linkedList) {
            try {
                this.extFormatterReformat(baseDocument, scriptletBlock.getStart(), Math.min(scriptletBlock.getEnd(), n2), bl);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
        }
        return null;
    }

    protected void enterPressed(JTextComponent jTextComponent, int n) throws BadLocationException {
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        JspSyntaxSupport jspSyntaxSupport = new JspSyntaxSupport(baseDocument);
        TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
        if (tokenItem.getTokenContextPath().contains(JavaTokenContext.contextPath)) {
            try {
                this.extFormatterReformat(baseDocument, n, n + 1, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            super.enterPressed(jTextComponent, n);
        }
    }

    protected boolean isClosingTag(TokenItem tokenItem) {
        return tokenItem != null && this.isJSPTag(tokenItem) && tokenItem.getPrevious().getImage().equals("</") || super.isClosingTag(tokenItem);
    }

    protected boolean isOpeningTag(TokenItem tokenItem) {
        return tokenItem != null && this.isJSPTag(tokenItem) && tokenItem.getPrevious().getImage().equals("<") || super.isOpeningTag(tokenItem);
    }

    protected TokenItem getTagTokenEndingAtPosition(BaseDocument baseDocument, int n) throws BadLocationException {
        JspSyntaxSupport jspSyntaxSupport;
        TokenItem tokenItem;
        TokenItem tokenItem2 = super.getTagTokenEndingAtPosition(baseDocument, n);
        if (tokenItem2 != null) {
            return tokenItem2;
        }
        if (n >= 0 && (tokenItem = (jspSyntaxSupport = JspSyntaxSupport.get((Document)baseDocument)).getTokenChain(n, n + 1)).getTokenID() == JspTagTokenContext.SYMBOL && tokenItem.getImage().equals(">")) {
            while ((tokenItem = tokenItem.getPrevious()) != null && tokenItem.getTokenID() != JspTagTokenContext.TAG) {
            }
            return tokenItem;
        }
        return null;
    }

    protected int getTagEndOffset(TokenItem tokenItem) {
        TokenItem tokenItem2;
        if (!this.isJSPTag(tokenItem)) {
            return super.getTagEndOffset(tokenItem);
        }
        for (tokenItem2 = tokenItem.getNext(); tokenItem2 != null && (tokenItem2.getTokenID() != JspTagTokenContext.SYMBOL || !">".equals(tokenItem2.getImage()) && !"/>".equals(tokenItem2.getImage())); tokenItem2 = tokenItem2.getNext()) {
        }
        return tokenItem2 == null ? -1 : tokenItem2.getOffset();
    }

    protected int getOpeningSymbolOffset(TokenItem tokenItem) {
        if (!this.isJSPTag(tokenItem)) {
            return super.getOpeningSymbolOffset(tokenItem);
        }
        TokenItem tokenItem2 = tokenItem;
        while ((tokenItem2 = tokenItem2.getPrevious()) != null && tokenItem2.getTokenID() != JspTagTokenContext.SYMBOL) {
        }
        if (tokenItem2 != null) {
            return tokenItem2.getOffset();
        }
        return -1;
    }

    private boolean isJSPTag(TokenItem tokenItem) {
        return tokenItem.getTokenID() == JspTagTokenContext.TAG;
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JspMultiSyntax;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new SwitchLayer());
    }

    protected boolean isUnformattableToken(TokenItem tokenItem) {
        if (tokenItem.getTokenID() == JspTagTokenContext.COMMENT || tokenItem.getTokenID() == JspTagTokenContext.EOL) {
            return true;
        }
        return super.isUnformattableToken(tokenItem);
    }

    private class ScriptletBlock {
        private Position posStart;
        private Position posEnd;

        public ScriptletBlock(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
            this.posStart = baseDocument.createPosition(n);
            this.posEnd = baseDocument.createPosition(n2);
        }

        public int getStart() {
            return this.posStart.getOffset();
        }

        public int getEnd() {
            return this.posEnd.getOffset();
        }
    }

    private class SwitchLayer
    extends AbstractFormatLayer {
        public SwitchLayer() {
            super("Switch-line");
        }

        public void format(FormatWriter formatWriter) {
            int n = formatWriter.getOffset();
            JspSyntaxSupport jspSyntaxSupport = new JspSyntaxSupport((BaseDocument)formatWriter.getDocument());
            try {
                TokenItem tokenItem = jspSyntaxSupport.getItemAtOrBefore(n);
                if (tokenItem == null) {
                    return;
                }
                TokenContextPath tokenContextPath = tokenItem.getTokenContextPath();
                if (tokenContextPath.contains(JavaTokenContext.contextPath) && JspUtils.getScriptingLanguage().equals("text/x-java")) {
                    JspFormatter.this.jFormatter.format(formatWriter);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace(System.err);
            }
        }
    }
}

