/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.gsf.embedding;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.parser.CssParserAccess;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.html.editor.gsf.embedding.CssModel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssJspModel
extends CssModel {
    private static final Logger LOGGER = Logger.getLogger(CssJspModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final String PREFIX = "GENERATED_";
    private static final String POSTFIX = ";";
    private static final String EL = "GENERATED_EXPRESSION_LANGUAGE;";
    private static final String JAVA = "GENERATED_GENERATED_JAVA_CODE;";
    private static final String FIXED_SELECTOR = "GENERATED_FIXED_SELECTOR";
    private CssParserAccess.CssParserResult cachedParserResult = null;

    public static CssJspModel get(Document document) {
        CssJspModel cssJspModel = (CssJspModel)((Object)document.getProperty(CssJspModel.class));
        if (cssJspModel == null) {
            cssJspModel = new CssJspModel(document);
            document.putProperty(CssJspModel.class, (Object)cssJspModel);
        }
        return cssJspModel;
    }

    private CssJspModel(Document document) {
        super(document);
    }

    public CssParserAccess.CssParserResult getCachedParserResult() {
        if (!this.documentDirty) {
            return this.cachedParserResult;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCode() {
        if (this.documentDirty) {
            this.cachedParserResult = null;
            long l = System.currentTimeMillis();
            this.documentDirty = false;
            this.codeBlocks.clear();
            StringBuilder stringBuilder = new StringBuilder();
            BaseDocument baseDocument = (BaseDocument)this.doc;
            try {
                baseDocument.readLock();
                ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
                this.extractCssFromJSP(this.doc, stringBuilder, arrayList);
                if (arrayList.isEmpty()) {
                    this.code = stringBuilder.toString();
                    LOGGER.log(Level.FINE, "NO REPLACED TEMPLATING!");
                    String string = this.code;
                    return string;
                }
                Boolean bl = (Boolean)this.doc.getProperty("sanitize_source");
                if (bl != null && !bl.booleanValue()) {
                    this.code = stringBuilder.toString();
                    LOGGER.log(Level.FINE, "SANITIZING DISABLED!");
                    LOGGER.log(Level.FINE, this.dumpCode());
                    String string = this.code;
                    return string;
                }
                if (LOG) {
                    this.code = stringBuilder.toString();
                    LOGGER.log(Level.FINE, "BEFORE SANITIZING");
                    LOGGER.log(Level.FINE, this.dumpCode());
                }
                long l2 = System.currentTimeMillis();
                this.sanitizeCode(stringBuilder, arrayList);
                this.code = stringBuilder.toString();
                if (LOG) {
                    LOGGER.log(Level.FINE, "AFTER SANITIZING");
                    LOGGER.log(Level.FINE, this.dumpCode());
                }
                if (LOG) {
                    LOGGER.log(Level.FINE, "CSS source generation took " + (l2 - l) + " ms.");
                    LOGGER.log(Level.FINE, "CSS source validation took " + (System.currentTimeMillis() - l2) + " ms.");
                }
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        return this.code;
    }

    private void sanitizeCode(final StringBuilder stringBuilder, final List<OffsetRange> list) {
        DataObject dataObject;
        int n;
        final boolean[] blArray = new boolean[1];
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                if (simpleNode.kind() == 38 || simpleNode.kind() == 39) {
                    SimpleNode simpleNode2;
                    SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetParent();
                    LOGGER.log(Level.FINE, "Tree Error  on " + simpleNode + "; parent: " + simpleNode3);
                    if (simpleNode3.kind() == 28) {
                        boolean bl = false;
                        SimpleNode simpleNode4 = SimpleNodeUtil.getSibling((SimpleNode)simpleNode3, (boolean)true);
                        if (simpleNode4 != null && simpleNode4.kind() == 28) {
                            bl = CssJspModel.this.containsGeneratedCode(simpleNode4, stringBuilder);
                        }
                        if (CssJspModel.this.clearNode(simpleNode3, stringBuilder, 0, 0, list, bl, true)) {
                            blArray[0] = true;
                        }
                    }
                    if (simpleNode3.kind() == 18 && (simpleNode2 = SimpleNodeUtil.getSibling((SimpleNode)simpleNode, (boolean)true)).kind() == 35) {
                        int n;
                        int n2;
                        if ((simpleNode2 = SimpleNodeUtil.getSibling((SimpleNode)simpleNode2, (boolean)true)).kind() == 28) {
                            boolean bl = CssJspModel.this.clearNode(simpleNode2, stringBuilder, 0, 0, list, false, false);
                            if (bl) {
                                CssJspModel.this.clearNode(simpleNode, stringBuilder, 0, -1, list, true, false);
                                blArray[0] = true;
                            }
                        } else if (simpleNode2.kind() == 19 && (n2 = stringBuilder.indexOf("{", n = simpleNode2.startOffset())) > 0) {
                            CssJspModel.this.clearAndWrite(stringBuilder, n, n2, CssJspModel.FIXED_SELECTOR);
                            blArray[0] = true;
                        }
                    }
                }
            }
        };
        long l = System.currentTimeMillis();
        for (n = 0; n < 4; ++n) {
            blArray[0] = false;
            CssParserAccess cssParserAccess = CssParserAccess.getDefault();
            CssParserAccess.CssParserResult cssParserResult = cssParserAccess.parse((Reader)new StringReader(stringBuilder.toString()));
            dataObject = cssParserResult.root();
            if (dataObject == null) {
                return;
            }
            if (LOG) {
                LOGGER.fine("> SANITIZING LEVEL #" + n + " >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                LOGGER.fine(stringBuilder.toString());
                LOGGER.fine("------------------------");
                LOGGER.fine(dataObject.dump(""));
                LOGGER.fine("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            }
            dataObject.visitChildren(nodeVisitor);
            if (blArray[0]) continue;
            this.cachedParserResult = cssParserResult;
            break;
        }
        if (blArray[0]) {
            LOGGER.warning("CSS source sanitization didn't success even after four passes!");
        }
        long l2 = System.currentTimeMillis();
        dataObject = (DataObject)this.doc.getProperty("stream");
        FileObject fileObject = null;
        if (dataObject != null) {
            fileObject = dataObject.getPrimaryFile();
        }
        Logger.getLogger("TIMER").log(Level.FINE, "CSS Sanitizing [" + n + "]", new Object[]{fileObject, l2 - l});
    }

    private boolean clearNode(SimpleNode simpleNode, StringBuilder stringBuilder, int n, int n2, List<OffsetRange> list, boolean bl, boolean bl2) {
        int n3;
        int n4 = simpleNode.startOffset();
        if (n4 >= (n3 = simpleNode.endOffset())) {
            System.err.println("clearNode from >= to! node: " + simpleNode);
            return false;
        }
        if (bl2) {
            char c;
            int n5;
            int n6;
            for (n6 = n4; n6 >= 0 && (n5 = (int)stringBuilder.charAt(n6)) != 10; --n6) {
            }
            for (n5 = n3; n5 < stringBuilder.length() && (c = stringBuilder.charAt(n5)) != '\n'; ++n5) {
            }
            n4 = n6;
            n3 = n5;
        }
        if ((n4 += n) >= (n3 += n2)) {
            System.err.println("clearNode from+startDelta >= to+endDelta! node: " + simpleNode);
            return false;
        }
        if (bl || this.containsGeneratedCode(simpleNode, stringBuilder)) {
            LOGGER.log(Level.FINE, "CLEARING NODE " + simpleNode + " [" + stringBuilder.substring(n4, n3) + "]");
            this.clear(stringBuilder, n4, n3);
            return true;
        }
        return false;
    }

    private boolean containsGeneratedCode(SimpleNode simpleNode, StringBuilder stringBuilder) {
        int n = simpleNode.startOffset();
        int n2 = simpleNode.endOffset();
        return stringBuilder.substring(n, n2).contains(PREFIX);
    }

    private void clear(StringBuilder stringBuilder, int n, int n2) {
        assert (n < n2);
        for (int i = n; i < n2; ++i) {
            stringBuilder.setCharAt(i, ' ');
        }
    }

    private void clearAndWrite(StringBuilder stringBuilder, int n, int n2, String string) {
        LOGGER.log(Level.FINE, "CLEARING&&REPLACING [" + stringBuilder.substring(n, n2) + "]: " + string);
        this.clear(stringBuilder, n, n2);
        stringBuilder.replace(n, n + string.length(), string);
    }

    private void extractCssFromJSP(Document document, StringBuilder stringBuilder, List<OffsetRange> list) {
        HashMap hashMap = new HashMap(6);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.moveStart();
        block0: while (tokenSequence.moveNext()) {
            int n;
            int n2;
            Object object;
            Token token = tokenSequence.token();
            if (token.id() == JspTokenId.TEXT) {
                object = tokenSequence.embedded();
                object.moveStart();
                this.extractCssFromHTML((TokenSequence)object, stringBuilder, hashMap);
                continue;
            }
            if (hashMap.get("in_style") == null && hashMap.get("in_inlined_style") == null) continue;
            if (token.id() == JspTokenId.EL || token.id() == JspTokenId.SCRIPTLET) {
                int n3 = tokenSequence.offset();
                n2 = tokenSequence.offset() + token.length();
                int n4 = stringBuilder.length();
                stringBuilder.append(token.id() == JspTokenId.EL ? EL : JAVA);
                n = stringBuilder.length();
                list.add(new OffsetRange(n4, n));
                CssModel.CodeBlockData codeBlockData = new CssModel.CodeBlockData((CssModel)this, n3, n2, n4, n);
                this.codeBlocks.add(codeBlockData);
                continue;
            }
            if (token.id() != JspTokenId.TAG) continue;
            object = ((Object)token.text()).toString();
            n2 = tokenSequence.offset() - 1;
            StringBuilder stringBuilder2 = new StringBuilder();
            while (tokenSequence.moveNext() && ((token = tokenSequence.token()).id() != JspTokenId.SYMBOL || !"/>".equals(((Object)token.text()).toString()))) {
                if (token.id() == JspTokenId.TEXT) {
                    stringBuilder2.append(token.text());
                    continue;
                }
                if (token.id() != JspTokenId.ENDTAG || !((Object)token.text()).toString().equals(object)) continue;
                tokenSequence.moveNext();
                n = tokenSequence.offset() + tokenSequence.token().length();
                int n5 = stringBuilder.length();
                stringBuilder.append((CharSequence)stringBuilder2);
                int n6 = stringBuilder.length();
                CssModel.CodeBlockData codeBlockData = new CssModel.CodeBlockData((CssModel)this, n2, n, n5, n6);
                this.codeBlocks.add(codeBlockData);
                continue block0;
            }
        }
    }
}

