/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.web.core.syntax.JspParserErrorAnnotation;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.Line;

public class ErrorAnnotation {
    public static final int JSP_ERROR = 1;
    private FileObject jspFo;
    private ArrayList annotations;

    public ErrorAnnotation(FileObject fileObject) {
        this.jspFo = fileObject;
        this.annotations = new ArrayList();
    }

    public void annotate(ErrorInfo[] errorInfoArray) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)this.jspFo);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return;
        }
        if (editorCookie.getOpenedPanes() == null) {
            return;
        }
        JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
        if (jEditorPane != null) {
            if (errorInfoArray != null && errorInfoArray.length > 0) {
                Utilities.setStatusBoldText((JTextComponent)jEditorPane, (String)(" " + errorInfoArray[0].getDescription()));
            } else {
                Utilities.clearStatusText((JTextComponent)jEditorPane);
            }
        }
        Collection collection = this.getAnnotations(errorInfoArray, styledDocument);
        ArrayList arrayList = new ArrayList(collection);
        arrayList.removeAll(this.annotations);
        ArrayList arrayList2 = new ArrayList(this.annotations);
        arrayList2.retainAll(collection);
        ArrayList arrayList3 = this.annotations;
        arrayList3.removeAll(collection);
        ErrorAnnotation.detachAnnotations(arrayList3);
        if (!arrayList.isEmpty()) {
            final ArrayList arrayList4 = arrayList;
            final DataObject dataObject2 = dataObject;
            Runnable runnable = new Runnable(){

                public void run() {
                    LineCookie lineCookie = (LineCookie)dataObject2.getCookie(LineCookie.class);
                    Line.Set set = lineCookie.getLineSet();
                    for (LineSetAnnotation lineSetAnnotation : arrayList4) {
                        lineSetAnnotation.attachToLineSet(set);
                    }
                }
            };
            if (styledDocument != null) {
                styledDocument.render(runnable);
            } else {
                runnable.run();
            }
        }
        this.annotations = arrayList2;
        this.annotations.addAll(arrayList);
    }

    private Collection getAnnotations(ErrorInfo[] errorInfoArray, StyledDocument styledDocument) {
        HashMap<Integer, JspParserErrorAnnotation> hashMap = new HashMap<Integer, JspParserErrorAnnotation>(errorInfoArray.length);
        for (int i = 0; i < errorInfoArray.length; ++i) {
            JspParserErrorAnnotation jspParserErrorAnnotation;
            ErrorInfo errorInfo = errorInfoArray[i];
            int n = errorInfo.getLine();
            if (n < 0) continue;
            int n2 = errorInfo.getColumn();
            String string = errorInfo.getDescription();
            switch (errorInfo.getType()) {
                case 1: {
                    jspParserErrorAnnotation = new JspParserErrorAnnotation(n, n2, string, (NbEditorDocument)styledDocument);
                    break;
                }
                default: {
                    jspParserErrorAnnotation = new JspParserErrorAnnotation(n, n2, string, (NbEditorDocument)styledDocument);
                }
            }
            Integer n3 = new Integer(n);
            hashMap.put(n3, jspParserErrorAnnotation);
        }
        return hashMap.values();
    }

    private static void detachAnnotations(Collection collection) {
        for (Annotation annotation : collection) {
            if (annotation.getAttachedAnnotatable() == null) continue;
            annotation.detach();
        }
    }

    public static class ErrorInfo {
        private String description;
        private int line;
        private int column;
        private int type;

        public ErrorInfo(String string, int n, int n2, int n3) {
            this.description = string;
            this.line = n;
            this.column = n2;
            this.type = n3;
        }

        public String getDescription() {
            return this.description;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public int getType() {
            return this.type;
        }
    }

    public static abstract class LineSetAnnotation
    extends Annotation {
        public abstract void attachToLineSet(Line.Set var1);
    }
}

