/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.util.NbBundle;

public final class Convertors {
    public static String documentToString(final Document document) {
        if (document == null) {
            throw new NullPointerException();
        }
        final String[] stringArray = new String[1];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    stringArray[0] = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        };
        document.render(runnable);
        return stringArray[0];
    }

    public static String readerToString(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer(1024);
        try {
            int n = bufferedReader.read();
            while (n >= 0) {
                stringBuffer.append((char)n);
                n = bufferedReader.read();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static final String iana2java(String string) {
        String string2 = (String)EncodingUtil.getIANA2JavaMap().get(string.toUpperCase());
        return string2 == null ? string : string2;
    }

    public static final String java2iana(String string) {
        String string2 = (String)EncodingUtil.getJava2IANAMap().get(string);
        return string2 == null ? string : string2;
    }

    static class EncodingUtil {
        protected static final Map encodingIANA2JavaMap = new TreeMap();
        protected static final Map encodingIANADescriptionMap = new TreeMap();
        protected static final Map encodingIANAAliasesMap = new TreeMap();
        protected static final Map encodingJava2IANAMap = new TreeMap();

        EncodingUtil() {
        }

        private static String getString(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return NbBundle.getMessage(Convertors.class, (String)string);
        }

        public static Map getIANA2JavaMap() {
            return encodingIANA2JavaMap;
        }

        public static Map getJava2IANAMap() {
            return encodingJava2IANAMap;
        }

        static {
            encodingIANA2JavaMap.put("BIG5", "Big5");
            encodingIANADescriptionMap.put("BIG5", EncodingUtil.getString("NAME_BIG5"));
            encodingIANAAliasesMap.put("BIG5", "BIG5");
            encodingIANA2JavaMap.put("IBM037", "CP037");
            encodingIANADescriptionMap.put("IBM037", EncodingUtil.getString("NAME_IBM037"));
            encodingIANAAliasesMap.put("IBM037", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-US", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-CA", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-NL", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-WT", "IBM037");
            encodingIANA2JavaMap.put("IBM277", "CP277");
            encodingIANADescriptionMap.put("IBM277", EncodingUtil.getString("NAME_IBM277"));
            encodingIANAAliasesMap.put("IBM277", "IBM277");
            encodingIANAAliasesMap.put("EBCDIC-CP-DK", "IBM277");
            encodingIANAAliasesMap.put("EBCDIC-CP-NO", "IBM277");
            encodingIANA2JavaMap.put("IBM278", "CP278");
            encodingIANADescriptionMap.put("IBM278", EncodingUtil.getString("NAME_IBM277"));
            encodingIANAAliasesMap.put("IBM278", "IBM278");
            encodingIANAAliasesMap.put("EBCDIC-CP-FI", "IBM278");
            encodingIANAAliasesMap.put("EBCDIC-CP-SE", "IBM278");
            encodingIANA2JavaMap.put("IBM280", "CP280");
            encodingIANADescriptionMap.put("IBM280", EncodingUtil.getString("NAME_IBM280"));
            encodingIANAAliasesMap.put("IBM280", "IBM280");
            encodingIANAAliasesMap.put("EBCDIC-CP-IT", "IBM280");
            encodingIANA2JavaMap.put("IBM284", "CP284");
            encodingIANADescriptionMap.put("IBM284", EncodingUtil.getString("NAME_IBM284"));
            encodingIANAAliasesMap.put("IBM284", "IBM284");
            encodingIANAAliasesMap.put("EBCDIC-CP-ES", "IBM284");
            encodingIANA2JavaMap.put("IBM285", "CP285");
            encodingIANADescriptionMap.put("IBM285", EncodingUtil.getString("NAME_IBM285"));
            encodingIANAAliasesMap.put("IBM285", "IBM285");
            encodingIANAAliasesMap.put("EBCDIC-CP-GB", "IBM285");
            encodingIANA2JavaMap.put("IBM297", "CP297");
            encodingIANADescriptionMap.put("IBM297", EncodingUtil.getString("NAME_IBM297"));
            encodingIANAAliasesMap.put("IBM297", "IBM297");
            encodingIANAAliasesMap.put("EBCDIC-CP-FR", "IBM297");
            encodingIANA2JavaMap.put("IBM424", "CP424");
            encodingIANADescriptionMap.put("IBM424", EncodingUtil.getString("NAME_IBM424"));
            encodingIANAAliasesMap.put("IBM424", "IBM424");
            encodingIANAAliasesMap.put("EBCDIC-CP-HE", "IBM424");
            encodingIANA2JavaMap.put("IBM500", "CP500");
            encodingIANADescriptionMap.put("IBM500", EncodingUtil.getString("NAME_IBM500"));
            encodingIANAAliasesMap.put("IBM500", "IBM500");
            encodingIANAAliasesMap.put("EBCDIC-CP-CH", "IBM500");
            encodingIANAAliasesMap.put("EBCDIC-CP-BE", "IBM500");
            encodingIANA2JavaMap.put("IBM870", "CP870");
            encodingIANADescriptionMap.put("IBM870", EncodingUtil.getString("NAME_IBM870"));
            encodingIANAAliasesMap.put("IBM870", "IBM870");
            encodingIANAAliasesMap.put("EBCDIC-CP-ROECE", "IBM870");
            encodingIANAAliasesMap.put("EBCDIC-CP-YU", "IBM870");
            encodingIANA2JavaMap.put("IBM871", "CP871");
            encodingIANADescriptionMap.put("IBM871", EncodingUtil.getString("NAME_IBM871"));
            encodingIANAAliasesMap.put("IBM871", "IBM871");
            encodingIANAAliasesMap.put("EBCDIC-CP-IS", "IBM871");
            encodingIANA2JavaMap.put("IBM918", "CP918");
            encodingIANADescriptionMap.put("IBM918", EncodingUtil.getString("NAME_IBM918"));
            encodingIANAAliasesMap.put("IBM918", "IBM918");
            encodingIANAAliasesMap.put("EBCDIC-CP-AR2", "IBM918");
            encodingIANA2JavaMap.put("EUC-JP", "EUCJIS");
            encodingIANADescriptionMap.put("EUC-JP", EncodingUtil.getString("NAME_EUC-JP"));
            encodingIANAAliasesMap.put("EUC-JP", "EUC-JP");
            encodingIANA2JavaMap.put("EUC-KR", "KSC5601");
            encodingIANADescriptionMap.put("EUC-KR", EncodingUtil.getString("NAME_EUC-KR"));
            encodingIANAAliasesMap.put("EUC-KR", "EUC-KR");
            encodingIANA2JavaMap.put("GB2312", "GB2312");
            encodingIANADescriptionMap.put("GB2312", EncodingUtil.getString("NAME_GB2312"));
            encodingIANAAliasesMap.put("GB2312", "GB2312");
            encodingIANA2JavaMap.put("ISO-2022-JP", "JIS");
            encodingIANADescriptionMap.put("ISO-2022-JP", EncodingUtil.getString("NAME_ISO-2022-JP"));
            encodingIANAAliasesMap.put("ISO-2022-JP", "ISO-2022-JP");
            encodingIANA2JavaMap.put("ISO-2022-KR", "ISO2022KR");
            encodingIANADescriptionMap.put("ISO-2022-KR", EncodingUtil.getString("NAME_ISO-2022-KR"));
            encodingIANAAliasesMap.put("ISO-2022-KR", "ISO-2022-KR");
            encodingIANA2JavaMap.put("ISO-8859-1", "8859_1");
            encodingIANADescriptionMap.put("ISO-8859-1", EncodingUtil.getString("NAME_ISO-8859-1"));
            encodingIANAAliasesMap.put("ISO-8859-1", "ISO-8859-1");
            encodingIANAAliasesMap.put("LATIN1", "ISO-8859-1");
            encodingIANAAliasesMap.put("L1", "ISO-8859-1");
            encodingIANAAliasesMap.put("IBM819", "ISO-8859-1");
            encodingIANAAliasesMap.put("CP819", "ISO-8859-1");
            encodingIANA2JavaMap.put("ISO-8859-2", "8859_2");
            encodingIANADescriptionMap.put("ISO-8859-2", EncodingUtil.getString("NAME_ISO-8859-2"));
            encodingIANAAliasesMap.put("ISO-8859-2", "ISO-8859-2");
            encodingIANAAliasesMap.put("LATIN2", "ISO-8859-2");
            encodingIANAAliasesMap.put("L2", "ISO-8859-2");
            encodingIANA2JavaMap.put("ISO-8859-3", "8859_3");
            encodingIANADescriptionMap.put("ISO-8859-3", EncodingUtil.getString("NAME_ISO-8859-3"));
            encodingIANAAliasesMap.put("ISO-8859-3", "ISO-8859-3");
            encodingIANAAliasesMap.put("LATIN3", "ISO-8859-3");
            encodingIANAAliasesMap.put("L3", "ISO-8859-3");
            encodingIANA2JavaMap.put("ISO-8859-4", "8859_4");
            encodingIANADescriptionMap.put("ISO-8859-4", EncodingUtil.getString("NAME_ISO-8859-4"));
            encodingIANAAliasesMap.put("ISO-8859-4", "ISO-8859-4");
            encodingIANAAliasesMap.put("LATIN4", "ISO-8859-4");
            encodingIANAAliasesMap.put("L4", "ISO-8859-4");
            encodingIANA2JavaMap.put("ISO-8859-5", "8859_5");
            encodingIANADescriptionMap.put("ISO-8859-5", EncodingUtil.getString("NAME_ISO-8859-5"));
            encodingIANAAliasesMap.put("ISO-8859-5", "ISO-8859-5");
            encodingIANAAliasesMap.put("CYRILLIC", "ISO-8859-5");
            encodingIANA2JavaMap.put("ISO-8859-6", "8859_6");
            encodingIANADescriptionMap.put("ISO-8859-6", EncodingUtil.getString("NAME_ISO-8859-6"));
            encodingIANAAliasesMap.put("ISO-8859-6", "ISO-8859-6");
            encodingIANA2JavaMap.put("ISO-8859-7", "8859_7");
            encodingIANADescriptionMap.put("ISO-8859-7", EncodingUtil.getString("NAME_ISO-8859-7"));
            encodingIANAAliasesMap.put("ISO-8859-7", "ISO-8859-7");
            encodingIANAAliasesMap.put("GREEK", "ISO-8859-7");
            encodingIANAAliasesMap.put("GREEK8", "ISO-8859-7");
            encodingIANA2JavaMap.put("ISO-8859-8", "8859_8");
            encodingIANADescriptionMap.put("ISO-8859-8", EncodingUtil.getString("NAME_ISO-8859-8"));
            encodingIANAAliasesMap.put("ISO-8859-8", "ISO-8859-8");
            encodingIANAAliasesMap.put("HEBREW", "ISO-8859-8");
            encodingIANA2JavaMap.put("ISO-8859-9", "8859_9");
            encodingIANADescriptionMap.put("ISO-8859-9", EncodingUtil.getString("NAME_ISO-8859-9"));
            encodingIANAAliasesMap.put("ISO-8859-9", "ISO-8859-9");
            encodingIANAAliasesMap.put("LATIN5", "ISO-8859-9");
            encodingIANAAliasesMap.put("L5", "ISO-8859-9");
            encodingIANA2JavaMap.put("KOI8-R", "KOI8_R");
            encodingIANADescriptionMap.put("KOI8-R", EncodingUtil.getString("NAME_KOI8-R"));
            encodingIANAAliasesMap.put("KOI8-R", "KOI8-R");
            encodingIANADescriptionMap.put("US-ASCII", EncodingUtil.getString("NAME_ASCII"));
            encodingIANAAliasesMap.put("ASCII", "US-ASCII");
            encodingIANAAliasesMap.put("US-ASCII", "US-ASCII");
            encodingIANAAliasesMap.put("ISO646-US", "US-ASCII");
            encodingIANAAliasesMap.put("IBM367", "US-ASCII");
            encodingIANAAliasesMap.put("CP367", "US-ASCII");
            encodingIANA2JavaMap.put("UTF-8", "UTF8");
            encodingIANADescriptionMap.put("UTF-8", EncodingUtil.getString("NAME_UTF-8"));
            encodingIANAAliasesMap.put("UTF-8", "UTF-8");
            encodingIANA2JavaMap.put("UTF-16", "Unicode");
            encodingIANADescriptionMap.put("UTF-16", EncodingUtil.getString("NAME_UTF-16"));
            encodingIANAAliasesMap.put("UTF-16", "UTF-16");
            for (Object k : encodingIANA2JavaMap.keySet()) {
                encodingJava2IANAMap.put(encodingIANA2JavaMap.get(k), k);
            }
            encodingIANA2JavaMap.put("US-ASCII", "8859_1");
        }
    }
}

