/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.visualweb.insync.Convertors;

public class EncodingHelper {
    private static final int EXPECTED_PROLOG_LENGTH = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectEncoding(InputStream inputStream) throws IOException {
        String string;
        block9: {
            byte[] byArray;
            block8: {
                String string2;
                if (!inputStream.markSupported()) {
                    return null;
                }
                try {
                    inputStream.mark(1000);
                    byArray = new byte[1000];
                    for (int i = 0; i < byArray.length; ++i) {
                        try {
                            int n = inputStream.read();
                            if (n == -1) break;
                            byArray[i] = (byte)n;
                            continue;
                        }
                        catch (EOFException eOFException) {
                            // empty catch block
                        }
                    }
                    if ((string = EncodingHelper.autoDetectEncoding(byArray)) != null) break block8;
                    string2 = null;
                    Object var5_9 = null;
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    inputStream.reset();
                    throw throwable;
                }
                inputStream.reset();
                return string2;
            }
            string = EncodingHelper.detectDeclaredEncoding(byArray, string);
            if (string != null) break block9;
            String string3 = null;
            Object var5_10 = null;
            inputStream.reset();
            return string3;
        }
        String string4 = Convertors.iana2java(string);
        Object var5_11 = null;
        inputStream.reset();
        return string4;
    }

    static String autoDetectEncoding(byte[] byArray) throws IOException {
        if (byArray.length >= 4) {
            switch (byArray[0]) {
                case 0: {
                    if (byArray[1] != 60 || byArray[2] != 0 || byArray[3] != 63) break;
                    return "UnicodeBigUnmarked";
                }
                case 60: {
                    switch (byArray[1]) {
                        case 0: {
                            if (byArray[2] != 63 || byArray[3] != 0) break;
                            return "UnicodeLittleUnmarked";
                        }
                        case 63: {
                            if (byArray[2] != 120 || byArray[3] != 109) break;
                            return "UTF8";
                        }
                    }
                    break;
                }
                case 76: {
                    if (byArray[1] != 111 || byArray[2] != -89 || byArray[3] != -108) break;
                    return "Cp037";
                }
                case -2: {
                    if (byArray[1] != -1 || byArray[2] == 0 && byArray[3] == 0) break;
                    return "UnicodeBig";
                }
                case -1: {
                    if (byArray[1] != -2 || byArray[2] == 0 && byArray[3] == 0) break;
                    return "UnicodeLittle";
                }
                case -17: {
                    if (byArray[1] != -69 || byArray[2] != -65) break;
                    return "UTF8";
                }
            }
        }
        return null;
    }

    static String detectDeclaredEncoding(byte[] byArray, String string) throws IOException {
        int n;
        String string2;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\"';
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string);
        try {
            int n3 = ((Reader)inputStreamReader).read();
            while (n3 != -1) {
                stringBuffer.append((char)n3);
                n3 = ((Reader)inputStreamReader).read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        n2 = (n2 = (string2 = stringBuffer.toString()).indexOf("?>")) == -1 ? string2.length() : n2;
        int n4 = string2.indexOf("encoding");
        if (n4 == -1 || n4 > n2) {
            return null;
        }
        char[] cArray = string2.toCharArray();
        for (n = n4; n < n2 && cArray[n] != '='; ++n) {
        }
        while (n < n2) {
            if (cArray[n] == '\'' || cArray[n] == '\"') {
                c = cArray[n];
                break;
            }
            ++n;
        }
        int n5 = ++n;
        while (n < n2) {
            if (cArray[n] == c) {
                return new String(cArray, n5, n - n5);
            }
            ++n;
        }
        return null;
    }

    static String parseMIMECharSet(String string) {
        int n;
        if (string != null && (n = (string = string.toLowerCase()).indexOf(59)) != -1) {
            String string2 = string.substring(n + 1);
            string = string.substring(0, n);
            n = string2.indexOf("charset");
            if (n != -1) {
                if ((n = (string2 = string2.substring(n + "charset".length())).indexOf(59)) != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((n = string2.indexOf(61)) != -1) {
                    if ((n = (string2 = string2.substring(n + 1)).indexOf(40)) != -1) {
                        string2 = string2.substring(0, n);
                    }
                    if ((n = string2.indexOf(34)) != -1) {
                        string2 = string2.substring(n + 1);
                        string2 = string2.substring(0, string2.indexOf(34));
                    }
                    return string2.trim();
                }
            }
        }
        return null;
    }

    public static String detectEncoding(Document document) throws IOException {
        if (document == null) {
            return null;
        }
        try {
            String string = document.getText(0, document.getLength() > 1000 ? 1000 : document.getLength());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            return EncodingHelper.detectEncoding(byteArrayInputStream);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException.toString());
        }
    }
}

