/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.faces.refactoring;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.visualweb.insync.faces.refactoring.FacesMoveRefactoringUI;
import org.netbeans.modules.visualweb.insync.faces.refactoring.FacesRefactoringUtils;
import org.netbeans.modules.visualweb.insync.faces.refactoring.FacesRenameRefactoringUI;
import org.netbeans.modules.visualweb.insync.live.DesignBeanNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.PasteType;

public class FacesRefactoringActionsProvider
extends ActionsImplementationProvider {
    public boolean canRename(Lookup lookup) {
        DataObject dataObject;
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        if (node != null && (dataObject = (DataObject)node.getLookup().lookup(DataObject.class)) != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            if (FacesRefactoringUtils.isVisualWebJspFile(fileObject)) {
                return true;
            }
            if (fileObject.isFolder() && FacesRefactoringUtils.isFileUnderDocumentRoot(fileObject) && !FacesRefactoringUtils.isSpecialFolderName(fileObject.getNameExt())) {
                return true;
            }
        }
        return false;
    }

    public void doRename(final Lookup lookup) {
        if (this.canRename(lookup)) {
            NodeToFileObjectTask nodeToFileObjectTask = new NodeToFileObjectTask(lookup.lookupAll(Node.class)){

                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    String string = FacesRefactoringActionsProvider.getNewName(lookup);
                    return new FacesRenameRefactoringUI(fileObjectArray[0], string);
                }
            };
            FacesRefactoringUtils.invokeAfterScanFinished(nodeToFileObjectTask, FacesRefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.renameAction()));
        }
    }

    public boolean canMove(Lookup lookup) {
        DataObject dataObject;
        Node node = (Node)lookup.lookup(Node.class);
        if (node != null && !(node instanceof DesignBeanNode) && (dataObject = (DataObject)node.getLookup().lookup(DataObject.class)) != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            if (FacesRefactoringUtils.isVisualWebJspFile(fileObject)) {
                return true;
            }
            if (fileObject.isFolder() && FacesRefactoringUtils.isFileUnderDocumentRoot(fileObject) && !FacesRefactoringUtils.isSpecialFolderName(fileObject.getNameExt())) {
                return true;
            }
        }
        return false;
    }

    public void doMove(final Lookup lookup) {
        if (this.canMove(lookup)) {
            NodeToFileObjectTask nodeToFileObjectTask = new NodeToFileObjectTask(lookup.lookupAll(Node.class)){

                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    PasteType pasteType = FacesRefactoringActionsProvider.this.getPaste(lookup);
                    FileObject fileObject = FacesRefactoringActionsProvider.this.getTarget(lookup);
                    if (fileObjectArray.length == 1) {
                        return new FacesMoveRefactoringUI(fileObjectArray[0], fileObject, pasteType);
                    }
                    throw new UnsupportedOperationException("Cannot move multiple files/folders yet!");
                }
            };
            FacesRefactoringUtils.invokeAfterScanFinished(nodeToFileObjectTask, FacesRefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.moveAction()));
        }
    }

    private FileObject getTarget(Lookup lookup) {
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        if (explorerContext == null) {
            return null;
        }
        Node node = explorerContext.getTargetNode();
        if (node == null) {
            return null;
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    private PasteType getPaste(Lookup lookup) {
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        if (explorerContext == null) {
            return null;
        }
        Transferable transferable = explorerContext.getTransferable();
        if (transferable == null) {
            return null;
        }
        Node node = explorerContext.getTargetNode();
        if (node == null) {
            return null;
        }
        PasteType[] pasteTypeArray = node.getPasteTypes(transferable);
        if (pasteTypeArray.length == 1) {
            return null;
        }
        return pasteTypeArray[1];
    }

    private static String getNewName(Lookup lookup) {
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        if (explorerContext == null) {
            return null;
        }
        return explorerContext.getNewName();
    }

    static String getActionName(Action action) {
        String string = (String)action.getValue("Name");
        string = Utilities.replaceString((String)string, (String)"&", (String)"");
        return Utilities.replaceString((String)string, (String)"...", (String)"");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToFileObjectTask
    implements Runnable {
        private Collection<? extends Node> nodes;

        public NodeToFileObjectTask(Collection<? extends Node> collection) {
            this.nodes = collection;
        }

        @Override
        public void run() {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.nodes.size());
            for (Node node : this.nodes) {
                FileObject fileObject;
                DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
                if (dataObject == null || (fileObject = dataObject.getPrimaryFile()) == null) continue;
                arrayList.add(fileObject);
            }
            UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(arrayList.toArray(new FileObject[arrayList.size()])));
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1);
    }
}

