/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.java;

import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;

public class TreeUtils {
    static TreePath getTreePath(CompilationInfo compilationInfo, Tree tree) {
        return compilationInfo.getTrees().getPath(compilationInfo.getCompilationUnit(), tree);
    }

    static String getFQN(CompilationInfo compilationInfo, Tree tree) {
        return ((Object)compilationInfo.getTrees().getTypeMirror(TreeUtils.getTreePath(compilationInfo, tree))).toString();
    }

    static Element getElement(CompilationInfo compilationInfo, Tree tree) {
        return compilationInfo.getTrees().getElement(TreeUtils.getTreePath(compilationInfo, tree));
    }

    static TypeElement getTypeElement(CompilationInfo compilationInfo, Tree tree) {
        return (TypeElement)TreeUtils.getElement(compilationInfo, tree);
    }

    static String getPrecedingImmediateCommentText(CompilationInfo compilationInfo, Tree tree) {
        List list = compilationInfo.getTreeUtilities().getComments(tree, true);
        return list.size() > 0 ? ((Comment)list.get(list.size() - 1)).getText() : null;
    }

    static long getModifierFlags(ModifiersTree modifiersTree) {
        long l = 0L;
        for (Modifier modifier : modifiersTree.getFlags()) {
            switch (modifier) {
                case PUBLIC: {
                    l |= 1L;
                    break;
                }
                case PROTECTED: {
                    l |= 4L;
                    break;
                }
                case PRIVATE: {
                    l |= 2L;
                    break;
                }
                case ABSTRACT: {
                    l |= 0x400L;
                    break;
                }
                case STATIC: {
                    l |= 8L;
                    break;
                }
                case FINAL: {
                    l |= 0x10L;
                    break;
                }
                case TRANSIENT: {
                    l |= 0x80L;
                    break;
                }
                case VOLATILE: {
                    l |= 0x40L;
                    break;
                }
                case SYNCHRONIZED: {
                    l |= 0x20L;
                    break;
                }
                case NATIVE: {
                    l |= 0x100L;
                    break;
                }
            }
        }
        return l;
    }
}

