/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.live;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.PropertyEditor2;
import com.sun.rave.propertyeditors.resolver.PropertyEditorResolver;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.Collection;
import org.netbeans.modules.visualweb.extension.openide.util.Trace;
import org.netbeans.modules.visualweb.insync.live.BeanSelectionEditor;
import org.netbeans.modules.visualweb.insync.live.LiveUnit;
import org.netbeans.modules.visualweb.insync.live.SourceDesignBean;
import org.openide.util.Lookup;

public abstract class SourceDesignProperty
implements DesignProperty {
    public static final SourceDesignProperty[] EMPTY_ARRAY = new SourceDesignProperty[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected final PropertyDescriptor descriptor;
    protected final SourceDesignBean liveBean;
    protected PropertyEditor editor;
    protected boolean modified = false;
    protected Object initialValue;
    protected String category;
    private static Lookup.Result propertyEditorResolverLookupResult;

    protected SourceDesignProperty(PropertyDescriptor propertyDescriptor, SourceDesignBean sourceDesignBean) {
        this.descriptor = propertyDescriptor;
        this.liveBean = sourceDesignBean;
        if (propertyDescriptor.getWriteMethod() != null) {
            this.initialValue = this.getValue();
        }
    }

    protected abstract void initLive();

    public ClipImage getClipImage() {
        if (!this.isModified()) {
            return null;
        }
        return new ClipImage(this.descriptor.getName(), this.getValue());
    }

    public void setPropertyCategory(String string) {
        this.category = string;
    }

    public String getPropertyCategory() {
        return this.category;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.descriptor;
    }

    public DesignBean getDesignBean() {
        return this.liveBean;
    }

    private static PropertyEditorResolver[] getPropertyEditorResolvers() {
        Collection collection;
        if (propertyEditorResolverLookupResult == null) {
            collection = new Lookup.Template(PropertyEditorResolver.class);
            Lookup lookup = Lookup.getDefault();
            propertyEditorResolverLookupResult = lookup.lookup((Lookup.Template)collection);
        }
        collection = propertyEditorResolverLookupResult.allInstances();
        return collection.toArray(new PropertyEditorResolver[collection.size()]);
    }

    protected void loadEditor() {
        if (this.editor == null) {
            for (PropertyEditorResolver propertyEditorResolver : SourceDesignProperty.getPropertyEditorResolvers()) {
                this.editor = propertyEditorResolver.getEditor(this.descriptor);
                if (this.editor != null) break;
            }
        }
        if (this.editor == null && this.descriptor.getPropertyEditorClass() != null) {
            try {
                this.editor = (PropertyEditor)this.descriptor.getPropertyEditorClass().newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.editor == null) {
            this.editor = PropertyEditorManager.findEditor(this.descriptor.getPropertyType());
        }
        if (this.editor == null) {
            this.editor = new BeanSelectionEditor(this);
        }
        if (this.editor instanceof PropertyEditor2) {
            try {
                ((PropertyEditor2)this.editor).setDesignProperty((DesignProperty)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void unloadPropertyEditor() {
        this.editor = null;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.loadEditor();
        }
        return this.editor;
    }

    protected Object invokeGetter() {
        Method method = this.descriptor.getReadMethod();
        if (method == null) {
            return null;
        }
        try {
            Object object = this.liveBean.getInstance();
            if (object != null) {
                Object object2 = method.invoke(object, EMPTY_OBJECT_ARRAY);
                assert (Trace.trace((String)"insync.live", (String)("SLP.getValue " + this.descriptor.getName() + " is:" + object2)));
                return object2;
            }
        }
        catch (Exception exception) {
            System.err.println("Caught " + exception + " in SLP.invokeGetter " + this.liveBean.beanInfo.getBeanDescriptor().getBeanClass().getName() + "." + this.descriptor.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((LiveUnit)this.getDesignBean().getDesignContext()).getBeansUnit().getClassLoader());
            Object object = this.invokeGetter();
            Object var4_3 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
    }

    public abstract String getValueSource();

    protected final String toJavaInitializationString(Object object) {
        if (this.editor == null) {
            this.loadEditor();
        }
        if (this.editor != null) {
            try {
                this.editor.setValue(object);
                String string = this.editor.getJavaInitializationString();
                return string != null ? string : "null";
            }
            catch (Exception exception) {
                System.err.println("Caught " + exception + " in SLP.toJavaInitializationString editor: " + this.editor);
            }
        }
        return object != null ? String.valueOf(object) : "null";
    }

    protected boolean invokeSetter(Object object) {
        Method method = this.descriptor.getWriteMethod();
        if (method == null) {
            return false;
        }
        try {
            method.invoke(this.liveBean.getInstance(), object);
            this.setModified(true);
            return true;
        }
        catch (Exception exception) {
            System.err.print("Caught " + exception + " in SLP.invokeSetter " + this.liveBean.beanInfo.getBeanDescriptor().getBeanClass().getName() + "." + this.descriptor.getName() + " to:" + object);
            if (object != null) {
                System.err.println(" [" + object.getClass().getName() + "]");
            } else {
                System.err.println();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValue(Object object) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((LiveUnit)this.getDesignBean().getDesignContext()).getBeansUnit().getClassLoader());
            Object object2 = this.invokeGetter();
            boolean bl = this.invokeSetter(object);
            if (bl) {
                this.liveBean.fireDesignPropertyChanged(this, object2);
            }
            boolean bl2 = bl;
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
    }

    public abstract boolean setValueSource(String var1);

    public void setModified(boolean bl) {
        this.modified = bl;
        if (!bl) {
            this.initialValue = this.getValue();
        }
    }

    public static boolean objectsEqual(Object object, Object object2) {
        return object == null == (object2 == null) && (object == null || object.equals(object2));
    }

    public boolean equalsInitial(Object object) {
        return SourceDesignProperty.objectsEqual(this.initialValue, object);
    }

    public boolean isModified() {
        return this.modified;
    }

    public Object getUnsetValue() {
        return this.initialValue;
    }

    public boolean unset() {
        boolean bl = this.setValue(this.initialValue);
        if (bl) {
            this.modified = false;
        }
        return bl;
    }

    public String toString() {
        return "[SLP name:" + this.descriptor.getName() + " value:" + this.getValue() + "]";
    }

    public static class ClipImage {
        String name;
        Object value;

        ClipImage(String string, Object object) {
            this.name = string;
            this.value = object;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            this.toString(stringBuffer);
            return stringBuffer.toString();
        }

        public void toString(StringBuffer stringBuffer) {
            stringBuffer.append("[DesignProperty.ClipImage");
            stringBuffer.append(" name=" + this.name);
            stringBuffer.append(" value=" + this.value);
            stringBuffer.append("]");
        }
    }
}

