/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.FileBuiltQuery;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class ProjectBuiltQuery {
    public static Status getStatus(Project project) {
        return new StatusImpl(project);
    }

    private static class StatusImpl
    implements Status,
    FileChangeListener,
    PropertyChangeListener {
        private Project project;
        private boolean built = false;
        private Map<String, Boolean> fileObjectBuiltStatusMap;
        private Map<String, FileObjectStatusChangeListener> fileObjectStatusChangeListenerMap;
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

        StatusImpl(Project project) {
            this.project = project;
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            if (this.project == null) {
                throw new NullPointerException();
            }
            Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
            if (sources == null) {
                throw new IllegalArgumentException(NbBundle.getMessage(ProjectBuiltQuery.class, (String)"ERROR_ProjectHasNoSources"));
            }
            try {
                FileSystem fileSystem;
                this.fileObjectBuiltStatusMap = new HashMap<String, Boolean>();
                this.fileObjectStatusChangeListenerMap = new HashMap<String, FileObjectStatusChangeListener>();
                for (SourceGroup sourceGroup : fileSystem = sources.getSourceGroups("java")) {
                    FileObject fileObject = sourceGroup.getRootFolder();
                    if (fileObject == null || !fileObject.isFolder()) continue;
                    Enumeration enumeration = fileObject.getChildren(true);
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject2 = (FileObject)enumeration.nextElement();
                        FileBuiltQuery.Status status = FileBuiltQuery.getStatus((FileObject)fileObject2);
                        if (status == null) continue;
                        String string = fileObject2.getPath();
                        StatusImpl statusImpl = this;
                        synchronized (statusImpl) {
                            this.fileObjectBuiltStatusMap.put(string, status.isBuilt());
                            this.fileObjectStatusChangeListenerMap.put(string, new FileObjectStatusChangeListener(status, string));
                        }
                    }
                }
                this.update();
                FileSystem fileSystem2 = this.project.getProjectDirectory().getFileSystem();
                fileSystem2.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)fileSystem2));
                OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjects.getDefault()));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(65536, (Throwable)fileStateInvalidException);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
                this.checkProjectOpen();
            }
        }

        public Project getProject() {
            return this.project;
        }

        public boolean isBuilt() {
            if (!this.checkProjectOpen()) {
                ErrorManager.getDefault().log(1, NbBundle.getMessage(ProjectBuiltQuery.class, (String)"ERROR_ProjectIsNotOpen"));
            }
            return this.built;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] changeListenerArray;
            Object object = this.listeners;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (ChangeListener changeListener : changeListenerArray) {
                changeListener.stateChanged((ChangeEvent)object);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDataCreated(FileEvent fileEvent) {
            FileBuiltQuery.Status status;
            FileObject fileObject = fileEvent.getFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == this.project && (status = FileBuiltQuery.getStatus((FileObject)fileObject)) != null) {
                String string = fileObject.getPath();
                StatusImpl statusImpl = this;
                synchronized (statusImpl) {
                    this.fileObjectBuiltStatusMap.put(string, status.isBuilt());
                    this.fileObjectStatusChangeListenerMap.put(string, new FileObjectStatusChangeListener(status, string));
                }
                this.update();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == this.project) {
                StatusImpl statusImpl = this;
                synchronized (statusImpl) {
                    if (this.fileObjectBuiltStatusMap == null) {
                        return;
                    }
                    String string = fileObject.getPath();
                    this.fileObjectBuiltStatusMap.remove(string);
                    FileObjectStatusChangeListener fileObjectStatusChangeListener = this.fileObjectStatusChangeListenerMap.remove(string);
                    if (fileObjectStatusChangeListener != null) {
                        fileObjectStatusChangeListener.dispose();
                    }
                }
                this.update();
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileObject fileObject = fileRenameEvent.getFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == this.project) {
                String string = fileRenameEvent.getExt();
                String string2 = fileObject.getParent().getPath() + "/" + fileRenameEvent.getName() + (string.length() == 0 ? string : "." + string);
                FileBuiltQuery.Status status = FileBuiltQuery.getStatus((FileObject)fileObject);
                String string3 = fileObject.getPath();
                StatusImpl statusImpl = this;
                synchronized (statusImpl) {
                    this.fileObjectBuiltStatusMap.remove(string2);
                    FileObjectStatusChangeListener fileObjectStatusChangeListener = this.fileObjectStatusChangeListenerMap.remove(string2);
                    if (fileObjectStatusChangeListener != null) {
                        fileObjectStatusChangeListener.dispose();
                    }
                    if (status != null) {
                        this.fileObjectBuiltStatusMap.put(string3, status.isBuilt());
                        this.fileObjectStatusChangeListenerMap.put(string3, new FileObjectStatusChangeListener(status, string3));
                    }
                }
                this.update();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            StatusImpl statusImpl = this;
            synchronized (statusImpl) {
                boolean bl = true;
                for (String string : this.fileObjectBuiltStatusMap.keySet()) {
                    boolean bl2 = this.fileObjectBuiltStatusMap.get(string);
                    if (bl2) continue;
                    bl = false;
                    break;
                }
                if (this.built != bl) {
                    this.built = bl;
                    this.fireChange();
                }
            }
        }

        private boolean isProjectOpen() {
            if (this.project == null) {
                return false;
            }
            return Arrays.asList(OpenProjects.getDefault().getOpenProjects()).contains(this.project);
        }

        private boolean checkProjectOpen() {
            boolean bl = this.isProjectOpen();
            if (!bl) {
                this.dispose();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            if (this.project == null) {
                return;
            }
            this.project = null;
            this.fileObjectBuiltStatusMap = null;
            StatusImpl statusImpl = this;
            synchronized (statusImpl) {
                for (FileObjectStatusChangeListener fileObjectStatusChangeListener : this.fileObjectStatusChangeListenerMap.values()) {
                    fileObjectStatusChangeListener.dispose();
                }
            }
            this.fileObjectStatusChangeListenerMap = null;
            this.listeners = null;
        }

        private class FileObjectStatusChangeListener
        implements ChangeListener {
            private final String fileObjectPath;
            private final FileBuiltQuery.Status status;

            FileObjectStatusChangeListener(FileBuiltQuery.Status status, String string) {
                this.fileObjectPath = string;
                this.status = status;
                this.status.addChangeListener((ChangeListener)this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent changeEvent) {
                FileBuiltQuery.Status status = (FileBuiltQuery.Status)changeEvent.getSource();
                if (status != null) {
                    StatusImpl statusImpl = StatusImpl.this;
                    synchronized (statusImpl) {
                        if (StatusImpl.this.fileObjectBuiltStatusMap == null) {
                            this.dispose();
                        } else {
                            StatusImpl.this.fileObjectBuiltStatusMap.put(this.fileObjectPath, status.isBuilt());
                            StatusImpl.this.update();
                        }
                    }
                }
            }

            void dispose() {
                this.status.removeChangeListener((ChangeListener)this);
            }
        }
    }

    public static interface Status {
        public Project getProject();

        public boolean isBuilt();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

