/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.PointShape;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.layout.ConnectionWidgetLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionWidget
extends Widget {
    private static final double HIT_DISTANCE_SQUARE = 16.0;
    private static final Stroke STROKE_DEFAULT = new BasicStroke(1.0f);
    private Anchor sourceAnchor;
    private Anchor targetAnchor;
    private AnchorShape sourceAnchorShape;
    private AnchorShape targetAnchorShape;
    private PointShape controlPointShape;
    private PointShape endPointShape;
    private Router router;
    private boolean routingRequired = true;
    private List<Point> controlPoints = Collections.emptyList();
    private List<Point> controlPointsUm = Collections.unmodifiableList(this.controlPoints);
    private ConnectionWidgetLayout connectionWidgetLayout;
    private Stroke stroke;
    private boolean paintControlPoints;
    private Color lineColor;
    private Cursor controlPointsCursor;
    private int controlPointCutDistance;
    private Anchor.Entry sourceEntry;
    private Anchor.Entry targetEntry;
    private RoutingPolicy routingPolicy;

    public ConnectionWidget(Scene scene) {
        super(scene);
        this.sourceAnchorShape = AnchorShape.NONE;
        this.targetAnchorShape = AnchorShape.NONE;
        this.controlPointShape = PointShape.NONE;
        this.endPointShape = PointShape.NONE;
        this.router = RouterFactory.createDirectRouter();
        this.connectionWidgetLayout = new ConnectionWidgetLayout(this);
        this.setLayout(this.connectionWidgetLayout);
        this.stroke = STROKE_DEFAULT;
        this.paintControlPoints = false;
        this.controlPointCutDistance = 0;
        this.sourceEntry = new ConnectionEntry(true);
        this.targetEntry = new ConnectionEntry(false);
        this.routingPolicy = RoutingPolicy.ALWAYS_ROUTE;
    }

    @Override
    public void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        this.setForeground(this.lineColor != null ? this.lineColor : this.getScene().getLookFeel().getLineColor(objectState2));
        this.setPaintControlPoints(objectState2.isSelected());
    }

    public final Stroke getStroke() {
        return this.stroke;
    }

    public final void setStroke(Stroke stroke) {
        assert (stroke != null);
        this.stroke = stroke;
        this.repaint();
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public final void setLineColor(Color color) {
        this.lineColor = color;
        ObjectState objectState = this.getState();
        this.notifyStateChanged(objectState, objectState);
    }

    public final boolean isPaintControlPoints() {
        return this.paintControlPoints;
    }

    public final void setPaintControlPoints(boolean bl) {
        this.paintControlPoints = bl;
        this.repaint();
    }

    public final Cursor getControlPointsCursor() {
        return this.controlPointsCursor;
    }

    public final void setControlPointsCursor(Cursor cursor) {
        this.controlPointsCursor = cursor;
    }

    public int getControlPointCutDistance() {
        return this.controlPointCutDistance;
    }

    public void setControlPointCutDistance(int n) {
        this.controlPointCutDistance = n;
        this.repaint();
    }

    public final Anchor getSourceAnchor() {
        return this.sourceAnchor;
    }

    public final void setSourceAnchor(Anchor anchor) {
        if (this.sourceAnchor != null) {
            this.sourceAnchor.removeEntry(this.sourceEntry);
        }
        this.sourceAnchor = anchor;
        if (this.sourceAnchor != null) {
            anchor.addEntry(this.sourceEntry);
        }
        this.reroute();
    }

    public final Anchor getTargetAnchor() {
        return this.targetAnchor;
    }

    public final void setTargetAnchor(Anchor anchor) {
        if (this.targetAnchor != null) {
            this.targetAnchor.removeEntry(this.targetEntry);
        }
        this.targetAnchor = anchor;
        if (anchor != null) {
            anchor.addEntry(this.targetEntry);
        }
        this.reroute();
    }

    public Anchor.Entry getSourceAnchorEntry() {
        return this.sourceEntry;
    }

    public Anchor.Entry getTargetAnchorEntry() {
        return this.targetEntry;
    }

    public AnchorShape getSourceAnchorShape() {
        return this.sourceAnchorShape;
    }

    public void setSourceAnchorShape(AnchorShape anchorShape) {
        assert (anchorShape != null);
        boolean bl = this.sourceAnchorShape.getRadius() == anchorShape.getRadius();
        this.sourceAnchorShape = anchorShape;
        this.revalidate(bl);
    }

    public AnchorShape getTargetAnchorShape() {
        return this.targetAnchorShape;
    }

    public void setTargetAnchorShape(AnchorShape anchorShape) {
        assert (anchorShape != null);
        boolean bl = this.targetAnchorShape.getRadius() == anchorShape.getRadius();
        this.targetAnchorShape = anchorShape;
        this.revalidate(bl);
    }

    public PointShape getControlPointShape() {
        return this.controlPointShape;
    }

    public void setControlPointShape(PointShape pointShape) {
        assert (pointShape != null);
        boolean bl = this.controlPointShape.getRadius() == pointShape.getRadius();
        this.controlPointShape = pointShape;
        this.revalidate(bl);
    }

    public PointShape getEndPointShape() {
        return this.endPointShape;
    }

    public void setEndPointShape(PointShape pointShape) {
        assert (pointShape != null);
        boolean bl = this.endPointShape.getRadius() == pointShape.getRadius();
        this.endPointShape = pointShape;
        this.revalidate(bl);
    }

    public final RoutingPolicy getRoutingPolicy() {
        return this.routingPolicy;
    }

    public final void setRoutingPolicy(RoutingPolicy routingPolicy) {
        assert (routingPolicy != null);
        if (this.routingPolicy == routingPolicy) {
            return;
        }
        boolean bl = routingPolicy != RoutingPolicy.DISABLE_ROUTING;
        this.routingPolicy = routingPolicy;
        if (bl) {
            this.reroute();
        }
    }

    public final Router getRouter() {
        return this.router;
    }

    public final void setRouter(Router router) {
        assert (router != null);
        this.router = router;
        this.reroute();
    }

    public List<Point> getControlPoints() {
        return this.controlPointsUm;
    }

    public Point getControlPoint(int n) {
        if (n < 0 || n >= this.controlPoints.size()) {
            return null;
        }
        return new Point(this.controlPoints.get(n));
    }

    public void setControlPoints(Collection<Point> collection, boolean bl) {
        if (collection == null) {
            return;
        }
        if (bl) {
            Point point = this.convertLocalToScene(new Point());
            ArrayList<Point> arrayList = new ArrayList<Point>();
            for (Point point2 : collection) {
                arrayList.add(new Point(point2.x - point.x, point2.y - point.y));
            }
            this.controlPoints = arrayList;
        } else {
            this.controlPoints = new ArrayList<Point>(collection);
        }
        this.controlPointsUm = Collections.unmodifiableList(this.controlPoints);
        this.routingRequired = false;
        this.revalidate();
    }

    public void setConstraint(Widget widget, LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, float f) {
        this.connectionWidgetLayout.setConstraint(widget, connectionWidgetLayoutAlignment, f);
    }

    public void setConstraint(Widget widget, LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, int n) {
        this.connectionWidgetLayout.setConstraint(widget, connectionWidgetLayoutAlignment, n);
    }

    public void removeConstraint(Widget widget) {
        this.connectionWidgetLayout.removeConstraint(widget);
    }

    public final void calculateRouting() {
        if (this.routingRequired) {
            switch (this.routingPolicy) {
                case ALWAYS_ROUTE: {
                    this.setControlPoints(this.router.routeConnection(this), true);
                    break;
                }
                case UPDATE_END_POINTS_ONLY: {
                    Point point;
                    Point point2 = this.sourceAnchor != null ? this.sourceAnchor.compute(this.sourceEntry).getAnchorSceneLocation() : null;
                    Point point3 = point = this.targetAnchor != null ? this.targetAnchor.compute(this.targetEntry).getAnchorSceneLocation() : null;
                    if (point2 == null || point == null) {
                        this.controlPoints.clear();
                        break;
                    }
                    point2 = this.convertSceneToLocal(point2);
                    point = this.convertSceneToLocal(point);
                    if (this.controlPoints.size() < 1) {
                        this.controlPoints.add(point2);
                    } else {
                        this.controlPoints.set(0, point2);
                    }
                    if (this.controlPoints.size() < 2) {
                        this.controlPoints.add(point);
                        break;
                    }
                    this.controlPoints.set(this.controlPoints.size() - 1, point);
                    break;
                }
                case DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED: {
                    Point point = this.sourceAnchor != null ? this.sourceAnchor.compute(this.sourceEntry).getAnchorSceneLocation() : null;
                    Point point4 = this.getFirstControlPoint();
                    if (point4 != null) {
                        point4 = this.convertLocalToScene(point4);
                    }
                    if (point == null ? point4 == null : point.equals(point4)) {
                        Point point5 = this.targetAnchor != null ? this.targetAnchor.compute(this.targetEntry).getAnchorSceneLocation() : null;
                        Point point6 = this.getLastControlPoint();
                        if (point6 != null) {
                            point6 = this.convertLocalToScene(point6);
                        }
                        if (point5 == null ? point6 == null : point5.equals(point6)) break;
                    }
                    this.routingPolicy = RoutingPolicy.ALWAYS_ROUTE;
                    this.setControlPoints(this.router.routeConnection(this), true);
                    break;
                }
                case DISABLE_ROUTING: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected routing policy: " + (Object)((Object)this.routingPolicy));
                }
            }
        }
    }

    @Override
    protected Rectangle calculateClientArea() {
        Point point;
        this.calculateRouting();
        int n = this.controlPointShape.getRadius();
        int n2 = n + n;
        int n3 = this.endPointShape.getRadius();
        Rectangle rectangle = null;
        for (Point point2 : this.controlPoints) {
            Rectangle rectangle2 = new Rectangle(point2.x - n, point2.y - n, n2, n2);
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle.add(rectangle2);
        }
        Point point3 = this.getFirstControlPoint();
        if (point3 != null) {
            int n4 = Math.max(this.sourceAnchorShape.getRadius(), n3);
            int n5 = n4 + n4;
            if (rectangle == null) {
                rectangle = new Rectangle(point3.x - n4, point3.y - n4, n5, n5);
            } else {
                rectangle.add(new Rectangle(point3.x - n4, point3.y - n4, n5, n5));
            }
        }
        if ((point = this.getLastControlPoint()) != null) {
            int n6 = Math.max(this.targetAnchorShape.getRadius(), n3);
            int n7 = n6 + n6;
            if (rectangle == null) {
                rectangle = new Rectangle(point.x - n6, point.y - n6, n7, n7);
            } else {
                rectangle.add(new Rectangle(point.x - n6, point.y - n6, n7, n7));
            }
        }
        if (rectangle != null) {
            rectangle.grow(2, 2);
        }
        return rectangle != null ? rectangle : new Rectangle();
    }

    @Override
    public boolean isValidated() {
        return super.isValidated() && this.isRouted();
    }

    public final boolean isRouted() {
        return !this.routingRequired;
    }

    public final void reroute() {
        this.routingRequired = true;
        this.revalidate();
    }

    public final Point getFirstControlPoint() {
        if (this.controlPoints.size() <= 0) {
            return null;
        }
        return new Point(this.controlPoints.get(0));
    }

    public final Point getLastControlPoint() {
        int n = this.controlPoints.size();
        if (n <= 0) {
            return null;
        }
        return new Point(this.controlPoints.get(n - 1));
    }

    private double getSourceAnchorShapeRotation() {
        if (this.controlPoints.size() <= 1) {
            return 0.0;
        }
        Point point = this.controlPoints.get(0);
        Point point2 = this.controlPoints.get(1);
        return Math.atan2(point2.y - point.y, point2.x - point.x);
    }

    public double getTargetAnchorShapeRotation() {
        int n = this.controlPoints.size();
        if (n <= 1) {
            return 0.0;
        }
        Point point = this.controlPoints.get(n - 1);
        Point point2 = this.controlPoints.get(n - 2);
        return Math.atan2(point2.y - point.y, point2.x - point.x);
    }

    @Override
    public boolean isHitAt(Point point) {
        if (!super.isHitAt(point)) {
            return false;
        }
        List<Point> list = this.getControlPoints();
        for (int i = 0; i < list.size() - 1; ++i) {
            Point point2 = list.get(i);
            Point point3 = list.get(i + 1);
            double d = Line2D.ptSegDistSq(point2.x, point2.y, point3.x, point3.y, point.x, point.y);
            if (!(d < 16.0)) continue;
            return true;
        }
        return this.getControlPointHitAt(point) >= 0;
    }

    public final boolean isFirstControlPointHitAt(Point point) {
        int n = this.endPointShape.getRadius();
        n *= n;
        Point point2 = this.getFirstControlPoint();
        return point2 != null && Point2D.distanceSq(point2.x, point2.y, point.x, point.y) <= (double)n;
    }

    public final boolean isLastControlPointHitAt(Point point) {
        int n = this.endPointShape.getRadius();
        n *= n;
        Point point2 = this.getLastControlPoint();
        return point2 != null && Point2D.distanceSq(point2.x, point2.y, point.x, point.y) <= (double)n;
    }

    public final int getControlPointHitAt(Point point) {
        int n = this.controlPointShape.getRadius();
        n *= n;
        if (this.isFirstControlPointHitAt(point)) {
            return 0;
        }
        if (this.isLastControlPointHitAt(point)) {
            return this.controlPoints.size() - 1;
        }
        for (int i = 0; i < this.controlPoints.size(); ++i) {
            Point point2 = this.controlPoints.get(i);
            if (!(Point2D.distanceSq(point2.x, point2.y, point.x, point.y) <= (double)n)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected Cursor getCursorAt(Point point) {
        Cursor cursor;
        if (this.paintControlPoints && (cursor = this.getControlPointsCursor()) != null && this.getControlPointHitAt(point) >= 0) {
            return cursor;
        }
        return super.getCursorAt(point);
    }

    @Override
    protected void paintWidget() {
        List<Point> list;
        double d;
        Graphics2D graphics2D = this.getGraphics();
        graphics2D.setColor(this.getForeground());
        GeneralPath generalPath = null;
        Point point = this.getFirstControlPoint();
        Point point2 = this.getLastControlPoint();
        boolean bl = this.sourceAnchorShape.getCutDistance() != 0.0;
        boolean bl2 = this.targetAnchorShape.getCutDistance() != 0.0;
        double d2 = point != null && (this.sourceAnchorShape.isLineOriented() || bl) ? this.getSourceAnchorShapeRotation() : 0.0;
        double d3 = d = point2 != null && (this.targetAnchorShape.isLineOriented() || bl2) ? this.getTargetAnchorShapeRotation() : 0.0;
        if ((bl || bl2) && this.controlPoints.size() >= 2) {
            list = new ArrayList<Point>(this.controlPoints);
            list.set(0, new Point(point.x + (int)(this.sourceAnchorShape.getCutDistance() * Math.cos(d2)), point.y + (int)(this.sourceAnchorShape.getCutDistance() * Math.sin(d2))));
            list.set(this.controlPoints.size() - 1, new Point(point2.x + (int)(this.targetAnchorShape.getCutDistance() * Math.cos(d)), point2.y + (int)(this.targetAnchorShape.getCutDistance() * Math.sin(d))));
        } else {
            list = this.controlPoints;
        }
        if (this.controlPointCutDistance > 0) {
            for (int i = 0; i < list.size() - 1; ++i) {
                double d4;
                double d5;
                double d6;
                Point point3;
                Point point4 = list.get(i);
                Point point5 = list.get(i + 1);
                double d7 = point4.distance(point5);
                if (i > 0) {
                    point3 = list.get(i - 1);
                    d6 = point3.distance(point4);
                    if (d7 < d6) {
                        d6 = d7;
                    }
                    if ((d5 = (double)this.controlPointCutDistance) > (d6 /= 2.0)) {
                        d5 = d6;
                    }
                    if (!Double.isNaN(d4 = Math.atan2(point5.y - point4.y, point5.x - point4.x))) {
                        generalPath = this.addToPath(generalPath, point4.x + (int)(d5 * Math.cos(d4)), point4.y + (int)(d5 * Math.sin(d4)));
                    }
                } else {
                    generalPath = this.addToPath(generalPath, point4.x, point4.y);
                }
                if (i < list.size() - 2) {
                    point3 = list.get(i + 2);
                    d6 = point5.distance(point3);
                    if (d7 < d6) {
                        d6 = d7;
                    }
                    if ((d5 = (double)this.controlPointCutDistance) > (d6 /= 2.0)) {
                        d5 = d6;
                    }
                    if (Double.isNaN(d4 = Math.atan2(point5.y - point4.y, point5.x - point4.x))) continue;
                    generalPath = this.addToPath(generalPath, point5.x - (int)(d5 * Math.cos(d4)), point5.y - (int)(d5 * Math.sin(d4)));
                    continue;
                }
                generalPath = this.addToPath(generalPath, point5.x, point5.y);
            }
        } else {
            for (Point point4 : list) {
                generalPath = this.addToPath(generalPath, point4.x, point4.y);
            }
        }
        if (generalPath != null) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(this.getForeground());
            graphics2D.setStroke(this.getStroke());
            graphics2D.draw(generalPath);
            graphics2D.setStroke(stroke);
        }
        if (point != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(point.x, point.y);
            if (this.sourceAnchorShape.isLineOriented()) {
                graphics2D.rotate(d2);
            }
            this.sourceAnchorShape.paint(graphics2D, true);
            graphics2D.setTransform(affineTransform);
        }
        if (point2 != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(point2.x, point2.y);
            if (this.targetAnchorShape.isLineOriented()) {
                graphics2D.rotate(d);
            }
            this.targetAnchorShape.paint(graphics2D, false);
            graphics2D.setTransform(affineTransform);
        }
        if (this.paintControlPoints) {
            int n = this.controlPoints.size() - 1;
            for (int i = 0; i <= n; ++i) {
                Point point6 = this.controlPoints.get(i);
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(point6.x, point6.y);
                if (i == 0 || i == n) {
                    this.endPointShape.paint(graphics2D);
                } else {
                    this.controlPointShape.paint(graphics2D);
                }
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    private GeneralPath addToPath(GeneralPath generalPath, int n, int n2) {
        if (generalPath == null) {
            generalPath = new GeneralPath();
            generalPath.moveTo(n, n2);
        } else {
            generalPath.lineTo(n, n2);
        }
        return generalPath;
    }

    private class ConnectionEntry
    implements Anchor.Entry {
        private boolean source;

        public ConnectionEntry(boolean bl) {
            this.source = bl;
        }

        public void revalidateEntry() {
            ConnectionWidget.this.reroute();
        }

        public ConnectionWidget getAttachedConnectionWidget() {
            return ConnectionWidget.this;
        }

        public boolean isAttachedToConnectionSource() {
            return this.source;
        }

        public Anchor getAttachedAnchor() {
            return this.source ? ConnectionWidget.this.getSourceAnchor() : ConnectionWidget.this.getTargetAnchor();
        }

        public Anchor getOppositeAnchor() {
            return this.source ? ConnectionWidget.this.getTargetAnchor() : ConnectionWidget.this.getSourceAnchor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RoutingPolicy {
        ALWAYS_ROUTE,
        UPDATE_END_POINTS_ONLY,
        DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED,
        DISABLE_ROUTING;

    }
}

