/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.openide.util.NbPreferences;

public class CsmFileFilter {
    private boolean showInclude = true;
    private boolean showMacro = true;
    private boolean showForwardFunctionDeclarations = false;
    private boolean showTypedef = true;
    private boolean showVariable = true;
    private boolean showUsing = true;

    public CsmFileFilter() {
        Preferences preferences = NbPreferences.forModule(CsmFileFilter.class);
        this.showForwardFunctionDeclarations = preferences.getBoolean("ShowForwardFunctionDeclarations", this.showForwardFunctionDeclarations);
        this.showMacro = preferences.getBoolean("ShowMacro", this.showMacro);
        this.showInclude = preferences.getBoolean("ShowInclude", this.showInclude);
        this.showTypedef = preferences.getBoolean("ShowTypedef", this.showTypedef);
        this.showVariable = preferences.getBoolean("ShowVariable", this.showVariable);
        this.showUsing = preferences.getBoolean("ShowMacro", this.showUsing);
    }

    public boolean isApplicable(CsmOffsetable csmOffsetable) {
        if (!this.isShowForwardFunctionDeclarations() && CsmKindUtilities.isFunctionDeclaration((CsmObject)csmOffsetable)) {
            CsmFunctionDefinition csmFunctionDefinition = ((CsmFunction)csmOffsetable).getDefinition();
            if (csmFunctionDefinition != null && !csmFunctionDefinition.equals(csmOffsetable) && !CsmKindUtilities.isMethod((CsmObject)csmFunctionDefinition)) {
                return !csmOffsetable.getContainingFile().equals(csmFunctionDefinition.getContainingFile());
            }
        } else {
            if (!this.isShowTypedef() && CsmKindUtilities.isTypedef((CsmObject)csmOffsetable)) {
                return false;
            }
            if (!this.isShowVariable() && CsmKindUtilities.isGlobalVariable((CsmObject)csmOffsetable)) {
                return false;
            }
            if (!this.isShowUsing() && (CsmKindUtilities.isUsing((CsmObject)csmOffsetable) || CsmKindUtilities.isNamespaceAlias((CsmObject)csmOffsetable))) {
                return false;
            }
        }
        return true;
    }

    public boolean isApplicableInclude() {
        return this.isShowInclude();
    }

    public boolean isApplicableMacro() {
        return this.isShowMacro();
    }

    public boolean isShowInclude() {
        return this.showInclude;
    }

    public void setShowInclude(boolean bl) {
        this.showInclude = bl;
        Preferences preferences = NbPreferences.forModule(CsmFileFilter.class);
        preferences.putBoolean("ShowInclude", this.showMacro);
    }

    public boolean isShowMacro() {
        return this.showMacro;
    }

    public void setShowMacro(boolean bl) {
        this.showMacro = bl;
        Preferences preferences = NbPreferences.forModule(CsmFileFilter.class);
        preferences.putBoolean("ShowMacro", bl);
    }

    public boolean isShowForwardFunctionDeclarations() {
        return this.showForwardFunctionDeclarations;
    }

    public void setShowForwardFunctionDeclarations(boolean bl) {
        this.showForwardFunctionDeclarations = bl;
        Preferences preferences = NbPreferences.forModule(CsmFileFilter.class);
        preferences.putBoolean("ShowForwardFunctionDeclarations", bl);
    }

    public boolean isShowTypedef() {
        return this.showTypedef;
    }

    public void setShowTypedef(boolean bl) {
        this.showTypedef = bl;
        Preferences preferences = NbPreferences.forModule(CsmFileFilter.class);
        preferences.putBoolean("ShowTypedef", bl);
    }

    public boolean isShowVariable() {
        return this.showVariable;
    }

    public void setShowVariable(boolean bl) {
        this.showVariable = bl;
        Preferences preferences = NbPreferences.forModule(CsmFileFilter.class);
        preferences.putBoolean("ShowVariable", bl);
    }

    public boolean isShowUsing() {
        return this.showUsing;
    }

    public void setShowUsing(boolean bl) {
        this.showUsing = bl;
        Preferences preferences = NbPreferences.forModule(CsmFileFilter.class);
        preferences.putBoolean("ShowUsing", bl);
    }
}

