/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.loaders.CCDataObject;
import org.netbeans.modules.cnd.loaders.CDataObject;
import org.netbeans.modules.cnd.loaders.CndDataObject;
import org.netbeans.modules.cnd.loaders.HDataObject;
import org.netbeans.modules.cnd.qnavigator.navigator.ItemEvent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorModel;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorPanelUI;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public class NavigatorComponent
implements NavigatorPanel,
LookupListener {
    private Lookup.Template CTemplate = new Lookup.Template(CDataObject.class);
    private Lookup.Result CContext;
    private Lookup.Template CCTemplate = new Lookup.Template(CCDataObject.class);
    private Lookup.Result CCContext;
    private Lookup.Template HTemplate = new Lookup.Template(HDataObject.class);
    private Lookup.Result HContext;
    private NavigatorPanelUI panelUI;
    private NavigatorModel curModel;
    private DataObject curData;

    public String getDisplayName() {
        return NbBundle.getBundle(NavigatorComponent.class).getString("LBL_members");
    }

    public String getDisplayHint() {
        return NbBundle.getBundle(NavigatorComponent.class).getString("HINT_NavigatorTopComponen");
    }

    public JComponent getComponent() {
        return this.getPanelUI();
    }

    public synchronized void panelActivated(Lookup lookup) {
        this.CContext = lookup.lookup(this.CTemplate);
        this.CCContext = lookup.lookup(this.CCTemplate);
        this.HContext = lookup.lookup(this.HTemplate);
        Collection collection = this.CContext.allInstances();
        if (this.CContext.allInstances().size() > 0) {
            this.curData = (DataObject)((List)collection).get(0);
        }
        collection = this.CCContext.allInstances();
        if (this.CCContext.allInstances().size() > 0 && this.curData == null) {
            this.curData = (DataObject)((List)collection).get(0);
        }
        collection = this.HContext.allInstances();
        if (this.HContext.allInstances().size() > 0 && this.curData == null) {
            this.curData = (DataObject)((List)collection).get(0);
        }
        this.CContext.addLookupListener((LookupListener)this);
        this.CCContext.addLookupListener((LookupListener)this);
        this.HContext.addLookupListener((LookupListener)this);
        this.setNewContent(this.curData);
    }

    public synchronized void panelDeactivated() {
        this.CContext.removeLookupListener((LookupListener)this);
        this.CCContext.removeLookupListener((LookupListener)this);
        this.HContext.removeLookupListener((LookupListener)this);
        this.CContext = null;
        this.CCContext = null;
        this.HContext = null;
        this.detachFromModel(this.curModel);
        this.curModel = null;
        this.curData = null;
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        CndDataObject cndDataObject;
        Collection collection = ((Lookup.Result)lookupEvent.getSource()).allInstances();
        if (!collection.isEmpty() && !(cndDataObject = (CndDataObject)collection.iterator().next()).equals(this.curData)) {
            this.detachFromModel(this.curModel);
            this.curData = cndDataObject;
            this.setNewContent((DataObject)cndDataObject);
        }
    }

    public Lookup getLookup() {
        return null;
    }

    public void busyStart() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NavigatorComponent.this.getPanelUI().setBusyState(true);
                }
            });
        }
    }

    public void busyEnd() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NavigatorComponent.this.getPanelUI().setBusyState(false);
                }
            });
        }
    }

    public void newContentReady() {
        this.getPanelUI().newContentReady();
    }

    public void itemsChanged(ItemEvent itemEvent) {
    }

    public void itemsCleared(ItemEvent itemEvent) {
        this.getPanelUI().getContent().repaint();
    }

    private void setNewContent(final DataObject dataObject) {
        final NavigatorPanelUI navigatorPanelUI = this.getPanelUI();
        CsmModelAccessor.getModel().enqueue(new Runnable(){

            public void run() {
                NavigatorComponent.this.setNewContentImpl(dataObject, navigatorPanelUI);
            }
        }, (CharSequence)"Updating QuickNavigator Content");
    }

    private void setNewContentImpl(DataObject dataObject, NavigatorPanelUI navigatorPanelUI) {
        this.curModel = new NavigatorModel(dataObject, navigatorPanelUI, this);
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this.curModel);
        CsmListeners.getDefault().addModelListener((CsmModelListener)this.curModel);
        navigatorPanelUI.getContent().setModel(this.curModel);
        try {
            this.curModel.addBusyListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.curModel.addNotify();
    }

    private void detachFromModel(NavigatorModel navigatorModel) {
        if (navigatorModel != null) {
            CsmListeners.getDefault().removeProgressListener((CsmProgressListener)navigatorModel);
            CsmListeners.getDefault().removeModelListener((CsmModelListener)navigatorModel);
            navigatorModel.removeBusyListener(this);
            navigatorModel.removeNotify();
        }
    }

    private NavigatorPanelUI getPanelUI() {
        if (this.panelUI == null) {
            this.panelUI = new NavigatorPanelUI();
        }
        return this.panelUI;
    }
}

