/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"ThreadGroup"})
public class RubyThreadGroup
extends RubyObject {
    private Map<Integer, IRubyObject> rubyThreadList = new HashMap<Integer, IRubyObject>();
    private boolean enclosed = false;

    public static RubyClass createThreadGroupClass(Ruby runtime) {
        RubyClass threadGroupClass = runtime.defineClass("ThreadGroup", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setThreadGroup(threadGroupClass);
        threadGroupClass.defineAnnotatedMethods(RubyThreadGroup.class);
        RubyThreadGroup defaultThreadGroup = new RubyThreadGroup(runtime, threadGroupClass);
        runtime.setDefaultThreadGroup(defaultThreadGroup);
        threadGroupClass.defineConstant("Default", defaultThreadGroup);
        return threadGroupClass;
    }

    @JRubyMethod(name={"new"}, frame=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv, Block block) {
        return new RubyThreadGroup(recv.getRuntime(), (RubyClass)recv);
    }

    @JRubyMethod(name={"add"}, required=1, frame=true)
    public synchronized IRubyObject add(IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw this.getRuntime().newTypeError(rubyThread, this.getRuntime().getThread());
        }
        if (this.isFrozen()) {
            throw this.getRuntime().newTypeError("can't add to frozen ThreadGroup");
        }
        RubyThread thread = (RubyThread)rubyThread;
        if (thread.alive_p().isTrue()) {
            this.addDirectly(thread);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirectly(RubyThread rubyThread) {
        RubyThread rubyThread2 = rubyThread;
        synchronized (rubyThread2) {
            IRubyObject oldGroup = rubyThread.group();
            if (oldGroup != this.getRuntime().getNil()) {
                RubyThreadGroup threadGroup = (RubyThreadGroup)oldGroup;
                threadGroup.rubyThreadList.remove(new Integer(System.identityHashCode(rubyThread)));
            }
            rubyThread.setThreadGroup(this);
            this.rubyThreadList.put(new Integer(System.identityHashCode(rubyThread)), rubyThread);
        }
    }

    public synchronized void remove(RubyThread rubyThread) {
        rubyThread.setThreadGroup(null);
        this.rubyThreadList.remove(new Integer(System.identityHashCode(rubyThread)));
    }

    @JRubyMethod(name={"enclose"}, frame=true)
    public IRubyObject enclose(Block block) {
        this.enclosed = true;
        return this;
    }

    @JRubyMethod(name={"enclosed?"}, frame=true)
    public IRubyObject enclosed_p(Block block) {
        return new RubyBoolean(this.getRuntime(), this.enclosed);
    }

    @JRubyMethod(name={"list"}, frame=true)
    public synchronized IRubyObject list(Block block) {
        return this.getRuntime().newArrayNoCopy(this.rubyThreadList.values().toArray(new IRubyObject[this.rubyThreadList.size()]));
    }

    private RubyThreadGroup(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }
}

