/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescueNode
extends Node {
    private final Node bodyNode;
    private final RescueBodyNode rescueNode;
    private final Node elseNode;

    public RescueNode(ISourcePosition position, Node bodyNode, RescueBodyNode rescueNode, Node elseNode) {
        super(position, NodeType.RESCUENODE);
        this.bodyNode = bodyNode;
        this.rescueNode = rescueNode;
        this.elseNode = elseNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitRescueNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public RescueBodyNode getRescueNode() {
        return this.rescueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.rescueNode, this.bodyNode, this.elseNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        while (true) {
            IRubyObject globalExceptionState = runtime.getGlobalVariables().get("$!");
            boolean anotherExceptionRaised = false;
            try {
                IRubyObject iRubyObject = this.executeBody(runtime, context, self, aBlock);
                return iRubyObject;
            }
            catch (RaiseException raiseJump) {
                try {
                    IRubyObject iRubyObject = this.handleException(runtime, context, self, aBlock, raiseJump);
                    return iRubyObject;
                }
                catch (JumpException.RetryJump rj) {
                    continue;
                }
                catch (RaiseException je) {
                    anotherExceptionRaised = true;
                    throw je;
                }
            }
            finally {
                if (anotherExceptionRaised) continue;
                runtime.getGlobalVariables().set("$!", globalExceptionState);
                continue;
            }
            break;
        }
    }

    private IRubyObject handleException(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock, RaiseException raiseJump) {
        RubyException raisedException = raiseJump.getException();
        runtime.getGlobalVariables().set("$!", raisedException);
        for (RescueBodyNode cRescueNode = this.rescueNode; cRescueNode != null; cRescueNode = cRescueNode.getOptRescueNode()) {
            IRubyObject[] exceptions = this.getExceptions(cRescueNode, runtime, context, self, aBlock);
            if (!RuntimeHelpers.isExceptionHandled(raisedException, exceptions, runtime, context, self).isTrue()) continue;
            return cRescueNode.interpret(runtime, context, self, aBlock);
        }
        throw raiseJump;
    }

    private IRubyObject executeBody(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.bodyNode == null) {
            return runtime.getNil();
        }
        IRubyObject result = this.bodyNode.interpret(runtime, context, self, aBlock);
        if (this.elseNode != null) {
            if (this.rescueNode == null) {
                runtime.getWarnings().warn(IRubyWarnings.ID.ELSE_WITHOUT_RESCUE, this.elseNode.getPosition(), "else without rescue is useless", new Object[0]);
            }
            result = this.elseNode.interpret(runtime, context, self, aBlock);
        }
        return result;
    }

    private IRubyObject[] getExceptions(RescueBodyNode cRescueNode, Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        Node exceptionNodes = cRescueNode.getExceptionNodes();
        IRubyObject[] exceptions = exceptionNodes == null ? new IRubyObject[]{runtime.getStandardError()} : ASTInterpreter.setupArgs(runtime, context, exceptionNodes, self, aBlock);
        return exceptions;
    }
}

