/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUtil {
    public static final RubyConverter RUBY_BOOLEAN_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            return rubyObject.isTrue();
        }
    };
    public static final RubyConverter RUBY_BYTE_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_i")) {
                return new Byte((byte)((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Byte(0);
        }
    };
    public static final RubyConverter RUBY_SHORT_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_i")) {
                return new Short((short)((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Short(0);
        }
    };
    public static final RubyConverter RUBY_INTEGER_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_i")) {
                return new Integer((int)((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Integer(0);
        }
    };
    public static final RubyConverter RUBY_LONG_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_i")) {
                return new Long(((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Long(0L);
        }
    };
    public static final RubyConverter RUBY_FLOAT_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_f")) {
                return new Float((float)((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_F, "to_f")).getDoubleValue());
            }
            return new Float(0.0);
        }
    };
    public static final RubyConverter RUBY_DOUBLE_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_f")) {
                return new Double(((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_F, "to_f")).getDoubleValue());
            }
            return new Double(0.0);
        }
    };
    public static final Map<Class, RubyConverter> RUBY_CONVERTERS = new HashMap<Class, RubyConverter>();
    public static final JavaConverter JAVA_DEFAULT_CONVERTER;
    public static final JavaConverter JAVA_BOOLEAN_CONVERTER;
    public static final JavaConverter JAVA_FLOAT_CONVERTER;
    public static final JavaConverter JAVA_DOUBLE_CONVERTER;
    public static final JavaConverter JAVA_CHAR_CONVERTER;
    public static final JavaConverter JAVA_BYTE_CONVERTER;
    public static final JavaConverter JAVA_SHORT_CONVERTER;
    public static final JavaConverter JAVA_INT_CONVERTER;
    public static final JavaConverter JAVA_LONG_CONVERTER;
    public static final JavaConverter JAVA_STRING_CONVERTER;
    public static final JavaConverter BYTELIST_CONVERTER;
    public static final JavaConverter JAVA_BIGINTEGER_CONVERTER;
    private static final Map<Class, JavaConverter> JAVA_CONVERTERS;

    public static Object convertRubyToJava(IRubyObject rubyObject) {
        return JavaUtil.convertRubyToJava(rubyObject, null);
    }

    public static Object convertRubyToJava(IRubyObject rubyObject, Class javaClass) {
        if (rubyObject == null || rubyObject.isNil()) {
            return null;
        }
        ThreadContext context = rubyObject.getRuntime().getCurrentContext();
        if (rubyObject.respondsTo("java_object")) {
            rubyObject = rubyObject.callMethod(context, "java_object");
        }
        if (rubyObject.respondsTo("to_java_object")) {
            rubyObject = rubyObject.callMethod(context, "to_java_object");
        }
        if (rubyObject instanceof JavaObject) {
            Object value = ((JavaObject)rubyObject).getValue();
            return JavaUtil.convertArgument(rubyObject.getRuntime(), value, value.getClass());
        }
        if (javaClass == Object.class || javaClass == null) {
            javaClass = rubyObject.getJavaClass();
        }
        if (javaClass.isInstance(rubyObject)) {
            return rubyObject;
        }
        if (javaClass.isPrimitive()) {
            RubyConverter converter = RUBY_CONVERTERS.get(javaClass);
            if (converter != null) {
                return converter.convert(context, rubyObject);
            }
            String s = ((RubyString)rubyObject.callMethod(context, MethodIndex.TO_S, "to_s")).toString();
            if (s.length() > 0) {
                return new Character(s.charAt(0));
            }
            return new Character('\u0000');
        }
        if (javaClass == String.class) {
            RubyString rubyString = (RubyString)rubyObject.callMethod(context, MethodIndex.TO_S, "to_s");
            ByteList bytes = rubyString.getByteList();
            try {
                return new String(bytes.unsafeBytes(), bytes.begin(), bytes.length(), "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                return new String(bytes.unsafeBytes(), bytes.begin(), bytes.length());
            }
        }
        if (javaClass == ByteList.class) {
            return rubyObject.convertToString().getByteList();
        }
        if (javaClass == BigInteger.class) {
            if (rubyObject instanceof RubyBignum) {
                return ((RubyBignum)rubyObject).getValue();
            }
            if (rubyObject instanceof RubyNumeric) {
                return BigInteger.valueOf(((RubyNumeric)rubyObject).getLongValue());
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyNumeric rubyNumeric = (RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_F, "to_f");
                return BigInteger.valueOf(rubyNumeric.getLongValue());
            }
        } else if (javaClass == BigDecimal.class && !(rubyObject instanceof JavaObject) && rubyObject.respondsTo("to_f")) {
            double double_value = ((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_F, "to_f")).getDoubleValue();
            return new BigDecimal(double_value);
        }
        try {
            return ((JavaObject)rubyObject).getValue();
        }
        catch (ClassCastException ex) {
            if (rubyObject.getRuntime().getDebug().isTrue()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static IRubyObject[] convertJavaArrayToRuby(Ruby runtime, Object[] objects) {
        IRubyObject[] rubyObjects = new IRubyObject[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            rubyObjects[i] = JavaUtil.convertJavaToRuby(runtime, objects[i]);
        }
        return rubyObjects;
    }

    public static JavaConverter getJavaConverter(Class clazz) {
        JavaConverter converter = JAVA_CONVERTERS.get(clazz);
        if (converter == null) {
            converter = JAVA_DEFAULT_CONVERTER;
        }
        return converter;
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, Object object) {
        if (object == null) {
            return runtime.getNil();
        }
        return JavaUtil.convertJavaToRuby(runtime, object, object.getClass());
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, Object object, Class javaClass) {
        return JavaUtil.getJavaConverter(javaClass).convert(runtime, object);
    }

    public static IRubyObject convertJavaToUsableRubyObject(Ruby runtime, Object object) {
        if (object == null) {
            return runtime.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        JavaConverter converter = JAVA_CONVERTERS.get(object.getClass());
        if (converter == null || converter == JAVA_DEFAULT_CONVERTER) {
            return Java.getInstance(runtime, object);
        }
        return converter.convert(runtime, object);
    }

    public static Class<?> primitiveToWrapper(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Void.TYPE) {
                return Void.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
        }
        return type;
    }

    public static Object convertArgument(Ruby runtime, Object argument, Class<?> parameterType) {
        RubyObject rubyObject;
        if (argument == null) {
            if (parameterType.isPrimitive()) {
                throw runtime.newTypeError("primitives do not accept null");
            }
            return null;
        }
        if (argument instanceof JavaObject && (argument = ((JavaObject)argument).getValue()) == null) {
            return null;
        }
        Class<?> type = JavaUtil.primitiveToWrapper(parameterType);
        if (type == Void.class) {
            return null;
        }
        if (argument instanceof Number) {
            Number number = (Number)argument;
            if (type == Long.class) {
                return new Long(number.longValue());
            }
            if (type == Integer.class) {
                return new Integer(number.intValue());
            }
            if (type == Byte.class) {
                return new Byte(number.byteValue());
            }
            if (type == Character.class) {
                return new Character((char)number.intValue());
            }
            if (type == Double.class) {
                return new Double(number.doubleValue());
            }
            if (type == Float.class) {
                return new Float(number.floatValue());
            }
            if (type == Short.class) {
                return new Short(number.shortValue());
            }
        }
        if (JavaUtil.isDuckTypeConvertable(argument.getClass(), parameterType) && !(rubyObject = (RubyObject)argument).respondsTo("java_object")) {
            RubyModule javaUtilities = runtime.getJavaSupport().getJavaUtilitiesModule();
            IRubyObject javaInterfaceModule = Java.get_interface_module(javaUtilities, JavaClass.get(runtime, parameterType));
            if (!((RubyModule)javaInterfaceModule).isInstance(rubyObject)) {
                rubyObject.extend(new IRubyObject[]{javaInterfaceModule});
            }
            ThreadContext context = runtime.getCurrentContext();
            if (rubyObject instanceof RubyProc) {
                rubyObject.instance_eval(context, runtime.newString("extend Proc::CatchAll"), Block.NULL_BLOCK);
            }
            JavaObject jo = (JavaObject)rubyObject.instance_eval(context, runtime.newString("send :__jcreate_meta!"), Block.NULL_BLOCK);
            return jo.getValue();
        }
        return argument;
    }

    public static boolean isDuckTypeConvertable(Class providedArgumentType, Class parameterType) {
        return parameterType.isInterface() && !parameterType.isAssignableFrom(providedArgumentType) && RubyObject.class.isAssignableFrom(providedArgumentType);
    }

    static {
        RUBY_CONVERTERS.put(Boolean.class, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Boolean.TYPE, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Byte.class, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Byte.TYPE, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Short.class, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Short.TYPE, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Integer.class, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Integer.TYPE, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Long.class, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Long.TYPE, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Float.class, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Float.TYPE, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Double.class, RUBY_DOUBLE_CONVERTER);
        RUBY_CONVERTERS.put(Double.TYPE, RUBY_DOUBLE_CONVERTER);
        JAVA_DEFAULT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                if (object instanceof IRubyObject) {
                    return (IRubyObject)object;
                }
                return JavaObject.wrap(runtime, object);
            }
        };
        JAVA_BOOLEAN_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyBoolean.newBoolean(runtime, (Boolean)object);
            }
        };
        JAVA_FLOAT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFloat.newFloat(runtime, ((Float)object).doubleValue());
            }
        };
        JAVA_DOUBLE_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFloat.newFloat(runtime, (Double)object);
            }
        };
        JAVA_CHAR_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Character)object).charValue());
            }
        };
        JAVA_BYTE_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Byte)object).byteValue());
            }
        };
        JAVA_SHORT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Short)object).shortValue());
            }
        };
        JAVA_INT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Integer)object).intValue());
            }
        };
        JAVA_LONG_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, (Long)object);
            }
        };
        JAVA_STRING_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyString.newUnicodeString(runtime, (String)object);
            }
        };
        BYTELIST_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyString.newString(runtime, (ByteList)object);
            }
        };
        JAVA_BIGINTEGER_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyBignum.newBignum(runtime, (BigInteger)object);
            }
        };
        JAVA_CONVERTERS = new HashMap<Class, JavaConverter>();
        JAVA_CONVERTERS.put(Byte.class, JAVA_BYTE_CONVERTER);
        JAVA_CONVERTERS.put(Byte.TYPE, JAVA_BYTE_CONVERTER);
        JAVA_CONVERTERS.put(Short.class, JAVA_SHORT_CONVERTER);
        JAVA_CONVERTERS.put(Short.TYPE, JAVA_SHORT_CONVERTER);
        JAVA_CONVERTERS.put(Character.class, JAVA_CHAR_CONVERTER);
        JAVA_CONVERTERS.put(Character.TYPE, JAVA_CHAR_CONVERTER);
        JAVA_CONVERTERS.put(Integer.class, JAVA_INT_CONVERTER);
        JAVA_CONVERTERS.put(Integer.TYPE, JAVA_INT_CONVERTER);
        JAVA_CONVERTERS.put(Long.class, JAVA_LONG_CONVERTER);
        JAVA_CONVERTERS.put(Long.TYPE, JAVA_LONG_CONVERTER);
        JAVA_CONVERTERS.put(Float.class, JAVA_FLOAT_CONVERTER);
        JAVA_CONVERTERS.put(Float.TYPE, JAVA_FLOAT_CONVERTER);
        JAVA_CONVERTERS.put(Double.class, JAVA_DOUBLE_CONVERTER);
        JAVA_CONVERTERS.put(Double.TYPE, JAVA_DOUBLE_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.class, JAVA_BOOLEAN_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.TYPE, JAVA_BOOLEAN_CONVERTER);
        JAVA_CONVERTERS.put(String.class, JAVA_STRING_CONVERTER);
        JAVA_CONVERTERS.put(ByteList.class, BYTELIST_CONVERTER);
        JAVA_CONVERTERS.put(BigInteger.class, JAVA_BIGINTEGER_CONVERTER);
    }

    public static interface JavaConverter {
        public IRubyObject convert(Ruby var1, Object var2);
    }

    public static interface RubyConverter {
        public Object convert(ThreadContext var1, IRubyObject var2);
    }
}

