/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class FiberLibrary
implements Library {
    public void load(Ruby runtime, boolean wrap) throws IOException {
        Fiber.setup(runtime);
    }

    @JRubyClass(name={"Fiber"})
    public static class Fiber
    extends RubyObject {
        private Block block;
        private Object yieldLock = new Object();
        private IRubyObject result;
        private Thread thread;
        private boolean alive = false;

        @JRubyMethod(name={"new"}, rest=true, meta=true, frame=true, compat=CompatVersion.RUBY1_9)
        public static Fiber newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
            Fiber result = new Fiber(recv.getRuntime(), (RubyClass)recv);
            result.initialize(args, block);
            return result;
        }

        public IRubyObject initialize(IRubyObject[] args, Block block) {
            this.block = block;
            final Ruby runtime = this.getRuntime();
            this.result = runtime.getNil();
            this.thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = Fiber.this.yieldLock;
                    synchronized (object) {
                        Fiber.this.alive = true;
                        ThreadContext context = runtime.getCurrentContext();
                        context.setFiber(Fiber.this);
                        try {
                            Fiber.this.result = Fiber.this.block.yield(runtime.getCurrentContext(), Fiber.this.result, null, null, true);
                        }
                        finally {
                            Fiber.this.yieldLock.notify();
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            return this;
        }

        public Fiber(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public static void setup(Ruby runtime) {
            RubyClass cFiber = runtime.defineClass("Fiber", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            cFiber.defineAnnotatedMethods(Fiber.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject resume(IRubyObject[] args) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.result = this.getRuntime().newArrayNoCopyLight(args);
                if (!this.alive) {
                    this.thread.start();
                    this.yieldLock.wait();
                } else {
                    this.yieldLock.notify();
                    this.yieldLock.wait();
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject transfer(IRubyObject[] args) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.yieldLock.notify();
                this.yieldLock.wait();
            }
            return this.result;
        }

        @JRubyMethod(name={"alive?"}, compat=CompatVersion.RUBY1_9)
        public IRubyObject alive_p() {
            return this.getRuntime().newBoolean(this.alive);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
        public static IRubyObject yield(IRubyObject recv, IRubyObject value) throws InterruptedException {
            Fiber fiber = recv.getRuntime().getCurrentContext().getFiber();
            fiber.result = value;
            Object object = fiber.yieldLock;
            synchronized (object) {
                fiber.yieldLock.notify();
                fiber.yieldLock.wait();
            }
            return recv.getRuntime().getNil();
        }

        @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
        public static IRubyObject current(IRubyObject recv) {
            return recv.getRuntime().getCurrentContext().getFiber();
        }
    }
}

