/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.RubyArray;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ThreeVarDynamicScope;

public class FourVarDynamicScope
extends ThreeVarDynamicScope {
    private static final int SIZE = 4;
    private static final String SIZE_ERROR = "FourVarDynamicScope only supports scopes with four variables";
    private static final String GROW_ERROR = "FourVarDynamicScope cannot be grown; use ManyVarsDynamicScope";
    protected IRubyObject variableValueThree;

    public FourVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public FourVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 4) {
            throw new RuntimeException(GROW_ERROR);
        }
    }

    public DynamicScope cloneScope() {
        return new ThreeVarDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo, this.variableValueThree};
    }

    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        assert (offset < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
            case 2: {
                return this.variableValueTwo;
            }
            case 3: {
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject getValueOrNil(int offset, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset, nil);
    }

    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        assert (offset < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = nil;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = nil;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
            case 2: {
                if (this.variableValueTwo == null) {
                    this.variableValueTwo = nil;
                    return this.variableValueTwo;
                }
                return this.variableValueTwo;
            }
            case 3: {
                if (this.variableValueThree == null) {
                    this.variableValueThree = nil;
                    return this.variableValueThree;
                }
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueThree == null) {
            this.variableValueThree = nil;
            return this.variableValueThree;
        }
        return this.variableValueThree;
    }

    public IRubyObject setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(offset, value, depth - 1);
        }
        assert (offset < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset) {
            case 0: {
                this.variableValueZero = value;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = value;
                return this.variableValueTwo;
            }
            case 3: {
                this.variableValueThree = value;
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject setValueDepthZero(IRubyObject value, int offset) {
        assert (offset < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset) {
            case 0: {
                this.variableValueZero = value;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = value;
                return this.variableValueTwo;
            }
            case 3: {
                this.variableValueThree = value;
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    public IRubyObject setValueThreeDepthZero(IRubyObject value) {
        this.variableValueThree = value;
        return this.variableValueThree;
    }

    public void setArgValues(IRubyObject[] values, int size) {
        assert (size <= 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (size) {
            case 4: {
                this.variableValueThree = values[3];
            }
            case 3: {
                this.variableValueTwo = values[2];
            }
            case 2: {
                this.variableValueOne = values[1];
            }
            case 1: {
                this.variableValueZero = values[0];
            }
        }
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs <= 4) : "FourVarDynamicScope only supports scopes with four variables";
        if (this.staticScope.getRestArg() < 0) {
            switch (totalArgs) {
                case 0: {
                    return IRubyObject.NULL_ARRAY;
                }
                case 1: {
                    return new IRubyObject[]{this.variableValueZero};
                }
                case 2: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
                }
                case 3: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo};
                }
                case 4: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo, this.variableValueThree};
                }
            }
            throw new RuntimeException("more args requested than available variables");
        }
        IRubyObject restArg = this.getValue(this.staticScope.getRestArg(), 0);
        assert (restArg != null);
        RubyArray splattedArgs = RuntimeHelpers.splatValue(restArg);
        IRubyObject[] argValues = new IRubyObject[totalArgs + splattedArgs.size()];
        System.arraycopy(splattedArgs.toJavaArray(), 0, argValues, totalArgs, splattedArgs.size());
        switch (totalArgs) {
            case 4: {
                argValues[3] = this.variableValueThree;
            }
            case 3: {
                argValues[2] = this.variableValueTwo;
            }
            case 2: {
                argValues[1] = this.variableValueOne;
            }
            case 1: {
                argValues[0] = this.variableValueZero;
            }
        }
        return argValues;
    }

    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] names = this.staticScope.getVariables();
        buf.append(names[0]).append("=");
        if (this.variableValueZero == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueZero);
        }
        buf.append(",");
        if (this.variableValueOne == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueOne);
        }
        buf.append(",");
        if (this.variableValueTwo == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueTwo);
        }
        buf.append(",");
        if (this.variableValueThree == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueThree);
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

