/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.samples.bundled.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.visualweb.samples.bundled.wizard.SamplesWebWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class SamplesWebVisualPanel
extends JPanel
implements DocumentListener {
    private SamplesWebWizardPanel panel;
    private JButton browseButton;
    private JSeparator jSeparator1;
    private JTextField projectFolderField;
    private JLabel projectFolderLabel;
    private JTextField projectLocationField;
    private JLabel projectLocationLabel;
    private JTextField projectNameField;
    private JLabel projectNameLabel;
    private JCheckBox setAsMainProject;

    public SamplesWebVisualPanel(SamplesWebWizardPanel samplesWebWizardPanel) {
        this.initComponents();
        this.panel = samplesWebWizardPanel;
        this.projectNameField.getDocument().addDocumentListener(this);
        this.projectLocationField.getDocument().addDocumentListener(this);
    }

    public String getName() {
        return "Name and Location";
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    private void update(DocumentEvent documentEvent) {
        Document document;
        if (this.projectNameField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameField.getText());
        }
        if (this.projectLocationField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("projdir", null, this.projectLocationField.getText());
        }
        if ((document = documentEvent.getDocument()) == this.projectNameField.getDocument() || document == this.projectLocationField.getDocument()) {
            String string = this.projectNameField.getText();
            String string2 = this.projectLocationField.getText();
            this.projectFolderField.setText(string2 + File.separatorChar + string);
        }
        this.panel.fireChangeEvent();
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            string = "Sample";
        }
        this.projectNameField.setText(string);
        this.projectNameField.selectAll();
        Boolean bl = (Boolean)wizardDescriptor.getProperty("setMainProject");
        this.setAsMainProject.setSelected(bl);
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameField.getText().trim();
        wizardDescriptor.putProperty("name", (Object)string);
        String string2 = this.projectFolderField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(string2));
        boolean bl = this.setAsMainProject.isSelected();
        wizardDescriptor.putProperty("setMainProject", (Object)bl);
    }

    public String getProjectName() {
        return this.projectNameField.getText();
    }

    public String getProjectFolder() {
        return this.projectFolderField.getText();
    }

    public String getProjectLocation() {
        return this.projectLocationField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationField = new JTextField();
        this.projectFolderLabel = new JLabel();
        this.projectFolderField = new JTextField();
        this.browseButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setAsMainProject = new JCheckBox();
        this.projectNameLabel.setDisplayedMnemonic(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_NWP1_ProjectName_LabelMnemonic").charAt(0));
        this.projectNameLabel.setLabelFor(this.projectNameField);
        this.projectNameLabel.setText(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_NWP1_ProjectName_Label"));
        this.projectLocationLabel.setDisplayedMnemonic(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_NWP1_ProjectLocation_LabelMnemonic").charAt(0));
        this.projectLocationLabel.setLabelFor(this.projectLocationField);
        this.projectLocationLabel.setText(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        this.projectFolderLabel.setDisplayedMnemonic(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_NWP1_CreatedProjectFolder_LabelMnemonic").charAt(0));
        this.projectFolderLabel.setLabelFor(this.projectFolderField);
        this.projectFolderLabel.setText(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_NWP1_CreatedProjectFolder_Label"));
        this.projectFolderField.setEnabled(false);
        this.browseButton.setMnemonic(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_NWP1_Browse_LabelMnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SamplesWebVisualPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.setAsMainProject.setMnemonic(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_NWP1_SetAsMain_CheckBoxMnemonic").charAt(0));
        this.setAsMainProject.setSelected(true);
        this.setAsMainProject.setText(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_NWP1_SetAsMain_CheckBox"));
        this.setAsMainProject.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setAsMainProject.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 482, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel).add((Component)this.projectFolderLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameField, -1, 287, Short.MAX_VALUE).add((Component)this.projectFolderField, -1, 287, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.projectLocationField, -1, 287, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.browseButton)).add((Component)this.setAsMainProject)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.browseButton).add((Component)this.projectLocationField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectFolderLabel).add((Component)this.projectFolderField, -2, -1, -2)).add(17, 17, 17).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.setAsMainProject).addContainerGap(176, Short.MAX_VALUE)));
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSN_projectNameLabel"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSD_projectNameLabel"));
        this.projectNameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSN_projectNameTextfield"));
        this.projectNameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSD_projectNameTextfield"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSN_projectLocationLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSD_projectLocationLabel"));
        this.projectLocationField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSN_projectLocationTextfield"));
        this.projectLocationField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSD_projectLocationTextfield"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSN_createdFolderLabel"));
        this.projectFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSD_createdFolderLabel"));
        this.projectFolderField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSN_createdFolderTextfield"));
        this.projectFolderField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSD_createdFolderTextfield"));
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSD_browseButton"));
        this.setAsMainProject.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSN_SetAsMain_CheckBox"));
        this.setAsMainProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"ACSD_SetAsMain_CheckBox"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(SamplesWebVisualPanel.class, (String)"LBL_TITLE"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocationField.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = jFileChooser.getSelectedFile();
            this.projectLocationField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
        this.panel.fireChangeEvent();
    }
}

