/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsParser;
import org.netbeans.modules.javascript.editing.NbUtilities;
import org.netbeans.modules.javascript.editing.ParseTreeWalker;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.embedding.JsModel;
import org.openide.util.Exceptions;

public class JsParseResult
extends ParserResult {
    JsModel model;
    private ParserResult.AstTreeNode ast;
    private Node rootNode;
    private String source;
    private OffsetRange sanitizedRange = OffsetRange.NONE;
    private String sanitizedContents;
    private JsAnalyzer.AnalysisResult analysisResult;
    private JsParser.Sanitize sanitized;
    private boolean commentsAdded;
    private IncrementalParse incrementalParse;
    private VariableVisitor variableVisitor;

    public JsParseResult(JsParser jsParser, ParserFile parserFile, Node node, ParserResult.AstTreeNode astTreeNode) {
        super((Parser)jsParser, parserFile, "text/javascript");
        this.rootNode = node;
        this.ast = astTreeNode;
    }

    public ParserResult.AstTreeNode getAst() {
        return this.ast;
    }

    public void setAst(ParserResult.AstTreeNode astTreeNode) {
        this.ast = astTreeNode;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public OffsetRange getSanitizedRange() {
        return this.sanitizedRange;
    }

    public String getSanitizedContents() {
        return this.sanitizedContents;
    }

    void setSanitized(JsParser.Sanitize sanitize, OffsetRange offsetRange, String string) {
        this.sanitized = sanitize;
        this.sanitizedRange = offsetRange;
        this.sanitizedContents = string;
    }

    public JsParser.Sanitize getSanitized() {
        return this.sanitized;
    }

    public void setStructure(@NonNull JsAnalyzer.AnalysisResult analysisResult) {
        this.analysisResult = analysisResult;
    }

    @NonNull
    public JsAnalyzer.AnalysisResult getStructure() {
        if (this.analysisResult == null) {
            CompilationInfo compilationInfo = this.getInfo();
            if (compilationInfo == null) {
                try {
                    compilationInfo = new CompilationInfo(this.getFile().getFileObject()){
                        private Document doc;

                        public Collection<? extends ParserResult> getEmbeddedResults(String string) {
                            if (string.equals("text/javascript")) {
                                return Collections.singleton(JsParseResult.this);
                            }
                            return null;
                        }

                        public ParserResult getEmbeddedResult(String string, int n) {
                            if (string.equals("text/javascript")) {
                                return JsParseResult.this;
                            }
                            return null;
                        }

                        public String getText() {
                            return JsParseResult.this.getSource();
                        }

                        public Index getIndex(String string) {
                            return null;
                        }

                        public List<Error> getErrors() {
                            return Collections.emptyList();
                        }

                        public Document getDocument() {
                            if (this.doc == null) {
                                this.doc = NbUtilities.getDocument(this.getFileObject(), true);
                            }
                            return this.doc;
                        }
                    };
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            this.analysisResult = JsAnalyzer.analyze(this, compilationInfo);
        }
        return this.analysisResult;
    }

    public boolean isCommentsAdded() {
        return this.commentsAdded;
    }

    public void setCommentsAdded(boolean bl) {
        this.commentsAdded = bl;
    }

    public VariableVisitor getVariableVisitor() {
        if (this.variableVisitor == null) {
            if (this.incrementalParse != null && this.incrementalParse.previousResult.variableVisitor != null) {
                this.variableVisitor = this.incrementalParse.previousResult.variableVisitor;
                this.variableVisitor.incrementalEdits(this.incrementalParse);
            } else {
                Node node = this.getRootNode();
                assert (node != null) : "Attempted to get variable visitor for broken source";
                this.variableVisitor = new VariableVisitor();
                new ParseTreeWalker(this.variableVisitor).walk(node);
            }
        }
        return this.variableVisitor;
    }

    public String toString() {
        return "JsParseResult(file=" + this.getFile() + ",rootnode=" + this.rootNode + ")";
    }

    public void setIncrementalParse(IncrementalParse incrementalParse) {
        this.incrementalParse = incrementalParse;
    }

    public IncrementalParse getIncrementalParse() {
        return this.incrementalParse;
    }

    public static class IncrementalParse {
        public FunctionNode oldFunction;
        public FunctionNode newFunction;
        public int incrementalOffset;
        public int incrementalOffsetLimit;
        public int incrementalOffsetDelta;
        public JsParseResult previousResult;

        public IncrementalParse(FunctionNode functionNode, FunctionNode functionNode2, int n, int n2, int n3, JsParseResult jsParseResult) {
            this.oldFunction = functionNode;
            this.newFunction = functionNode2;
            this.incrementalOffset = n;
            this.incrementalOffsetLimit = n2;
            this.incrementalOffsetDelta = n3;
            this.previousResult = jsParseResult;
        }
    }
}

