/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Node;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.embedding.JsModel;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsSemanticAnalyzer
implements SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        if (jsParseResult == null) {
            return;
        }
        Node node = jsParseResult.getRootNode();
        if (node == null) {
            return;
        }
        this.semanticHighlights = this.analyzeFullTree(compilationInfo, jsParseResult, node);
    }

    Map<OffsetRange, Set<ColoringAttributes>> analyzeFullTree(CompilationInfo compilationInfo, JsParseResult jsParseResult, Node node) {
        Object object2;
        ArrayList<Node> arrayList;
        boolean bl;
        Node node222;
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        Object object3 = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        Collection<Node> collection = variableVisitor.getUnusedVars();
        for (Node node222 : collection) {
            OffsetRange offsetRange = AstUtilities.getNameRange(node222);
            object3.put(offsetRange, ColoringAttributes.UNUSED_SET);
        }
        List<Node> list = variableVisitor.getGlobalVars(false);
        node222 = jsParseResult.getSanitizedRange();
        boolean bl2 = bl = node222 != OffsetRange.NONE && node222.getLength() == 1;
        if (bl && (arrayList = jsParseResult.getSanitizedContents()) != null && ((String)((Object)arrayList)).length() > 0 && !Character.isLetter(((String)((Object)arrayList)).charAt(0))) {
            bl = false;
        }
        arrayList = list.iterator();
        while (arrayList.hasNext()) {
            object2 = (Node)arrayList.next();
            String object4 = object2.getString();
            if (JsModel.isGeneratedIdentifier(object4)) continue;
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)object2);
            if (bl && offsetRange.getEnd() == node222.getStart()) continue;
            if (Character.isUpperCase(object4.charAt(0))) {
                object3.put(offsetRange, ColoringAttributes.CLASS_SET);
                continue;
            }
            object3.put(offsetRange, ColoringAttributes.GLOBAL_SET);
        }
        arrayList = new ArrayList<Node>();
        AstUtilities.addNodesByType(node, new int[]{47, 156, 157}, arrayList);
        for (Node node2 : arrayList) {
            OffsetRange offsetRange = AstUtilities.getNameRange(node2);
            if (node2.isStringNode() && JsModel.isGeneratedIdentifier(node2.getString())) continue;
            int n = node2.getType();
            if (n == 47) {
                object3.put((OffsetRange)offsetRange, (Set<ColoringAttributes>)ColoringAttributes.REGEXP_SET);
                continue;
            }
            if (n == 157) {
                if (!AstUtilities.isLabelledFunction(node2)) continue;
                object3.put((OffsetRange)offsetRange, (Set<ColoringAttributes>)ColoringAttributes.METHOD_SET);
                continue;
            }
            assert (n == 156);
            object3.put((OffsetRange)offsetRange, (Set<ColoringAttributes>)ColoringAttributes.METHOD_SET);
        }
        if (this.isCancelled()) {
            return null;
        }
        if (object3.size() > 0) {
            if (jsParseResult.getTranslatedSource() != null) {
                object2 = new HashMap(2 * object3.size());
                for (Map.Entry entry : object3.entrySet()) {
                    OffsetRange offsetRange = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)entry.getKey());
                    if (offsetRange == OffsetRange.NONE) continue;
                    object2.put(offsetRange, entry.getValue());
                }
                object3 = object2;
            }
            return object3;
        }
        return null;
    }
}

