/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EnumSet;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.netbeans.modules.javascript.editing.options.JsOptionsController;
import org.netbeans.modules.javascript.editing.spi.JSPreferencesPanel;
import org.openide.util.NbBundle;

public class BrowserPanel
extends JSPreferencesPanel {
    private final String[] VERSION_LABELS = new String[]{NbBundle.getMessage(BrowserPanel.class, (String)"LanguageDefault"), "1.0", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.7", "1.8"};
    private final BROWSER_VERSION[] FF_VERSION_LABELS = new BROWSER_VERSION[]{BROWSER_VERSION.FF1, BROWSER_VERSION.FF2, BROWSER_VERSION.FF3};
    private final BROWSER_VERSION[] IE_VERSION_LABELS = new BROWSER_VERSION[]{BROWSER_VERSION.IE5, BROWSER_VERSION.IE6, BROWSER_VERSION.IE7};
    private final BROWSER_VERSION[] SAFARI_VERSION_LABELS = new BROWSER_VERSION[]{BROWSER_VERSION.SAFARI2, BROWSER_VERSION.SAFARI3};
    private final int[] VERSION_VALUES = new int[]{0, 100, 110, 120, 130, 140, 150, 160, 170, 180};
    private final JsOptionsController controller;
    private JLabel browserLabel;
    private JComboBox cbFFVersion;
    private JComboBox cbIEVersion;
    private JComboBox cbSafariVersion;
    private JCheckBox ffCb;
    private ButtonGroup firefoxGroup;
    private JCheckBox ieCb;
    private ButtonGroup ieGroup;
    private JComboBox languageCombo;
    private JLabel languageLabel;
    private JCheckBox operaCb;
    private JCheckBox safariCb;
    private ButtonGroup safariGroup;

    public BrowserPanel(JsOptionsController jsOptionsController) {
        this.controller = jsOptionsController;
        this.initComponents();
    }

    public void load() {
        SupportedBrowsers supportedBrowsers = SupportedBrowsers.getInstance();
        if (supportedBrowsers.isSupported(BrowserVersion.FF1)) {
            this.cbFFVersion.setSelectedItem((Object)BROWSER_VERSION.FF1);
            this.ffCb.setSelected(true);
        } else if (supportedBrowsers.isSupported(BrowserVersion.FF2)) {
            this.cbFFVersion.setSelectedItem((Object)BROWSER_VERSION.FF2);
            this.ffCb.setSelected(true);
        } else if (supportedBrowsers.isSupported(BrowserVersion.FF3)) {
            this.cbFFVersion.setSelectedItem((Object)BROWSER_VERSION.FF3);
            this.ffCb.setSelected(true);
        } else {
            this.ffCb.setSelected(false);
        }
        if (supportedBrowsers.isSupported(BrowserVersion.IE55)) {
            this.cbIEVersion.setSelectedItem((Object)BROWSER_VERSION.IE5);
            this.ieCb.setSelected(true);
        } else if (supportedBrowsers.isSupported(BrowserVersion.IE6)) {
            this.cbIEVersion.setSelectedItem((Object)BROWSER_VERSION.IE6);
            this.ieCb.setSelected(true);
        } else if (supportedBrowsers.isSupported(BrowserVersion.IE7)) {
            this.cbIEVersion.setSelectedItem((Object)BROWSER_VERSION.IE7);
            this.ieCb.setSelected(true);
        } else {
            this.ieCb.setSelected(false);
        }
        if (supportedBrowsers.isSupported(BrowserVersion.SAFARI2)) {
            this.cbSafariVersion.setSelectedItem((Object)BROWSER_VERSION.SAFARI2);
            this.safariCb.setSelected(true);
        } else if (supportedBrowsers.isSupported(BrowserVersion.SAFARI3)) {
            this.cbSafariVersion.setSelectedItem((Object)BROWSER_VERSION.SAFARI3);
            this.safariCb.setSelected(true);
        } else {
            this.safariCb.setSelected(false);
        }
        this.operaCb.setSelected(supportedBrowsers.isSupported(BrowserVersion.OPERA));
        int n = supportedBrowsers.getLanguageVersion();
        int n2 = this.VERSION_VALUES.length;
        for (int i = 0; i < n2; ++i) {
            if (this.VERSION_VALUES[i] != n) continue;
            this.languageCombo.setSelectedIndex(i);
            break;
        }
    }

    public void store() {
        EnumSet<BrowserVersion> enumSet = EnumSet.noneOf(BrowserVersion.class);
        if (this.ieCb.isSelected()) {
            assert (this.cbIEVersion.getSelectedItem() instanceof BROWSER_VERSION);
            switch ((BROWSER_VERSION)((Object)this.cbIEVersion.getSelectedItem())) {
                case IE5: {
                    enumSet.add(BrowserVersion.IE55);
                }
                case IE6: {
                    enumSet.add(BrowserVersion.IE6);
                }
                case IE7: {
                    enumSet.add(BrowserVersion.IE7);
                }
            }
        }
        if (this.ffCb.isSelected()) {
            assert (this.cbFFVersion.getSelectedItem() instanceof BROWSER_VERSION);
            switch ((BROWSER_VERSION)((Object)this.cbFFVersion.getSelectedItem())) {
                case FF1: {
                    enumSet.add(BrowserVersion.FF1);
                }
                case FF2: {
                    enumSet.add(BrowserVersion.FF2);
                }
                case FF3: {
                    enumSet.add(BrowserVersion.FF3);
                }
            }
        }
        if (this.safariCb.isSelected()) {
            assert (this.cbSafariVersion.getSelectedItem() instanceof BROWSER_VERSION);
            switch ((BROWSER_VERSION)((Object)this.cbSafariVersion.getSelectedItem())) {
                case SAFARI2: {
                    enumSet.add(BrowserVersion.SAFARI2);
                }
                case SAFARI3: {
                    enumSet.add(BrowserVersion.SAFARI3);
                }
            }
        }
        if (this.operaCb.isSelected()) {
            enumSet.add(BrowserVersion.OPERA);
        }
        SupportedBrowsers supportedBrowsers = SupportedBrowsers.getInstance();
        JsOptionsController.Accessor.DEFAULT.setSupported(supportedBrowsers, enumSet);
        JsOptionsController.Accessor.DEFAULT.setLanguageVersion(supportedBrowsers, this.VERSION_VALUES[this.languageCombo.getSelectedIndex()]);
    }

    private ComboBoxModel getVersionModel() {
        return new DefaultComboBoxModel<String>(this.VERSION_LABELS);
    }

    private ComboBoxModel getFFVersionModel() {
        return new DefaultComboBoxModel<BROWSER_VERSION>(this.FF_VERSION_LABELS);
    }

    private ComboBoxModel getSafariVersionModel() {
        return new DefaultComboBoxModel<BROWSER_VERSION>(this.SAFARI_VERSION_LABELS);
    }

    private ComboBoxModel getIEVersionModel() {
        return new DefaultComboBoxModel<BROWSER_VERSION>(this.IE_VERSION_LABELS);
    }

    private void initComponents() {
        this.firefoxGroup = new ButtonGroup();
        this.ieGroup = new ButtonGroup();
        this.safariGroup = new ButtonGroup();
        this.browserLabel = new JLabel();
        this.ffCb = new JCheckBox();
        this.ieCb = new JCheckBox();
        this.safariCb = new JCheckBox();
        this.operaCb = new JCheckBox();
        this.languageLabel = new JLabel();
        this.languageCombo = new JComboBox();
        this.cbSafariVersion = new JComboBox();
        this.cbIEVersion = new JComboBox();
        this.cbFFVersion = new JComboBox();
        this.browserLabel.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.browserLabel.text"));
        this.ffCb.setSelected(true);
        this.ffCb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ffCb.text"));
        this.ffCb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.ieCb.setSelected(true);
        this.ieCb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ieCb.text"));
        this.ieCb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.safariCb.setSelected(true);
        this.safariCb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.safariCb.text"));
        this.safariCb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.operaCb.setSelected(true);
        this.operaCb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.operaCb.text"));
        this.operaCb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.languageLabel.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.languageLabel.text"));
        this.languageCombo.setModel(this.getVersionModel());
        this.languageCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.cbSafariVersion.setModel(this.getSafariVersionModel());
        this.cbIEVersion.setModel(this.getIEVersionModel());
        this.cbFFVersion.setModel(this.getFFVersionModel());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.browserLabel).add((Component)this.languageLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.ffCb).add((Component)this.ieCb).add((Component)this.safariCb).add((Component)this.operaCb)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbSafariVersion, -2, -1, -2).add((Component)this.cbFFVersion, -2, -1, -2).add((Component)this.cbIEVersion, -2, -1, -2))).add((Component)this.languageCombo, -2, -1, -2)).addContainerGap(185, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.browserLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.ffCb).add((Component)this.cbFFVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.ieCb).add((Component)this.cbIEVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.safariCb).add((Component)this.cbSafariVersion, -2, -1, -2)).addPreferredGap(0).add((Component)this.operaCb))).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.languageLabel).add((Component)this.languageCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void itemCheckChange(ItemEvent itemEvent) {
        this.controller.changed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BROWSER_VERSION {
        FF1(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ff1Rb.text")),
        FF2(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ff2Rb.text")),
        FF3(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ff3Rb.text")),
        SAFARI2(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.sf2Rb.text")),
        SAFARI3(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.sf3Rb.text")),
        IE5(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ie5Rb.text")),
        IE6(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ie6Rb.text")),
        IE7(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ie7Rb.text"));

        String string;

        private BROWSER_VERSION(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

