/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.text.MessageFormat;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.actions.GarbageCollectAction;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

class HeapView
extends JComponent {
    private static final boolean AUTOMATIC_REFRESH = System.getProperty("org.netbeans.log.startup") == null;
    private static final int STYLE_DEFAULT = 0;
    private static final int STYLE_OVERLAY = 1;
    private static final int TICK = 1500;
    private static final int HEAP_GROW_ANIMATE_TIME = 1000;
    private static final int BORDER_W = 2;
    private static final int BORDER_H = 4;
    private static final Color[] GRID_COLORS = new Color[]{new Color(14933967), new Color(15197395), new Color(14342086), new Color(14671051), new Color(13881279), new Color(14144451), new Color(13552314), new Color(13683900)};
    private static final Color BORDER1_COLOR = new Color(10920597);
    private static final Color BORDER2_COLOR = new Color(12631213);
    private static final Color MIN_TICK_COLOR = new Color(13096621);
    private static final Color MAX_TICK_COLOR = new Color(6380815);
    private static final Color TEXT_BLUR_COLOR = Color.WHITE;
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Color BACKGROUND1_COLOR = new Color(13683900);
    private static final Color BACKGROUND2_COLOR = new Color(15394775);
    private static final int KERNEL_SIZE = 3;
    private static final float BLUR_FACTOR = 0.1f;
    private static final int SHIFT_X = 0;
    private static final int SHIFT_Y = 1;
    private final ConvolveOp blur;
    private final MessageFormat format;
    private boolean showDropShadow;
    private int tickStyle;
    private boolean showText;
    private float[] graph;
    private int graphIndex;
    private boolean graphFilled;
    private long lastTotal;
    private Timer updateTimer;
    private Image bgImage;
    private int cachedWidth;
    private int cachedHeight;
    private BufferedImage textImage;
    private BufferedImage dropShadowImage;
    private HeapGrowTimer heapGrowTimer;
    private int maxTextWidth;
    private String heapSizeText;
    private Image tickGradientImage;
    private BufferedImage gridOverlayImage;
    private static final String TICK_STYLE = "tickStyle";
    private static final String SHOW_TEXT = "showText";
    private static final String DROP_SHADOW = "dropShadow";
    private boolean containsMouse;
    private boolean cachedBorderVaild;

    public HeapView() {
        int n = 3;
        int n2 = 3;
        float f = 0.1f;
        float[] fArray = new float[n * n2];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f;
        }
        this.blur = new ConvolveOp(new Kernel(n, n2, fArray));
        this.format = new MessageFormat("{0,choice,0#{0,number,0.0}|999<{0,number,0}}/{1,choice,0#{1,number,0.0}|999<{1,number,0}}MB");
        this.heapSizeText = "";
        this.enableEvents(16L);
        this.setToolTipText(NbBundle.getMessage(GarbageCollectAction.class, (String)"CTL_GC"));
        this.updateUI();
    }

    public boolean isOpaque() {
        return true;
    }

    public void updateUI() {
        Font font = new JLabel().getFont();
        font = new Font(font.getName(), 1, font.getSize());
        this.setFont(font);
        this.revalidate();
        this.repaint();
    }

    public void setTickStyle(int n) {
        this.prefs().putInt(TICK_STYLE, n);
        this.repaint();
    }

    public int getTickStyle() {
        return this.prefs().getInt(TICK_STYLE, 1);
    }

    public void setShowText(boolean bl) {
        this.prefs().putBoolean(SHOW_TEXT, bl);
        this.repaint();
    }

    public boolean getShowText() {
        return this.prefs().getBoolean(SHOW_TEXT, true);
    }

    public void setShowDropShadow(boolean bl) {
        this.prefs().putBoolean(DROP_SHADOW, bl);
        this.repaint();
    }

    public boolean getShowDropShadow() {
        return this.prefs().getBoolean(DROP_SHADOW, true);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateTextWidth();
    }

    Dimension heapViewPreferredSize() {
        Dimension dimension = new Dimension(this.maxTextWidth + 8, this.getFontMetrics(this.getFont()).getHeight() + 8);
        return dimension;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(HeapView.class);
    }

    private void updateTextWidth() {
        String string = this.format.format(new Object[]{new Float(999.9f), new Float(999.9f)});
        this.maxTextWidth = this.getFontMetrics(this.getFont()).stringWidth(string) + 4;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getID() == 504) {
                this.containsMouse = true;
                this.cachedBorderVaild = false;
                this.repaint();
            } else if (mouseEvent.getID() == 505) {
                this.containsMouse = false;
                this.cachedBorderVaild = false;
                this.repaint();
            }
        }
        if (mouseEvent.getID() == 500 && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
            ((GarbageCollectAction)GarbageCollectAction.get(GarbageCollectAction.class)).performAction();
        }
    }

    private void showPopup(int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(HeapView.class, (String)"LBL_ShowText"));
        jCheckBoxMenuItem.setSelected(this.getShowText());
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapView.this.setShowText(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(HeapView.class, (String)"LBL_DropShadow"));
        jCheckBoxMenuItem.setSelected(this.getShowDropShadow());
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapView.this.setShowDropShadow(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(HeapView.class, (String)"LBL_OverlayGrid"));
        jCheckBoxMenuItem.setSelected(this.getTickStyle() == 1);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected() ? 1 : 0;
                HeapView.this.setTickStyle(n);
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem);
        jPopupMenu.show(this, n, n2);
    }

    private int getGraphStartIndex() {
        if (this.graphFilled) {
            return this.graphIndex;
        }
        return 0;
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n - 2 > 0 && n2 - 4 > 0) {
            this.startTimerIfNecessary();
            this.updateCacheIfNecessary(n, n2);
            this.paintCachedBackground(graphics2D, n, n2);
            graphics.translate(1, 2);
            if (this.containsMouse) {
                graphics.clipRect(1, 0, n - 4, n2 - 4);
            } else {
                graphics.clipRect(0, 0, n - 2, n2 - 4);
            }
            int n3 = n - 2;
            int n4 = n2 - 4;
            if (this.heapGrowTimer != null) {
                Composite composite = ((Graphics2D)graphics).getComposite();
                float f = 1.0f - this.heapGrowTimer.getPercent();
                ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, f));
                graphics.drawImage(this.heapGrowTimer.image, 0, 0, null);
                ((Graphics2D)graphics).setComposite(composite);
            }
            this.paintTicks(graphics2D, n3, n4);
            if (this.getTickStyle() == 1) {
                graphics2D.drawImage(this.getGridOverlayImage(), 0, 0, null);
            }
            if (this.getShowText()) {
                if (this.getShowDropShadow()) {
                    this.paintDropShadowText(graphics, n3, n4);
                } else {
                    graphics.setColor(Color.WHITE);
                    this.paintText(graphics, n3, n4);
                }
            }
            graphics.translate(-1, -2);
        } else {
            this.stopTimerIfNecessary();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
    }

    private void paintTicks(Graphics2D graphics2D, int n, int n2) {
        if (this.graphIndex > 0 || this.graphFilled) {
            int n3 = this.getGraphStartIndex();
            int n4 = 0;
            if (!this.graphFilled) {
                n4 = n - this.graphIndex;
            }
            float f = this.graph[n3];
            n3 = (n3 + 1) % this.graph.length;
            while (n3 != this.graphIndex) {
                f = Math.min(f, this.graph[n3]);
                n3 = (n3 + 1) % this.graph.length;
            }
            int n5 = (int)(f * (float)n2);
            if (n5 > 0) {
                graphics2D.drawImage(this.tickGradientImage, n4, n2 - n5, n, n2, n4, n2 - n5, n, n2, null);
            }
            n3 = this.getGraphStartIndex();
            do {
                int n6;
                if ((n6 = (int)(this.graph[n3] * (float)n2)) > n5) {
                    graphics2D.drawImage(this.tickGradientImage, n4, n2 - n6, n4 + 1, n2 - n5, n4, n2 - n6, n4 + 1, n2 - n5, null);
                }
                n3 = (n3 + 1) % this.graph.length;
                ++n4;
            } while (n3 != this.graphIndex);
        }
    }

    private void paintText(Graphics graphics, int n, int n2) {
        graphics.setFont(this.getFont());
        String string = this.getHeapSizeText();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        graphics.drawString(string, (n - this.maxTextWidth) / 2 + (this.maxTextWidth - n3), n2 / 2 + fontMetrics.getAscent() / 2);
    }

    private void paintDropShadowText(Graphics graphics, int n, int n2) {
        if (this.textImage == null) {
            this.textImage = new BufferedImage(n, n2, 2);
            this.dropShadowImage = new BufferedImage(n, n2, 2);
        }
        Graphics2D graphics2D = this.textImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setColor(TEXT_BLUR_COLOR);
        this.paintText(graphics2D, n, n2);
        graphics2D.dispose();
        Graphics2D graphics2D2 = this.dropShadowImage.createGraphics();
        graphics2D2.setComposite(AlphaComposite.Clear);
        graphics2D2.fillRect(0, 0, n, n2);
        graphics2D2.setComposite(AlphaComposite.SrcOver);
        graphics2D2.drawImage(this.textImage, this.blur, 0, 1);
        graphics2D2.setColor(TEXT_COLOR);
        graphics2D2.setFont(this.getFont());
        this.paintText(graphics2D2, n, n2);
        graphics2D2.dispose();
        graphics.drawImage(this.dropShadowImage, 0, 0, null);
    }

    private String getHeapSizeText() {
        return this.heapSizeText;
    }

    private void paintGridOverlay(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4 = GRID_COLORS.length / 2;
        int n5 = (n2 - n4 - 1) / n4;
        int n6 = 13683900;
        int n7 = 15394775;
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(n6 >> 16 & 0xFF, n6 >> 8 & 0xFF, n6 & 0xFF, 48), 0.0f, n2, new Color(n7 >> 16 & 0xFF, n7 >> 8 & 0xFF, n7 & 0xFF, 64)));
        for (n3 = 0; n3 < n; n3 += n5 + 1) {
            graphics2D.fillRect(n3, 0, 1, n2);
        }
        for (n3 = n2 - n5 - 1; n3 >= 0; n3 -= n5 + 1) {
            graphics2D.fillRect(0, n3, n, 1);
        }
    }

    private void paintCachedBackground(Graphics2D graphics2D, int n, int n2) {
        if (this.bgImage != null) {
            graphics2D.drawImage(this.bgImage, 0, 0, null);
        }
    }

    private void paintBackgroundTiles(Graphics2D graphics2D, int n, int n2) {
        graphics2D.translate(1, 2);
        n -= 2;
        int n3 = GRID_COLORS.length / 2;
        int n4 = ((n2 -= 4) - n3 - 1) / n3;
        for (int i = 0; i < n3; ++i) {
            int n5 = i;
            int n6 = n2 - n4 * (i + 1) - i;
            int n7 = 1;
            graphics2D.setPaint(new GradientPaint(0.0f, n6, GRID_COLORS[n5 * 2], 0.0f, n6 + n4 - 1, GRID_COLORS[n5 * 2 + 1]));
            while (n7 < n) {
                int n8 = Math.min(n, n7 + n4);
                graphics2D.fillRect(n7, n6, n8 - n7, n4);
                n7 = n8 + 1;
            }
            n6 += n4 + 1;
        }
        graphics2D.translate(-1, -2);
    }

    private void paintBackground(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, BACKGROUND1_COLOR, 0.0f, n2, BACKGROUND2_COLOR));
        graphics2D.fillRect(0, 0, n, n2);
    }

    private void paintBorder(Graphics graphics, int n, int n2) {
        if (this.containsMouse) {
            graphics.setColor(Color.WHITE);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
            graphics.drawRect(1, 1, n - 3, n2 - 3);
        } else {
            graphics.setColor(BORDER1_COLOR);
            graphics.drawRect(0, 0, n - 1, n2 - 2);
            graphics.setColor(BORDER2_COLOR);
            graphics.fillRect(1, 1, n - 2, 1);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, n2 - 1, n, 1);
        }
    }

    private void updateCacheIfNecessary(int n, int n2) {
        if (this.cachedWidth != n || this.cachedHeight != n2 || !this.cachedBorderVaild) {
            this.cachedWidth = n;
            this.cachedHeight = n2;
            this.cachedBorderVaild = true;
            this.updateCache(n, n2);
        }
    }

    private Image getGridOverlayImage() {
        if (this.gridOverlayImage == null) {
            this.gridOverlayImage = new BufferedImage(this.getInnerWidth(), this.getInnerHeight(), 2);
            Graphics2D graphics2D = this.gridOverlayImage.createGraphics();
            this.paintGridOverlay(graphics2D, this.getInnerWidth(), this.getInnerHeight());
            graphics2D.dispose();
        }
        return this.gridOverlayImage;
    }

    private void updateCache(int n, int n2) {
        this.disposeImages();
        this.textImage = new BufferedImage(n, n2, 2);
        this.dropShadowImage = new BufferedImage(n, n2, 2);
        this.bgImage = this.createImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)this.bgImage.getGraphics();
        this.paintBackground(graphics2D, n, n2);
        this.paintBackgroundTiles(graphics2D, n, n2);
        this.paintBorder(graphics2D, n, n2);
        graphics2D.dispose();
        n2 -= 4;
        if (this.graph == null || this.graph.length != (n -= 2)) {
            this.graph = new float[n];
            this.graphFilled = false;
            this.graphIndex = 0;
        }
        GradientPaint gradientPaint = new GradientPaint(0.0f, n2, MIN_TICK_COLOR, n, 0.0f, MAX_TICK_COLOR);
        this.tickGradientImage = this.createImage(n, n2);
        graphics2D = (Graphics2D)this.tickGradientImage.getGraphics();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        if (this.gridOverlayImage != null) {
            this.gridOverlayImage.flush();
            this.gridOverlayImage = null;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.stopTimerIfNecessary();
    }

    private void startTimerIfNecessary() {
        if (!AUTOMATIC_REFRESH) {
            return;
        }
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(1500, new ActionHandler());
            this.updateTimer.setRepeats(true);
            this.updateTimer.start();
        }
    }

    private void stopTimerIfNecessary() {
        if (this.updateTimer != null) {
            this.graph = null;
            this.graphFilled = false;
            this.updateTimer.stop();
            this.updateTimer = null;
            this.lastTotal = 0L;
            this.disposeImages();
            this.cachedHeight = -1;
            this.cachedHeight = -1;
            if (this.heapGrowTimer != null) {
                this.heapGrowTimer.stop();
                this.heapGrowTimer = null;
            }
        }
    }

    private void disposeImages() {
        if (this.bgImage != null) {
            this.bgImage.flush();
            this.bgImage = null;
        }
        if (this.textImage != null) {
            this.textImage.flush();
            this.textImage = null;
        }
        if (this.dropShadowImage != null) {
            this.dropShadowImage.flush();
            this.dropShadowImage = null;
        }
        if (this.tickGradientImage != null) {
            this.tickGradientImage.flush();
            this.tickGradientImage = null;
        }
        if (this.gridOverlayImage != null) {
            this.gridOverlayImage.flush();
            this.gridOverlayImage = null;
        }
    }

    private void update() {
        if (!this.isShowing()) {
            this.stopTimerIfNecessary();
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        if (l != this.lastTotal) {
            if (this.lastTotal != 0L) {
                this.startHeapAnimate();
                int n = this.getGraphStartIndex();
                do {
                    this.graph[n] = (float)((double)this.graph[n] * (double)this.lastTotal / (double)l);
                } while ((n = (n + 1) % this.graph.length) != this.graphIndex);
            }
            this.lastTotal = l;
        }
        if (this.heapGrowTimer == null) {
            long l2 = l - runtime.freeMemory();
            this.graph[this.graphIndex] = (float)((double)l2 / (double)l);
            this.graphIndex = (this.graphIndex + 1) % this.graph.length;
            if (this.graphIndex == 0) {
                this.graphFilled = true;
            }
            this.heapSizeText = this.format.format(new Object[]{new Double((double)l2 / 1024.0 / 1024.0), new Double((double)l / 1024.0 / 1024.0)});
        }
        this.repaint();
    }

    private void startHeapAnimate() {
        if (this.heapGrowTimer == null) {
            this.heapGrowTimer = new HeapGrowTimer();
            this.heapGrowTimer.start();
        }
    }

    private void stopHeapAnimate() {
        if (this.heapGrowTimer != null) {
            this.heapGrowTimer.stop();
            this.heapGrowTimer = null;
        }
    }

    private int getInnerWidth() {
        return this.getWidth() - 2;
    }

    private int getInnerHeight() {
        return this.getHeight() - 4;
    }

    private final class HeapGrowTimer
    extends Timer {
        private final long startTime;
        private float percent;
        BufferedImage image;

        HeapGrowTimer() {
            super(30, null);
            this.setRepeats(true);
            this.startTime = System.currentTimeMillis();
            this.percent = 0.0f;
            int n = HeapView.this.getWidth() - 2;
            int n2 = HeapView.this.getHeight() - 4;
            this.image = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = this.image.createGraphics();
            HeapView.this.paintTicks(graphics2D, n, n2);
            graphics2D.dispose();
        }

        public float getPercent() {
            return this.percent;
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            long l = System.currentTimeMillis();
            long l2 = Math.max(0L, l - this.startTime);
            if (l2 > 1000L) {
                HeapView.this.stopHeapAnimate();
            } else {
                this.percent = (float)l2 / 1000.0f;
                HeapView.this.repaint();
            }
        }
    }

    private final class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HeapView.this.update();
        }
    }
}

