/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdlextui.property;

import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.api.property.ExtensibilityElementPropertyAdapter;
import org.netbeans.modules.xml.wsdl.ui.api.property.StringAttributeProperty;
import org.netbeans.modules.xml.wsdl.ui.spi.ExtensibilityElementConfigurator;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapAddressConfigurator
extends ExtensibilityElementConfigurator {
    private static QName addressQName = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    private static QName[] supportedQNames = new QName[]{addressQName};

    public Collection<QName> getSupportedQNames() {
        return Arrays.asList(supportedQNames);
    }

    public Node.Property getProperty(ExtensibilityElement extensibilityElement, QName qName, String string) {
        StringAttributeProperty stringAttributeProperty = null;
        if (addressQName.equals(qName) && "location".equals(string)) {
            ExtensibilityElementPropertyAdapter extensibilityElementPropertyAdapter = new ExtensibilityElementPropertyAdapter(extensibilityElement, string, this.generateAddressLocation(extensibilityElement));
            try {
                stringAttributeProperty = new StringAttributeProperty(extensibilityElementPropertyAdapter, String.class, "getValue", "setValue");
                stringAttributeProperty.setName("location");
                stringAttributeProperty.setDisplayName(NbBundle.getMessage(SoapAddressConfigurator.class, (String)"PROP_NAME_ADDRESS_LOCATION"));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
        }
        return stringAttributeProperty;
    }

    public String getDisplayAttributeName(ExtensibilityElement extensibilityElement, QName qName) {
        return null;
    }

    public String generateAddressLocation(ExtensibilityElement extensibilityElement) {
        Project project;
        WSDLModel wSDLModel = extensibilityElement.getModel();
        ModelSource modelSource = wSDLModel.getModelSource();
        FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
        if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
            Port port = (Port)extensibilityElement.getParent();
            return "http://localhost:${HttpDefaultPort}/" + project.getProjectDirectory().getName() + "/" + fileObject.getName() + "/" + port.getName();
        }
        return "http://localhost:${HttpDefaultPort}/service";
    }

    public String getAttributeUniqueValuePrefix(ExtensibilityElement extensibilityElement, QName qName, String string) {
        return null;
    }

    public String getDefaultValue(ExtensibilityElement extensibilityElement, QName qName, String string) {
        if (string.equals("location")) {
            return this.generateAddressLocation(extensibilityElement);
        }
        return null;
    }

    public String getTypeDisplayName(ExtensibilityElement extensibilityElement, QName qName) {
        return NbBundle.getMessage(SoapAddressConfigurator.class, (String)"LBL_SoapAddress_TypeDisplayName");
    }
}

