/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdlextui.template;

import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPFault;

public class SoapBindingPostProcessor {
    private String mWsdlTargetNamespace;
    private static final String SOAP_LOCATION_PPREFIX = "http://localhost:${HttpDefaultPort}/";

    public void postProcess(String string, Port port) {
        this.mWsdlTargetNamespace = string;
        List list = port.getExtensibilityElements();
        for (ExtensibilityElement extensibilityElement : list) {
            if (!(extensibilityElement instanceof SOAPAddress)) continue;
            SOAPAddress sOAPAddress = (SOAPAddress)extensibilityElement;
            WSDLComponent wSDLComponent = (WSDLComponent)port.getParent();
            if (wSDLComponent == null || !(wSDLComponent instanceof Service)) continue;
            Service service = (Service)wSDLComponent;
            sOAPAddress.setLocation(SOAP_LOCATION_PPREFIX + service.getName() + "/" + port.getName());
        }
    }

    public void postProcess(String string, Binding binding) {
        SOAPBinding sOAPBinding;
        this.mWsdlTargetNamespace = string;
        SOAPBinding.Style style = null;
        List list = binding.getExtensibilityElements();
        for (Object object : list) {
            if (!(object instanceof SOAPBinding)) continue;
            sOAPBinding = (SOAPBinding)object;
            style = sOAPBinding.getStyle();
            break;
        }
        if (style != null) {
            Object object;
            object = binding.getBindingOperations();
            sOAPBinding = object.iterator();
            while (sOAPBinding.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)sOAPBinding.next();
                this.processBindingOperation(style, bindingOperation);
            }
        }
    }

    private void processBindingOperation(SOAPBinding.Style style, BindingOperation bindingOperation) {
        Collection collection;
        BindingOutput bindingOutput;
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput != null) {
            this.processBindingOperationInput(style, bindingInput);
        }
        if ((bindingOutput = bindingOperation.getBindingOutput()) != null) {
            this.processBindingOperationOutput(style, bindingOutput);
        }
        if ((collection = bindingOperation.getBindingFaults()) != null && !collection.isEmpty()) {
            for (BindingFault bindingFault : collection) {
                this.processBindingOperationFault(style, bindingFault);
            }
        }
    }

    private void processBindingOperationInput(SOAPBinding.Style style, BindingInput bindingInput) {
        if (style.equals((Object)SOAPBinding.Style.RPC)) {
            List list = bindingInput.getExtensibilityElements();
            for (ExtensibilityElement extensibilityElement : list) {
                if (!(extensibilityElement instanceof SOAPBody)) continue;
                SOAPBody sOAPBody = (SOAPBody)extensibilityElement;
                sOAPBody.setNamespace(this.mWsdlTargetNamespace);
            }
        }
    }

    private void processBindingOperationOutput(SOAPBinding.Style style, BindingOutput bindingOutput) {
        if (style.equals((Object)SOAPBinding.Style.RPC)) {
            List list = bindingOutput.getExtensibilityElements();
            for (ExtensibilityElement extensibilityElement : list) {
                if (!(extensibilityElement instanceof SOAPBody)) continue;
                SOAPBody sOAPBody = (SOAPBody)extensibilityElement;
                sOAPBody.setNamespace(this.mWsdlTargetNamespace);
            }
        }
    }

    private void processBindingOperationFault(SOAPBinding.Style style, BindingFault bindingFault) {
        List list = bindingFault.getExtensibilityElements();
        for (ExtensibilityElement extensibilityElement : list) {
            if (!(extensibilityElement instanceof SOAPFault)) continue;
            SOAPFault sOAPFault = (SOAPFault)extensibilityElement;
            sOAPFault.setName(bindingFault.getName());
            if (!style.equals((Object)SOAPBinding.Style.RPC)) continue;
            sOAPFault.setNamespace(this.mWsdlTargetNamespace);
        }
    }
}

