/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdlextui.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.xml.wsdl.bindingsupport.spi.ValidationInfo;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPMessageBase;
import org.netbeans.modules.xml.wsdlextui.template.StringAttribute;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapBindingValidator {
    private List<ValidationInfo> mVList = new ArrayList<ValidationInfo>();

    public List<ValidationInfo> validate(Binding binding) {
        SOAPBinding sOAPBinding;
        SOAPBinding.Style style = null;
        List list = binding.getExtensibilityElements();
        for (Object object : list) {
            if (!(object instanceof SOAPBinding)) continue;
            sOAPBinding = (SOAPBinding)object;
            style = sOAPBinding.getStyle();
            break;
        }
        if (style != null) {
            Object object;
            object = binding.getBindingOperations();
            sOAPBinding = object.iterator();
            while (sOAPBinding.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)sOAPBinding.next();
                this.processBindingOperation(style, bindingOperation);
            }
        }
        return this.mVList;
    }

    private void processBindingOperation(SOAPBinding.Style style, BindingOperation bindingOperation) {
        Collection collection;
        BindingOutput bindingOutput;
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput != null) {
            this.processBindingOperationInput(style, bindingInput);
        }
        if ((bindingOutput = bindingOperation.getBindingOutput()) != null) {
            this.processBindingOperationOutput(style, bindingOutput);
        }
        if ((collection = bindingOperation.getBindingFaults()) != null && !collection.isEmpty()) {
            for (BindingFault bindingFault : collection) {
                this.processBindingOperationFault(style, bindingFault);
            }
        }
    }

    private void processBindingOperationInput(SOAPBinding.Style style, BindingInput bindingInput) {
        List list = bindingInput.getExtensibilityElements();
        for (ExtensibilityElement extensibilityElement : list) {
            Reference reference;
            SOAPBody sOAPBody;
            SOAPMessageBase.Use use;
            if (!(extensibilityElement instanceof SOAPBody) || (use = (sOAPBody = (SOAPBody)extensibilityElement).getUse()) == null || (reference = bindingInput.getInput()) == null || reference.get() == null) continue;
            Input input = (Input)reference.get();
            NamedComponentReference namedComponentReference = input.getMessage();
            if (!use.equals((Object)SOAPMessageBase.Use.LITERAL)) continue;
            if (style.equals((Object)SOAPBinding.Style.DOCUMENT)) {
                this.processSoapBodyForDocumentLiteral((NamedComponentReference<Message>)namedComponentReference);
                continue;
            }
            if (!style.equals((Object)SOAPBinding.Style.RPC)) continue;
            this.processSoapBodyForRPCLiteral((NamedComponentReference<Message>)namedComponentReference);
        }
    }

    private void processBindingOperationOutput(SOAPBinding.Style style, BindingOutput bindingOutput) {
        if (style.equals((Object)SOAPBinding.Style.DOCUMENT)) {
            List list = bindingOutput.getExtensibilityElements();
            for (ExtensibilityElement extensibilityElement : list) {
                Reference reference;
                SOAPBody sOAPBody;
                SOAPMessageBase.Use use;
                if (!(extensibilityElement instanceof SOAPBody) || (use = (sOAPBody = (SOAPBody)extensibilityElement).getUse()) == null || (reference = bindingOutput.getOutput()) == null || reference.get() == null) continue;
                Output output = (Output)reference.get();
                NamedComponentReference namedComponentReference = output.getMessage();
                if (!use.equals((Object)SOAPMessageBase.Use.LITERAL)) continue;
                if (style.equals((Object)SOAPBinding.Style.DOCUMENT)) {
                    this.processSoapBodyForDocumentLiteral((NamedComponentReference<Message>)namedComponentReference);
                    continue;
                }
                if (!style.equals((Object)SOAPBinding.Style.RPC)) continue;
                this.processSoapBodyForRPCLiteral((NamedComponentReference<Message>)namedComponentReference);
            }
        }
    }

    private void processBindingOperationFault(SOAPBinding.Style style, BindingFault bindingFault) {
        if (style.equals((Object)SOAPBinding.Style.DOCUMENT)) {
            List list = bindingFault.getExtensibilityElements();
            for (ExtensibilityElement extensibilityElement : list) {
                Reference reference;
                SOAPBody sOAPBody;
                SOAPMessageBase.Use use;
                if (!(extensibilityElement instanceof SOAPBody) || (use = (sOAPBody = (SOAPBody)extensibilityElement).getUse()) == null || (reference = bindingFault.getFault()) == null || reference.get() == null) continue;
                Fault fault = (Fault)reference.get();
                NamedComponentReference namedComponentReference = fault.getMessage();
                if (!use.equals((Object)SOAPMessageBase.Use.LITERAL)) continue;
                if (style.equals((Object)SOAPBinding.Style.DOCUMENT)) {
                    this.processSoapBodyForDocumentLiteral((NamedComponentReference<Message>)namedComponentReference);
                    continue;
                }
                if (!style.equals((Object)SOAPBinding.Style.RPC)) continue;
                this.processSoapBodyForRPCLiteral((NamedComponentReference<Message>)namedComponentReference);
            }
        }
    }

    private void processSoapBodyForDocumentLiteral(NamedComponentReference<Message> namedComponentReference) {
        if (namedComponentReference != null && namedComponentReference.get() != null) {
            Message message = (Message)namedComponentReference.get();
            if (message.getParts().size() > 1) {
                String string = NbBundle.getMessage(SoapBindingValidator.class, (String)"LBL_doc_literal_R2210");
                ValidationInfo validationInfo = new ValidationInfo(ValidationInfo.ValidationType.ERROR, string);
                this.mVList.add(validationInfo);
            } else {
                Part part;
                String string;
                Collection collection = message.getParts();
                Iterator iterator = collection.iterator();
                if (iterator.hasNext() && (string = (part = (Part)iterator.next()).getAttribute((Attribute)new StringAttribute("type"))) != null && !string.trim().equals("")) {
                    String string2 = NbBundle.getMessage(SoapBindingValidator.class, (String)"LBL_doc_literal_R2204");
                    ValidationInfo validationInfo = new ValidationInfo(ValidationInfo.ValidationType.ERROR, string2);
                    this.mVList.add(validationInfo);
                }
            }
        }
    }

    private void processSoapBodyForRPCLiteral(NamedComponentReference<Message> namedComponentReference) {
        Part part;
        String string;
        Message message;
        Collection collection;
        Iterator iterator;
        if (namedComponentReference != null && namedComponentReference.get() != null && (iterator = (collection = (message = (Message)namedComponentReference.get()).getParts()).iterator()).hasNext() && (string = (part = (Part)iterator.next()).getAttribute((Attribute)new StringAttribute("element"))) != null && !string.trim().equals("")) {
            String string2 = NbBundle.getMessage(SoapBindingValidator.class, (String)"LBL_rpc_literal_R2203");
            ValidationInfo validationInfo = new ValidationInfo(ValidationInfo.ValidationType.ERROR, string2);
            this.mVList.add(validationInfo);
        }
    }
}

