/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.DeployOnSaveManager;
import org.netbeans.modules.j2ee.deployment.impl.ProgressObjectUtil;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.TargetServer;
import org.netbeans.modules.j2ee.deployment.impl.projects.DeploymentTargetImpl;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class Deployment {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(Deployment.class.getName());
    private static final WeakHashMap<J2eeModuleProvider, CompileOnSaveListener> COMPILE_LISTENERS = new WeakHashMap();
    private static boolean alsoStartTargets = true;
    private static Deployment instance = null;

    public static synchronized Deployment getDefault() {
        if (instance == null) {
            instance = new Deployment();
        }
        return instance;
    }

    private Deployment() {
    }

    public String deploy(J2eeModuleProvider j2eeModuleProvider, boolean bl, String string, String string2, boolean bl2) throws DeploymentException {
        return this.deploy(j2eeModuleProvider, bl, string, string2, bl2, null);
    }

    public String deploy(J2eeModuleProvider j2eeModuleProvider, boolean bl, String string, String string2, boolean bl2, Logger logger) throws DeploymentException {
        DeploymentTargetImpl deploymentTargetImpl = new DeploymentTargetImpl(j2eeModuleProvider, string);
        TargetModuleID[] targetModuleIDArray = null;
        J2eeModule j2eeModule = deploymentTargetImpl.getModule();
        String string3 = NbBundle.getMessage(Deployment.class, (String)"LBL_Deploying", (Object)j2eeModuleProvider.getDeploymentName());
        ProgressUI progressUI = new ProgressUI(string3, false, logger);
        try {
            Object object;
            ServerTarget[] serverTargetArray;
            JDBCDriverDeployer jDBCDriverDeployer;
            progressUI.start();
            ServerString serverString = deploymentTargetImpl.getServer();
            if (j2eeModule == null) {
                String string4 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoJ2eeModule");
                throw new DeploymentException(string4);
            }
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = serverString.getServerInstance();
            if (serverString == null || serverInstance == null) {
                String string5 = NbBundle.getMessage(Deployment.class, (String)"MSG_NoTargetServer");
                throw new DeploymentException(string5);
            }
            Set<Datasource> set = j2eeModuleProvider.getModuleDatasources();
            if (set != null && set.size() > 0 && (jDBCDriverDeployer = serverString.getServerInstance().getJDBCDriverDeployer()) != null && (serverTargetArray = serverInstance.getTargets()).length > 0 && jDBCDriverDeployer.supportsDeployJDBCDrivers((Target)(object = serverTargetArray[0].getTarget()))) {
                ProgressObject progressObject = jDBCDriverDeployer.deployJDBCDrivers((Target)object, set);
                ProgressObjectUtil.trackProgressObject(progressUI, progressObject, Long.MAX_VALUE);
            }
            boolean bl3 = false;
            serverTargetArray = new TargetServer(deploymentTargetImpl);
            if (alsoStartTargets || bl) {
                serverTargetArray.startTargets(bl, progressUI);
            } else {
                serverString.getServerInstance().start(progressUI);
            }
            j2eeModuleProvider.deployDatasources();
            Deployment.deployMessageDestinations(j2eeModuleProvider);
            targetModuleIDArray = serverTargetArray.deploy(progressUI, bl2);
            serverTargetArray.notifyIncrementalDeployment(targetModuleIDArray);
            if (serverTargetArray.supportsDeployOnSave((TargetModule[])targetModuleIDArray)) {
                DeployOnSaveManager.getDefault().notifyInitialDeployment(j2eeModuleProvider);
                Deployment.checkListening(j2eeModuleProvider);
            }
            if (targetModuleIDArray == null || targetModuleIDArray.length <= 0) {
                object = NbBundle.getMessage(Deployment.class, (String)"MSG_ModuleNotDeployed");
                throw new DeploymentException((String)object);
            }
            deploymentTargetImpl.setTargetModules((TargetModule[])targetModuleIDArray);
            object = deploymentTargetImpl.getClientUrl(string2);
            return object;
        }
        catch (Exception exception) {
            String string6 = NbBundle.getMessage(Deployment.class, (String)"MSG_DeployFailed", (Object)exception.getLocalizedMessage());
            java.util.logging.Logger.getLogger("global").log(Level.INFO, null, exception);
            throw new DeploymentException(string6, exception);
        }
        finally {
            if (progressUI != null) {
                progressUI.finish();
            }
        }
    }

    public void enableCompileOnSaveSupport(J2eeModuleProvider j2eeModuleProvider) {
        Deployment.startListening(j2eeModuleProvider);
    }

    public void disableCompileOnSaveSupport(J2eeModuleProvider j2eeModuleProvider) {
        Deployment.stopListening(j2eeModuleProvider);
    }

    private static void deployMessageDestinations(J2eeModuleProvider j2eeModuleProvider) throws ConfigurationException {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(j2eeModuleProvider.getServerInstanceID());
        if (serverInstance != null) {
            serverInstance.deployMessageDestinations(j2eeModuleProvider.getConfigSupport().getMessageDestinations());
        } else {
            java.util.logging.Logger.getLogger("global").log(Level.WARNING, "The message destinations cannot be deployed because the server instance cannot be found.");
        }
    }

    public String[] getServerInstanceIDs() {
        return InstanceProperties.getInstanceList();
    }

    public String[] getServerInstanceIDs(Object[] objectArray) {
        return this.getServerInstanceIDs(objectArray, null, null);
    }

    public String[] getServerInstanceIDs(Object[] objectArray, String string) {
        return this.getServerInstanceIDs(objectArray, string, null);
    }

    public String[] getServerInstanceIDs(Object[] objectArray, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getServerInstanceIDs();
        for (int i = 0; i < stringArray2.length; ++i) {
            Set set;
            J2eePlatform j2eePlatform = this.getJ2eePlatform(stringArray2[i]);
            if (j2eePlatform == null) continue;
            boolean bl = true;
            if (objectArray != null) {
                set = j2eePlatform.getSupportedModuleTypes();
                for (int j = 0; j < objectArray.length; ++j) {
                    if (set.contains(objectArray[j])) continue;
                    bl = false;
                }
            }
            if (bl && string != null) {
                set = j2eePlatform.getSupportedSpecVersions();
                bl = string.equals("1.3") ? set.contains("1.3") || set.contains("1.4") : set.contains(string);
            }
            if (bl && stringArray != null) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (j2eePlatform.isToolSupported(stringArray[j])) continue;
                    bl = false;
                }
            }
            if (!bl) continue;
            arrayList.add(stringArray2[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getServerInstanceDisplayName(String string) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance != null) {
            return serverInstance.getDisplayName();
        }
        return null;
    }

    public String getServerID(String string) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance != null) {
            return serverInstance.getServer().getShortName();
        }
        return null;
    }

    public String getDefaultServerInstanceID() {
        return null;
    }

    public boolean canFileDeploy(String string, J2eeModule j2eeModule) {
        boolean bl = false;
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (null != serverInstance) {
            IncrementalDeployment incrementalDeployment = serverInstance.getIncrementalDeployment();
            try {
                if (null != incrementalDeployment && null != j2eeModule.getContentDirectory()) {
                    bl = incrementalDeployment.canFileDeploy(null, j2eeModule);
                }
            }
            catch (IOException iOException) {
                java.util.logging.Logger.getLogger("global").log(Level.FINER, "", iOException);
            }
        }
        return bl;
    }

    public String[] getInstancesOfServer(String string) {
        Server server;
        if (string != null && (server = ServerRegistry.getInstance().getServer(string)) != null) {
            org.netbeans.modules.j2ee.deployment.impl.ServerInstance[] serverInstanceArray = ServerRegistry.getInstance().getServer(string).getInstances();
            String[] stringArray = new String[serverInstanceArray.length];
            for (int i = 0; i < serverInstanceArray.length; ++i) {
                stringArray[i] = serverInstanceArray[i].getUrl();
            }
            return stringArray;
        }
        return new String[0];
    }

    public ServerInstance getServerInstance(String string) {
        Parameters.notNull((CharSequence)"serverInstanceId", (Object)string);
        return new ServerInstance(string);
    }

    public String[] getServerIDs() {
        Collection collection = ServerRegistry.getInstance().getServers();
        String[] stringArray = new String[collection.size()];
        Iterator iterator = collection.iterator();
        for (int i = 0; i < collection.size(); ++i) {
            Server server = (Server)iterator.next();
            stringArray[i] = server.getShortName();
        }
        return stringArray;
    }

    public J2eePlatform getJ2eePlatform(String string) {
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance == null) {
            return null;
        }
        return J2eePlatform.create(serverInstance);
    }

    public String getServerDisplayName(String string) {
        Server server = ServerRegistry.getInstance().getServer(string);
        if (server == null) {
            return null;
        }
        return server.getDisplayName();
    }

    public boolean isRunning(String string) {
        Parameters.notNull((CharSequence)"serverInstanceID", (Object)string);
        org.netbeans.modules.j2ee.deployment.impl.ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
        if (serverInstance == null) {
            return false;
        }
        return serverInstance.isReallyRunning() || serverInstance.isSuspended();
    }

    public final void addInstanceListener(InstanceListener instanceListener) {
        ServerRegistry.getInstance().addInstanceListener(instanceListener);
    }

    public final void removeInstanceListener(InstanceListener instanceListener) {
        ServerRegistry.getInstance().removeInstanceListener(instanceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkListening(J2eeModuleProvider j2eeModuleProvider) {
        WeakHashMap<J2eeModuleProvider, CompileOnSaveListener> weakHashMap = COMPILE_LISTENERS;
        synchronized (weakHashMap) {
            if (COMPILE_LISTENERS.containsKey(j2eeModuleProvider) && j2eeModuleProvider instanceof J2eeApplicationProvider) {
                Deployment.startListening(j2eeModuleProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startListening(J2eeModuleProvider j2eeModuleProvider) {
        WeakHashMap<J2eeModuleProvider, CompileOnSaveListener> weakHashMap = COMPILE_LISTENERS;
        synchronized (weakHashMap) {
            if (COMPILE_LISTENERS.containsKey(j2eeModuleProvider)) {
                if (j2eeModuleProvider instanceof J2eeApplicationProvider) {
                    Deployment.stopListening(j2eeModuleProvider);
                } else {
                    LOGGER.log(Level.FINE, "Already listening on {0}", j2eeModuleProvider);
                    return;
                }
            }
            ArrayList<J2eeModuleProvider> arrayList = new ArrayList<J2eeModuleProvider>(4);
            arrayList.add(j2eeModuleProvider);
            if (j2eeModuleProvider instanceof J2eeApplicationProvider) {
                Collections.addAll(arrayList, ((J2eeApplicationProvider)j2eeModuleProvider).getChildModuleProviders());
            }
            ArrayList<URL> arrayList2 = new ArrayList<URL>();
            for (J2eeModuleProvider object2 : arrayList) {
                for (FileObject fileObject : object2.getSourceFileMap().getSourceRoots()) {
                    URL uRL = URLMapper.findURL((FileObject)fileObject, (int)1);
                    if (uRL == null) continue;
                    arrayList2.add(uRL);
                }
            }
            CompileOnSaveListener compileOnSaveListener = new CompileOnSaveListener(j2eeModuleProvider, arrayList2);
            for (URL uRL : arrayList2) {
                BuildArtifactMapper.addArtifactsUpdatedListener((URL)uRL, (BuildArtifactMapper.ArtifactsUpdated)compileOnSaveListener);
            }
            J2eeModuleProvider.DeployOnSaveSupport deployOnSaveSupport = j2eeModuleProvider.getDeployOnSaveSupport();
            if (deployOnSaveSupport != null) {
                deployOnSaveSupport.addArtifactListener(compileOnSaveListener);
            }
            COMPILE_LISTENERS.put(j2eeModuleProvider, compileOnSaveListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopListening(J2eeModuleProvider j2eeModuleProvider) {
        WeakHashMap<J2eeModuleProvider, CompileOnSaveListener> weakHashMap = COMPILE_LISTENERS;
        synchronized (weakHashMap) {
            CompileOnSaveListener compileOnSaveListener = COMPILE_LISTENERS.remove(j2eeModuleProvider);
            if (compileOnSaveListener == null) {
                LOGGER.log(Level.FINE, "Not listening on {0}", j2eeModuleProvider);
            } else {
                for (URL uRL : compileOnSaveListener.getRegistered()) {
                    BuildArtifactMapper.removeArtifactsUpdatedListener((URL)uRL, (BuildArtifactMapper.ArtifactsUpdated)compileOnSaveListener);
                }
                J2eeModuleProvider.DeployOnSaveSupport deployOnSaveSupport = j2eeModuleProvider.getDeployOnSaveSupport();
                if (deployOnSaveSupport != null) {
                    deployOnSaveSupport.removeArtifactListener(compileOnSaveListener);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompileOnSaveListener
    implements BuildArtifactMapper.ArtifactsUpdated,
    ArtifactListener {
        private final J2eeModuleProvider provider;
        private final List<URL> registered;

        public CompileOnSaveListener(J2eeModuleProvider j2eeModuleProvider, List<URL> list) {
            this.provider = j2eeModuleProvider;
            this.registered = list;
        }

        public List<URL> getRegistered() {
            return this.registered;
        }

        @Override
        public void artifactsUpdated(Iterable<File> iterable) {
            DeployOnSaveManager.getDefault().submitChangedArtifacts(this.provider, iterable);
        }
    }

    public static interface Logger {
        public void log(String var1);
    }

    public static final class DeploymentException
    extends Exception {
        private DeploymentException(String string) {
            super(string);
        }

        private DeploymentException(Throwable throwable) {
            super(throwable);
        }

        private DeploymentException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public String toString() {
            String string = this.getClass().getName();
            String string2 = this.getLocalizedMessage();
            return string2 != null ? string2 : string;
        }
    }
}

