/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.openide.ErrorManager;

class CamelCaseOperations {
    CamelCaseOperations() {
    }

    static int nextCamelCasePosition(JTextComponent jTextComponent) throws BadLocationException {
        String string;
        SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
        if (syntaxSupport == null) {
            return -1;
        }
        int n = jTextComponent.getCaretPosition();
        TokenItem tokenItem = ((ExtSyntaxSupport)syntaxSupport).getTokenChain(n, n + 1);
        if (tokenItem != null && "identifier".equals(tokenItem.getTokenID().getName()) && (string = tokenItem.getImage()) != null && string.length() > 0) {
            int n2 = string.length();
            if (n != tokenItem.getOffset() + n2) {
                char c;
                int n3;
                int n4 = n - tokenItem.getOffset();
                int n5 = n4 + 1;
                if (Character.isUpperCase(string.charAt(n4))) {
                    for (n3 = n5; n3 < n2 && Character.isUpperCase(c = string.charAt(n3)); ++n3) {
                        ++n5;
                    }
                }
                for (n3 = n5; n3 < n2; ++n3) {
                    c = string.charAt(n3);
                    if (!Character.isUpperCase(c)) continue;
                    return tokenItem.getOffset() + n3;
                }
            }
            return tokenItem.getOffset() + string.length();
        }
        return Utilities.getNextWord((JTextComponent)jTextComponent, (int)n);
    }

    static int previousCamelCasePosition(JTextComponent jTextComponent) throws BadLocationException {
        SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
        if (syntaxSupport == null) {
            return -1;
        }
        int n = jTextComponent.getCaretPosition();
        if (n == 0) {
            return -1;
        }
        TokenItem tokenItem = ((ExtSyntaxSupport)syntaxSupport).getTokenChain(n - 1, n);
        if (tokenItem != null) {
            if ("identifier".equals(tokenItem.getTokenID().getName())) {
                String string = tokenItem.getImage();
                if (string != null && string.length() > 0) {
                    int n2 = string.length();
                    int n3 = n - 1 - tokenItem.getOffset();
                    if (Character.isUpperCase(string.charAt(n3))) {
                        for (int i = n3 - 1; i >= 0; --i) {
                            char c = string.charAt(i);
                            if (Character.isUpperCase(c)) continue;
                            return tokenItem.getOffset() + i + 1;
                        }
                        return tokenItem.getOffset();
                    }
                    for (int i = n3 - 1; i >= 0; --i) {
                        char c = string.charAt(i);
                        if (!Character.isUpperCase(c)) continue;
                        for (int j = i; j >= 0; --j) {
                            char c2 = string.charAt(j);
                            if (Character.isUpperCase(c2)) continue;
                            return tokenItem.getOffset() + j + 1;
                        }
                        return tokenItem.getOffset();
                    }
                    return tokenItem.getOffset();
                }
            } else if ("whitespace".equals(tokenItem.getTokenID().getName())) {
                TokenItem tokenItem2 = tokenItem;
                while (tokenItem2 != null && "whitespace".equals(tokenItem2.getTokenID().getName())) {
                    int n4 = tokenItem2.getOffset();
                    tokenItem2 = ((ExtSyntaxSupport)syntaxSupport).getTokenChain(n4 - 1, n4);
                }
                if (tokenItem2 != null) {
                    return tokenItem2.getOffset() + tokenItem2.getImage().length();
                }
            }
        }
        return Utilities.getPreviousWord((JTextComponent)jTextComponent, (int)n);
    }

    static void replaceChar(JTextComponent jTextComponent, int n, char c) {
        if (!jTextComponent.isEditable()) {
            return;
        }
        CamelCaseOperations.replaceText(jTextComponent, n, 1, String.valueOf(c));
    }

    static void replaceText(final JTextComponent jTextComponent, final int n, final int n2, final String string) {
        if (!jTextComponent.isEditable()) {
            return;
        }
        Document document = jTextComponent.getDocument();
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).runAtomic(new Runnable(){

                public void run() {
                    CamelCaseOperations.replaceText2(jTextComponent, n, n2, string);
                }
            });
        } else {
            CamelCaseOperations.replaceText2(jTextComponent, n, n2, string);
        }
    }

    static void replaceText2(JTextComponent jTextComponent, int n, int n2, String string) {
        Document document = jTextComponent.getDocument();
        try {
            if (n2 > 0) {
                document.remove(n, n2);
            }
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }
}

