/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Scope;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.EnumSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.editor.java.JavaCompletionItem;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.LazyCompletionItem;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyTypeCompletionItem
extends JavaCompletionItem
implements LazyCompletionItem {
    private ElementHandle<TypeElement> handle;
    private EnumSet<ElementKind> kinds;
    private JavaSource javaSource;
    private boolean insideNew;
    private String name;
    private String simpleName;
    private String pkgName;
    private JavaCompletionItem delegate = null;
    private CharSequence sortText;
    private int prefWidth = -1;

    public static final LazyTypeCompletionItem create(ElementHandle<TypeElement> elementHandle, EnumSet<ElementKind> enumSet, int n, JavaSource javaSource, boolean bl) {
        return new LazyTypeCompletionItem(elementHandle, enumSet, n, javaSource, bl);
    }

    private LazyTypeCompletionItem(ElementHandle<TypeElement> elementHandle, EnumSet<ElementKind> enumSet, int n, JavaSource javaSource, boolean bl) {
        super(n);
        this.handle = elementHandle;
        this.kinds = enumSet;
        this.javaSource = javaSource;
        this.insideNew = bl;
        this.name = elementHandle.getQualifiedName();
        int n2 = this.name.lastIndexOf(46);
        this.simpleName = n2 > -1 ? this.name.substring(n2 + 1) : this.name;
        this.pkgName = n2 > -1 ? this.name.substring(0, n2) : "";
        this.sortText = this.simpleName + Utilities.getImportanceLevel(this.pkgName) + "#" + this.pkgName;
    }

    public boolean accept() {
        if (this.handle != null) {
            if (this.isAnnonInner()) {
                this.handle = null;
                return false;
            }
            try {
                long l = System.currentTimeMillis();
                this.javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Scope scope = compilationController.getTrees().getScope(compilationController.getTreeUtilities().pathFor(LazyTypeCompletionItem.this.substitutionOffset));
                        if (!LazyTypeCompletionItem.this.isAnnonInner()) {
                            TypeElement typeElement = (TypeElement)LazyTypeCompletionItem.this.handle.resolve((CompilationInfo)compilationController);
                            Elements elements = compilationController.getElements();
                            if (typeElement != null && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(typeElement)) && compilationController.getTrees().isAccessible(scope, typeElement) && LazyTypeCompletionItem.this.isOfKind(typeElement, LazyTypeCompletionItem.this.kinds)) {
                                LazyTypeCompletionItem.this.delegate = JavaCompletionItem.createTypeItem(typeElement, (DeclaredType)typeElement.asType(), LazyTypeCompletionItem.this.substitutionOffset, true, compilationController.getElements().isDeprecated(typeElement), LazyTypeCompletionItem.this.insideNew, false);
                            }
                        }
                        LazyTypeCompletionItem.this.handle = null;
                    }
                }, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.delegate != null;
    }

    @Override
    public void defaultAction(JTextComponent jTextComponent) {
        if (this.delegate != null) {
            this.delegate.defaultAction(jTextComponent);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.delegate != null) {
            this.delegate.processKeyEvent(keyEvent);
        }
    }

    @Override
    public int getPreferredWidth(Graphics graphics, Font font) {
        if (this.prefWidth < 0) {
            this.prefWidth = CompletionUtilities.getPreferredWidth((String)(this.simpleName + " (" + this.pkgName + ")"), null, (Graphics)graphics, (Font)font);
        }
        return this.prefWidth;
    }

    @Override
    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        if (this.delegate != null) {
            this.delegate.render(graphics, font, color, color2, n, n2, bl);
        }
    }

    @Override
    public CompletionTask createDocumentationTask() {
        if (this.delegate != null) {
            return this.delegate.createDocumentationTask();
        }
        return null;
    }

    @Override
    public CompletionTask createToolTipTask() {
        if (this.delegate != null) {
            return this.delegate.createToolTipTask();
        }
        return null;
    }

    public int getSortPriority() {
        return 700;
    }

    public CharSequence getSortText() {
        return this.sortText;
    }

    public CharSequence getInsertPrefix() {
        return this.simpleName;
    }

    boolean isAnnonInner() {
        return this.simpleName.length() == 0 || Character.isDigit(this.simpleName.charAt(0));
    }

    private boolean isOfKind(Element element, EnumSet<ElementKind> enumSet) {
        if (enumSet.contains((Object)element.getKind())) {
            return true;
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (!this.isOfKind(element2, enumSet)) continue;
            return true;
        }
        return false;
    }
}

