/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class ElementNode
extends AbstractNode {
    private Description description;
    private boolean singleSelection;
    private static final Action[] EMPTY_ACTIONS = new Action[0];

    public ElementNode(Description description) {
        this(description, false);
    }

    private ElementNode(Description description, boolean bl) {
        super((Children)(description.subs == null ? Children.LEAF : new ElementChilren(description.subs, bl)), Lookups.singleton((Object)description));
        this.description = description;
        description.node = this;
        this.setDisplayName(description.name);
    }

    public void setSingleSelection(boolean bl) {
        this.singleSelection = bl;
    }

    public Image getIcon(int n) {
        if (this.description.elementHandle == null) {
            return super.getIcon(n);
        }
        return Utilities.icon2Image((Icon)ElementIcons.getElementIcon((ElementKind)this.description.elementHandle.getKind(), (Collection)this.description.modifiers));
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getDisplayName() {
        return this.description.name;
    }

    public String getHtmlDisplayName() {
        return this.description.htmlHeader;
    }

    public Action[] getActions(boolean bl) {
        return EMPTY_ACTIONS;
    }

    public void assureSingleSelection() {
        Description description;
        Node node = this.getParentNode();
        if (node == null && this.singleSelection) {
            this.description.deepSetSelected(false);
        } else if (node != null && (description = (Description)node.getLookup().lookup(Description.class)) != null) {
            description.node.assureSingleSelection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Description {
        public static final Comparator<Description> ALPHA_COMPARATOR = new DescriptionComparator();
        private ElementNode node;
        private String name;
        private ElementHandle<? extends Element> elementHandle;
        private Set<Modifier> modifiers;
        private List<Description> subs;
        private String htmlHeader;
        private boolean isSelected;
        private boolean isSelectable;

        public static Description create(List<Description> list) {
            return new Description("<root>", null, null, list, null, false, false);
        }

        public static Description create(Element element, List<Description> list, boolean bl, boolean bl2) {
            String string = null;
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    string = Description.createHtmlHeader((TypeElement)element);
                    break;
                }
                case ENUM_CONSTANT: 
                case FIELD: {
                    string = Description.createHtmlHeader((VariableElement)element);
                    break;
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    string = Description.createHtmlHeader((ExecutableElement)element);
                }
            }
            return new Description(element.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)element), element.getModifiers(), list, string, bl, bl2);
        }

        private Description(String string, ElementHandle<? extends Element> elementHandle, Set<Modifier> set, List<Description> list, String string2, boolean bl, boolean bl2) {
            this.name = string;
            this.elementHandle = elementHandle;
            this.modifiers = set;
            this.subs = list;
            this.htmlHeader = string2;
            this.isSelectable = bl;
            this.isSelected = bl2;
        }

        public boolean isSelectable() {
            return this.isSelectable;
        }

        public boolean hasSelectableSubs() {
            if (null == this.subs) {
                return false;
            }
            for (Description description : this.getSubs()) {
                if (!description.isSelectable()) continue;
                return true;
            }
            return false;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public List<Description> getSubs() {
            return this.subs;
        }

        public void setSelected(boolean bl) {
            if (bl && this.node != null) {
                this.node.assureSingleSelection();
            }
            this.isSelected = bl;
            if (this.node != null) {
                this.node.fireDisplayNameChange(null, null);
            }
        }

        public void deepSetSelected(boolean bl) {
            if (this.isSelectable() && bl != this.isSelected()) {
                this.setSelected(bl);
            }
            if (this.subs != null) {
                for (Description description : this.subs) {
                    description.deepSetSelected(bl);
                }
            }
        }

        public ElementHandle<? extends Element> getElementHandle() {
            return this.elementHandle;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Description)) {
                return false;
            }
            Description description = (Description)object;
            if (!this.name.equals(description.name)) {
                return false;
            }
            if (this.elementHandle != description.elementHandle) {
                if (this.elementHandle == null || description.elementHandle == null) {
                    return false;
                }
                if (this.elementHandle.getKind() != description.elementHandle.getKind()) {
                    return false;
                }
                if (!this.elementHandle.signatureEquals(description.elementHandle)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.name != null ? this.name.hashCode() : 0);
            n = 29 * n + (this.elementHandle != null ? this.elementHandle.getKind().hashCode() : 0);
            return n;
        }

        public String getName() {
            return this.name;
        }

        public static Description deepCopy(Description description) {
            ArrayList<Description> arrayList;
            if (description.subs == null) {
                arrayList = null;
            } else {
                arrayList = new ArrayList<Description>(description.subs.size());
                for (Description description2 : description.subs) {
                    arrayList.add(Description.deepCopy(description2));
                }
            }
            return new Description(description.name, description.elementHandle, description.modifiers, arrayList, description.htmlHeader, description.isSelectable, description.isSelected);
        }

        private static String createHtmlHeader(ExecutableElement executableElement) {
            StringBuilder stringBuilder = new StringBuilder();
            if (executableElement.getKind() == ElementKind.CONSTRUCTOR) {
                stringBuilder.append(executableElement.getEnclosingElement().getSimpleName());
            } else {
                stringBuilder.append(executableElement.getSimpleName());
            }
            stringBuilder.append("(");
            Object object = executableElement.getParameters().iterator();
            while (object.hasNext()) {
                VariableElement variableElement = object.next();
                if (!object.hasNext() && executableElement.isVarArgs() && variableElement.asType().getKind() == TypeKind.ARRAY) {
                    stringBuilder.append(Description.print(((ArrayType)variableElement.asType()).getComponentType()));
                    stringBuilder.append("...");
                } else {
                    stringBuilder.append(Description.print(variableElement.asType()));
                }
                stringBuilder.append(" ");
                stringBuilder.append(variableElement.getSimpleName());
                if (!object.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
            if (executableElement.getKind() != ElementKind.CONSTRUCTOR && (object = executableElement.getReturnType()).getKind() != TypeKind.VOID) {
                stringBuilder.append(" : ");
                stringBuilder.append(Description.print(executableElement.getReturnType()));
            }
            return stringBuilder.toString();
        }

        private static String createHtmlHeader(VariableElement variableElement) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(variableElement.getSimpleName());
            if (variableElement.getKind() != ElementKind.ENUM_CONSTANT) {
                stringBuilder.append(" : ");
                stringBuilder.append(Description.print(variableElement.asType()));
            }
            return stringBuilder.toString();
        }

        private static String createHtmlHeader(TypeElement typeElement) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(typeElement.getSimpleName());
            List<? extends TypeParameterElement> list = typeElement.getTypeParameters();
            if (list != null && !list.isEmpty()) {
                stringBuilder.append("<");
                Iterator<? extends TypeParameterElement> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TypeParameterElement typeParameterElement = iterator.next();
                    stringBuilder.append(typeParameterElement.getSimpleName());
                    try {
                        List<? extends TypeMirror> list2 = typeParameterElement.getBounds();
                        if (!list2.isEmpty()) {
                            stringBuilder.append(Description.printBounds(list2));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(">");
            }
            return stringBuilder.toString();
        }

        private static String printBounds(List<? extends TypeMirror> list) {
            if (list.size() == 1 && "java.lang.Object".equals(((Object)list.get(0)).toString())) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" extends ");
            Iterator<? extends TypeMirror> iterator = list.iterator();
            while (iterator.hasNext()) {
                TypeMirror typeMirror = iterator.next();
                stringBuilder.append(Description.print(typeMirror));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" & ");
            }
            return stringBuilder.toString();
        }

        private static String print(TypeMirror typeMirror) {
            switch (typeMirror.getKind()) {
                case DECLARED: {
                    DeclaredType declaredType = (DeclaredType)typeMirror;
                    StringBuilder stringBuilder = new StringBuilder(declaredType.asElement().getSimpleName().toString());
                    List<? extends TypeMirror> list = declaredType.getTypeArguments();
                    if (!list.isEmpty()) {
                        stringBuilder.append("<");
                        Iterator<? extends TypeMirror> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            TypeMirror typeMirror2 = iterator.next();
                            stringBuilder.append(Description.print(typeMirror2));
                            if (!iterator.hasNext()) continue;
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(">");
                    }
                    return stringBuilder.toString();
                }
                case TYPEVAR: {
                    TypeVariable typeVariable = (TypeVariable)typeMirror;
                    StringBuilder stringBuilder = new StringBuilder(typeVariable.asElement().getSimpleName().toString());
                    return stringBuilder.toString();
                }
                case ARRAY: {
                    ArrayType arrayType = (ArrayType)typeMirror;
                    StringBuilder stringBuilder = new StringBuilder(Description.print(arrayType.getComponentType()));
                    stringBuilder.append("[]");
                    return stringBuilder.toString();
                }
                case WILDCARD: {
                    WildcardType wildcardType = (WildcardType)typeMirror;
                    StringBuilder stringBuilder = new StringBuilder("?");
                    if (wildcardType.getExtendsBound() != null) {
                        stringBuilder.append(" extends ");
                        stringBuilder.append(Description.print(wildcardType.getExtendsBound()));
                    }
                    if (wildcardType.getSuperBound() != null) {
                        stringBuilder.append(" super ");
                        stringBuilder.append(Description.print(wildcardType.getSuperBound()));
                    }
                    return stringBuilder.toString();
                }
            }
            return ((Object)typeMirror).toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DescriptionComparator
        implements Comparator<Description> {
            private DescriptionComparator() {
            }

            @Override
            public int compare(Description description, Description description2) {
                if (this.k2i(description.elementHandle.getKind()) != this.k2i(description2.elementHandle.getKind())) {
                    return this.k2i(description.elementHandle.getKind()) - this.k2i(description2.elementHandle.getKind());
                }
                return description.name.compareTo(description2.name);
            }

            int k2i(ElementKind elementKind) {
                switch (elementKind) {
                    case CONSTRUCTOR: {
                        return 1;
                    }
                    case METHOD: {
                        return 2;
                    }
                    case FIELD: {
                        return 3;
                    }
                    case CLASS: {
                        return 4;
                    }
                    case INTERFACE: {
                        return 5;
                    }
                    case ENUM: {
                        return 6;
                    }
                    case ANNOTATION_TYPE: {
                        return 7;
                    }
                }
                return 100;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementChilren
    extends Children.Keys<Description> {
        public ElementChilren(List<Description> list, boolean bl) {
            if (bl) {
                Collections.sort(list, Description.ALPHA_COMPARATOR);
            }
            this.setKeys(list);
        }

        protected Node[] createNodes(Description description) {
            return new Node[]{new ElementNode(description, true)};
        }
    }
}

